/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.expressions.inferrer;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.yakindu.base.expressions.expressions.AdditiveOperator;
import org.yakindu.base.expressions.expressions.AssignmentOperator;
import org.yakindu.base.expressions.expressions.BitwiseAndExpression;
import org.yakindu.base.expressions.expressions.BitwiseOrExpression;
import org.yakindu.base.expressions.expressions.BitwiseXorExpression;
import org.yakindu.base.expressions.expressions.BoolLiteral;
import org.yakindu.base.expressions.expressions.ConditionalExpression;
import org.yakindu.base.expressions.expressions.Expression;
import org.yakindu.base.expressions.expressions.HexLiteral;
import org.yakindu.base.expressions.expressions.IntLiteral;
import org.yakindu.base.expressions.expressions.Literal;
import org.yakindu.base.expressions.expressions.LogicalAndExpression;
import org.yakindu.base.expressions.expressions.LogicalNotExpression;
import org.yakindu.base.expressions.expressions.LogicalOrExpression;
import org.yakindu.base.expressions.expressions.LogicalRelationExpression;
import org.yakindu.base.expressions.expressions.MultiplicativeOperator;
import org.yakindu.base.expressions.expressions.NullLiteral;
import org.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import org.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import org.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import org.yakindu.base.expressions.expressions.ParenthesizedExpression;
import org.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import org.yakindu.base.expressions.expressions.RealLiteral;
import org.yakindu.base.expressions.expressions.RelationalOperator;
import org.yakindu.base.expressions.expressions.ShiftExpression;
import org.yakindu.base.expressions.expressions.ShiftOperator;
import org.yakindu.base.expressions.expressions.StringLiteral;
import org.yakindu.base.expressions.expressions.TypeCastExpression;
import org.yakindu.base.expressions.expressions.UnaryOperator;
import org.yakindu.base.expressions.inferrer.IExpressionsTypeInferrer;
import org.yakindu.base.types.EnumerationType;
import org.yakindu.base.types.Enumerator;
import org.yakindu.base.types.ITypeSystem;
import org.yakindu.base.types.InferenceIssue;
import org.yakindu.base.types.InferenceResult;
import org.yakindu.base.types.InferredType;
import org.yakindu.base.types.Type;
import org.yakindu.base.types.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultExpressionsTypeInferrer
implements IExpressionsTypeInferrer {
    @Inject
    @Extension
    protected ITypeSystem ts;

    @Override
    public InferenceResult inferType(Expression e) {
        boolean _equals = Objects.equal((Object)e, null);
        if (_equals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Expression may not be null");
            throw _illegalArgumentException;
        }
        return this.doInferType(e);
    }

    protected InferenceResult _doInferType(TypedElement typedElement) {
        Type _type = typedElement.getType();
        boolean _equals = Objects.equal((Object)_type, null);
        if (_equals) {
            String _plus = "Could not infer type of typedelement: " + typedElement;
            InferenceIssue _inferenceIssue = new InferenceIssue(_plus, 4);
            InferenceResult _inferenceResult = new InferenceResult(null, _inferenceIssue);
            return _inferenceResult;
        }
        Type _type_1 = typedElement.getType();
        InferredType _inferredType = new InferredType(_type_1);
        InferenceResult _inferenceResult_1 = new InferenceResult(_inferredType);
        return _inferenceResult_1;
    }

    protected InferenceResult _doInferType(Enumerator enumerator) {
        EnumerationType _owningEnumeration = enumerator.getOwningEnumeration();
        InferredType _inferredType = new InferredType((Type)_owningEnumeration);
        InferenceResult _inferenceResult = new InferenceResult(_inferredType);
        return _inferenceResult;
    }

    public InferenceResult inferResult(InferenceResult operand, ITypeSystem.ITypeSystemOperator unaryOperator) {
        boolean _notEquals;
        InferredType _type = operand.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            InferredType _type_1 = operand.getType();
            return this.ts.inferType(_type_1, unaryOperator);
        }
        Collection _issues = operand.getIssues();
        InferenceResult _inferenceResult = new InferenceResult(null, _issues);
        return _inferenceResult;
    }

    public InferenceResult inferResult(InferenceResult firstOperand, InferenceResult secondOperand, ITypeSystem.ITypeSystemOperator binaryOperator) {
        boolean _notEquals;
        boolean _and = false;
        InferredType _type = firstOperand.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (!_notEquals) {
            _and = false;
        } else {
            InferredType _type_1 = secondOperand.getType();
            boolean _notEquals_1 = !Objects.equal((Object)_type_1, null);
            boolean bl2 = _and = _notEquals && _notEquals_1;
        }
        if (_and) {
            InferredType _type_2 = firstOperand.getType();
            InferredType _type_3 = secondOperand.getType();
            InferenceResult result = this.ts.inferType(_type_2, _type_3, binaryOperator);
            Collection _issues = null;
            if (result != null) {
                _issues = result.getIssues();
            }
            Collection _issues_1 = firstOperand.getIssues();
            _issues.addAll(_issues_1);
            Collection _issues_2 = null;
            if (result != null) {
                _issues_2 = result.getIssues();
            }
            Collection _issues_3 = secondOperand.getIssues();
            _issues_2.addAll(_issues_3);
            return result;
        }
        Collection _issues_4 = firstOperand.getIssues();
        Collection _issues_5 = secondOperand.getIssues();
        Iterable _concat = Iterables.concat((Iterable)_issues_4, (Iterable)_issues_5);
        List _list = IterableExtensions.toList((Iterable)_concat);
        InferenceResult _inferenceResult = new InferenceResult(null, (Collection)_list);
        return _inferenceResult;
    }

    public InferenceResult inferResult(InferenceResult firstOperand, InferenceResult secondOperand, InferenceResult thirdOperand, ITypeSystem.ITypeSystemOperator ternaryOperator) {
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        InferredType _type = firstOperand.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (!_notEquals) {
            _and_1 = false;
        } else {
            InferredType _type_1 = secondOperand.getType();
            boolean _notEquals_1 = !Objects.equal((Object)_type_1, null);
            boolean bl2 = _and_1 = _notEquals && _notEquals_1;
        }
        if (!_and_1) {
            _and = false;
        } else {
            InferredType _type_2 = thirdOperand.getType();
            boolean _notEquals_2 = !Objects.equal((Object)_type_2, null);
            boolean bl3 = _and = _and_1 && _notEquals_2;
        }
        if (_and) {
            InferredType _type_3 = firstOperand.getType();
            InferredType _type_4 = secondOperand.getType();
            InferredType _type_5 = thirdOperand.getType();
            InferenceResult result = this.ts.inferType(_type_3, _type_4, _type_5, ternaryOperator);
            Collection _issues = result.getIssues();
            Collection _issues_1 = firstOperand.getIssues();
            _issues.addAll(_issues_1);
            Collection _issues_2 = result.getIssues();
            Collection _issues_3 = secondOperand.getIssues();
            _issues_2.addAll(_issues_3);
            Collection _issues_4 = result.getIssues();
            Collection _issues_5 = thirdOperand.getIssues();
            _issues_4.addAll(_issues_5);
            return result;
        }
        Collection _issues_6 = firstOperand.getIssues();
        Collection _issues_7 = secondOperand.getIssues();
        Iterable _concat = Iterables.concat((Iterable)_issues_6, (Iterable)_issues_7);
        List _list = IterableExtensions.toList((Iterable)_concat);
        InferenceResult _inferenceResult = new InferenceResult(null, (Collection)_list);
        return _inferenceResult;
    }

    protected InferenceResult _doInferType(LogicalAndExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        return this.inferResult(_doInferType, _doInferType_1, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.LOGICAL_AND);
    }

    protected InferenceResult _doInferType(LogicalOrExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        return this.inferResult(_doInferType, _doInferType_1, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.LOGICAL_OR);
    }

    protected InferenceResult _doInferType(LogicalNotExpression expression) {
        Expression _operand = expression.getOperand();
        InferenceResult _doInferType = this.doInferType(_operand);
        return this.inferResult(_doInferType, (ITypeSystem.ITypeSystemOperator)ITypeSystem.UnaryOperators.LOGICAL_NOT);
    }

    protected InferenceResult _doInferType(BitwiseAndExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        return this.inferResult(_doInferType, _doInferType_1, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.BITWISE_AND);
    }

    protected InferenceResult _doInferType(BitwiseOrExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        return this.inferResult(_doInferType, _doInferType_1, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.BITWISE_OR);
    }

    protected InferenceResult _doInferType(BitwiseXorExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        return this.inferResult(_doInferType, _doInferType_1, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.BITWISE_XOR);
    }

    protected InferenceResult _doInferType(LogicalRelationExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        RelationalOperator _operator = expression.getOperator();
        ITypeSystem.ITypeSystemOperator _typeSystemOperator = this.getTypeSystemOperator(_operator);
        return this.inferResult(_doInferType, _doInferType_1, _typeSystemOperator);
    }

    protected InferenceResult _doInferType(NumericalAddSubtractExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        AdditiveOperator _operator = expression.getOperator();
        ITypeSystem.ITypeSystemOperator _typeSystemOperator = this.getTypeSystemOperator(_operator);
        return this.inferResult(_doInferType, _doInferType_1, _typeSystemOperator);
    }

    protected InferenceResult _doInferType(NumericalMultiplyDivideExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        MultiplicativeOperator _operator = expression.getOperator();
        ITypeSystem.ITypeSystemOperator _typeSystemOperator = this.getTypeSystemOperator(_operator);
        return this.inferResult(_doInferType, _doInferType_1, _typeSystemOperator);
    }

    protected InferenceResult _doInferType(NumericalUnaryExpression expression) {
        Expression _operand = expression.getOperand();
        InferenceResult _doInferType = this.doInferType(_operand);
        UnaryOperator _operator = expression.getOperator();
        ITypeSystem.ITypeSystemOperator _typeSystemOperator = this.getTypeSystemOperator(_operator);
        return this.inferResult(_doInferType, _typeSystemOperator);
    }

    protected InferenceResult _doInferType(PrimitiveValueExpression expression) {
        Literal _value = expression.getValue();
        return this.doInferType(_value);
    }

    protected InferenceResult _doInferType(TypeCastExpression expression) {
        Expression _operand = expression.getOperand();
        InferenceResult _doInferType = this.doInferType(_operand);
        Type _type = expression.getType();
        InferenceResult _inferenceResult = new InferenceResult(_type);
        return this.inferResult(_doInferType, _inferenceResult, (ITypeSystem.ITypeSystemOperator)ITypeSystem.BinaryOperators.CAST);
    }

    protected InferenceResult _doInferType(ShiftExpression expression) {
        Expression _leftOperand = expression.getLeftOperand();
        InferenceResult _doInferType = this.doInferType(_leftOperand);
        Expression _rightOperand = expression.getRightOperand();
        InferenceResult _doInferType_1 = this.doInferType(_rightOperand);
        ShiftOperator _operator = expression.getOperator();
        ITypeSystem.ITypeSystemOperator _typeSystemOperator = this.getTypeSystemOperator(_operator);
        return this.inferResult(_doInferType, _doInferType_1, _typeSystemOperator);
    }

    protected InferenceResult _doInferType(ConditionalExpression expression) {
        Expression _condition = expression.getCondition();
        InferenceResult _doInferType = this.doInferType(_condition);
        Expression _trueCase = expression.getTrueCase();
        InferenceResult _doInferType_1 = this.doInferType(_trueCase);
        Expression _falseCase = expression.getFalseCase();
        InferenceResult _doInferType_2 = this.doInferType(_falseCase);
        return this.inferResult(_doInferType, _doInferType_1, _doInferType_2, (ITypeSystem.ITypeSystemOperator)ITypeSystem.TernaryOperators.CONDITIONAL);
    }

    protected InferenceResult _doInferType(StringLiteral literal) {
        String _value = literal.getValue();
        return this.ts.inferTypeForLiteral((Object)_value);
    }

    protected InferenceResult _doInferType(BoolLiteral literal) {
        boolean _isValue = literal.isValue();
        return this.ts.inferTypeForLiteral((Object)_isValue);
    }

    protected InferenceResult _doInferType(RealLiteral literal) {
        double _value = literal.getValue();
        return this.ts.inferTypeForLiteral((Object)_value);
    }

    protected InferenceResult _doInferType(HexLiteral literal) {
        int _value = literal.getValue();
        return this.ts.inferTypeForLiteral((Object)_value);
    }

    protected InferenceResult _doInferType(IntLiteral literal) {
        int _value = literal.getValue();
        return this.ts.inferTypeForLiteral((Object)_value);
    }

    protected InferenceResult _doInferType(NullLiteral literal) {
        return this.ts.inferTypeForLiteral(null);
    }

    protected InferenceResult _doInferType(Literal l) {
        String _plus = "Unsupported literal kind " + l;
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
        throw _illegalArgumentException;
    }

    protected InferenceResult _doInferType(EObject e) {
        return this.ts.inferTypeForLiteral((Object)e);
    }

    protected InferenceResult _doInferType(ParenthesizedExpression expression) {
        Expression _expression = expression.getExpression();
        return this.doInferType(_expression);
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(UnaryOperator operator) {
        ITypeSystem.UnaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)UnaryOperator.COMPLEMENT))) {
            _matched = true;
            _switchResult = ITypeSystem.UnaryOperators.COMPLEMENT;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)UnaryOperator.NEGATIVE))) {
            _matched = true;
            _switchResult = ITypeSystem.UnaryOperators.NEGATIVE;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)UnaryOperator.POSITIVE))) {
            _matched = true;
            _switchResult = ITypeSystem.UnaryOperators.POSITIVE;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(AssignmentOperator operator) {
        ITypeSystem.BinaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.ADD_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_ADD;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.AND_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_BITWISE_AND;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.DIV_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_DIV;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.LEFT_SHIFT_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_LEFT_SHIFT;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.MOD_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_MOD;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.MULT_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_MULTIPLY;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.OR_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_BITWISE_OR;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.RIGHT_SHIFT_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_RIGHT_SHIFT;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.SUB_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_SUBTRACT;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AssignmentOperator.XOR_ASSIGN))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ASSIGN_BITWISE_XOR;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(ShiftOperator operator) {
        ITypeSystem.BinaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)ShiftOperator.LEFT))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.LEFT_SHIFT;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)ShiftOperator.RIGHT))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.RIGHT_SHIFT;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(AdditiveOperator operator) {
        ITypeSystem.BinaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AdditiveOperator.PLUS))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.ADD;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)AdditiveOperator.MINUS))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.SUBTRACT;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(MultiplicativeOperator operator) {
        ITypeSystem.BinaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)MultiplicativeOperator.DIV))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.DIV;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)MultiplicativeOperator.MOD))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.MOD;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)MultiplicativeOperator.MUL))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.MULTIPLY;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    protected ITypeSystem.ITypeSystemOperator _getTypeSystemOperator(RelationalOperator operator) {
        ITypeSystem.BinaryOperators _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.EQUALS))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.EQUAL;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.NOT_EQUALS))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.NOT_EQUAL;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.GREATER))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.GREATER;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.GREATER_EQUAL))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.GREATER_EQUAL;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.SMALLER))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.SMALLER;
        }
        if (!_matched && Objects.equal((Object)((Object)operator), (Object)((Object)RelationalOperator.SMALLER_EQUAL))) {
            _matched = true;
            _switchResult = ITypeSystem.BinaryOperators.SMALLER_EQUAL;
        }
        if (!_matched) {
            String _plus = "Unsupported operator" + (Object)((Object)operator);
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        return _switchResult;
    }

    public InferenceResult doInferType(EObject expression) {
        if (expression instanceof BitwiseAndExpression) {
            return this._doInferType((BitwiseAndExpression)expression);
        }
        if (expression instanceof BitwiseOrExpression) {
            return this._doInferType((BitwiseOrExpression)expression);
        }
        if (expression instanceof BitwiseXorExpression) {
            return this._doInferType((BitwiseXorExpression)expression);
        }
        if (expression instanceof BoolLiteral) {
            return this._doInferType((BoolLiteral)expression);
        }
        if (expression instanceof ConditionalExpression) {
            return this._doInferType((ConditionalExpression)expression);
        }
        if (expression instanceof HexLiteral) {
            return this._doInferType((HexLiteral)expression);
        }
        if (expression instanceof IntLiteral) {
            return this._doInferType((IntLiteral)expression);
        }
        if (expression instanceof LogicalAndExpression) {
            return this._doInferType((LogicalAndExpression)expression);
        }
        if (expression instanceof LogicalNotExpression) {
            return this._doInferType((LogicalNotExpression)expression);
        }
        if (expression instanceof LogicalOrExpression) {
            return this._doInferType((LogicalOrExpression)expression);
        }
        if (expression instanceof LogicalRelationExpression) {
            return this._doInferType((LogicalRelationExpression)expression);
        }
        if (expression instanceof NullLiteral) {
            return this._doInferType((NullLiteral)expression);
        }
        if (expression instanceof NumericalAddSubtractExpression) {
            return this._doInferType((NumericalAddSubtractExpression)expression);
        }
        if (expression instanceof NumericalMultiplyDivideExpression) {
            return this._doInferType((NumericalMultiplyDivideExpression)expression);
        }
        if (expression instanceof NumericalUnaryExpression) {
            return this._doInferType((NumericalUnaryExpression)expression);
        }
        if (expression instanceof ParenthesizedExpression) {
            return this._doInferType((ParenthesizedExpression)expression);
        }
        if (expression instanceof PrimitiveValueExpression) {
            return this._doInferType((PrimitiveValueExpression)expression);
        }
        if (expression instanceof RealLiteral) {
            return this._doInferType((RealLiteral)expression);
        }
        if (expression instanceof ShiftExpression) {
            return this._doInferType((ShiftExpression)expression);
        }
        if (expression instanceof StringLiteral) {
            return this._doInferType((StringLiteral)expression);
        }
        if (expression instanceof TypeCastExpression) {
            return this._doInferType((TypeCastExpression)expression);
        }
        if (expression instanceof Enumerator) {
            return this._doInferType((Enumerator)expression);
        }
        if (expression instanceof Literal) {
            return this._doInferType((Literal)expression);
        }
        if (expression instanceof TypedElement) {
            return this._doInferType((TypedElement)expression);
        }
        if (expression != null) {
            return this._doInferType(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    public ITypeSystem.ITypeSystemOperator getTypeSystemOperator(Enum<? extends Object> operator) {
        if (operator instanceof AdditiveOperator) {
            return this._getTypeSystemOperator((AdditiveOperator)operator);
        }
        if (operator instanceof AssignmentOperator) {
            return this._getTypeSystemOperator((AssignmentOperator)operator);
        }
        if (operator instanceof MultiplicativeOperator) {
            return this._getTypeSystemOperator((MultiplicativeOperator)operator);
        }
        if (operator instanceof RelationalOperator) {
            return this._getTypeSystemOperator((RelationalOperator)operator);
        }
        if (operator instanceof ShiftOperator) {
            return this._getTypeSystemOperator((ShiftOperator)operator);
        }
        if (operator instanceof UnaryOperator) {
            return this._getTypeSystemOperator((UnaryOperator)operator);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(operator).toString());
    }
}

