/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.expressions.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationalOperator implements Enumerator
{
    SMALLER(0, "smaller", "<"),
    SMALLER_EQUAL(1, "smallerEqual", "<="),
    GREATER(2, "greater", ">"),
    GREATER_EQUAL(3, "greaterEqual", ">="),
    EQUALS(4, "equals", "=="),
    NOT_EQUALS(5, "notEquals", "!=");

    public static final int SMALLER_VALUE = 0;
    public static final int SMALLER_EQUAL_VALUE = 1;
    public static final int GREATER_VALUE = 2;
    public static final int GREATER_EQUAL_VALUE = 3;
    public static final int EQUALS_VALUE = 4;
    public static final int NOT_EQUALS_VALUE = 5;
    private static final RelationalOperator[] VALUES_ARRAY;
    public static final List<RelationalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationalOperator[]{SMALLER, SMALLER_EQUAL, GREATER, GREATER_EQUAL, EQUALS, NOT_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationalOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperator get(int value) {
        switch (value) {
            case 0: {
                return SMALLER;
            }
            case 1: {
                return SMALLER_EQUAL;
            }
            case 2: {
                return GREATER;
            }
            case 3: {
                return GREATER_EQUAL;
            }
            case 4: {
                return EQUALS;
            }
            case 5: {
                return NOT_EQUALS;
            }
        }
        return null;
    }

    private RelationalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

