/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ISequenceNodeMoveOperation
extends AbstractModelChangeOperation<Void> {
    private final Collection<ISequenceNode> seqNodes = Sets.newHashSet();
    private final int logicalShift;

    public ISequenceNodeMoveOperation(ISequenceNode node, int logicalShift) {
        super("Move sequence node");
        this.seqNodes.add((ISequenceNode)Preconditions.checkNotNull((Object)node));
        this.logicalShift = logicalShift;
    }

    public ISequenceNodeMoveOperation(Collection<ISequenceNode> nodes, int logicalShift) {
        super("Move sequence node");
        Preconditions.checkNotNull(nodes);
        this.seqNodes.addAll(nodes);
        this.logicalShift = logicalShift;
    }

    public Void execute() {
        for (ISequenceNode seqNode : this.seqNodes) {
            Node node = seqNode.getNotationNode();
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (!(layoutConstraint instanceof Location) || this.logicalShift == 0) continue;
            Location location = (Location)layoutConstraint;
            location.setY(location.getY() + this.logicalShift);
        }
        return null;
    }
}

