/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.AllContents;

public class SequenceDiagram
extends AbstractSequenceElement {
    private static final String INTERNAL_ERROR = "Internal error.";

    SequenceDiagram(Diagram diagram) {
        super((View)diagram);
        Preconditions.checkArgument((boolean)SequenceDiagram.notationPredicate().apply((Object)diagram), (Object)"The diagram does not represent a sequence diagram.");
    }

    public static Predicate<View> notationPredicate() {
        return NotationPredicate.INSTANCE;
    }

    public static Predicate<DDiagram> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public Diagram getNotationDiagram() {
        return (Diagram)this.view;
    }

    public SequenceDDiagram getSequenceDDiagram() {
        return (SequenceDDiagram)this.view.getElement();
    }

    public Set<Lifeline> getGraphicallyCoveredLifelines(final Rectangle area) {
        ArrayList result = Lists.newArrayList();
        Iterables.addAll((Collection)result, (Iterable)Iterables.filter(this.getAllLifelines(), (Predicate)new Predicate<Lifeline>(){

            public boolean apply(Lifeline input) {
                return input.getProperLogicalBounds().intersects(area) && input.getVerticalRange().includes(area.getTop().y);
            }
        }));
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public List<InstanceRole> getSortedInstanceRole() {
        Function<InstanceRole, Integer> xLocation = new Function<InstanceRole, Integer>(){

            public Integer apply(InstanceRole from) {
                Rectangle bounds = from.getBounds();
                return bounds.x;
            }
        };
        ArrayList allInstanceRoles = Lists.newArrayList(this.getAllInstanceRoles());
        Collections.sort(allInstanceRoles, Ordering.natural().onResultOf((Function)xLocation));
        return allInstanceRoles;
    }

    public Collection<InstanceRole> getAllInstanceRoles() {
        ArrayList result = Lists.newArrayList();
        for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
            Option<InstanceRole> instanceRole;
            if (!InstanceRole.notationPredicate().apply((Object)child) || !(instanceRole = ISequenceElementAccessor.getInstanceRole(child)).some()) continue;
            result.add((InstanceRole)instanceRole.get());
        }
        return result;
    }

    public List<Lifeline> getAllLifelines() {
        Collection<InstanceRole> allInstanceRoles = this.getAllInstanceRoles();
        Function<ISequenceNode, Lifeline> lifelineFunction = new Function<ISequenceNode, Lifeline>(){

            public Lifeline apply(ISequenceNode from) {
                return (Lifeline)from.getLifeline().get();
            }
        };
        ArrayList result = Lists.newArrayList((Iterable)Iterables.transform(allInstanceRoles, (Function)lifelineFunction));
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return result;
    }

    public Collection<ObservationPoint> getAllObservationPoints() {
        ArrayList result = Lists.newArrayList();
        for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
            Option<ObservationPoint> obsPoint;
            if (!ObservationPoint.notationPredicate().apply((Object)child) || !(obsPoint = ISequenceElementAccessor.getObservationPoint(child)).some()) continue;
            result.add((ObservationPoint)obsPoint.get());
        }
        return result;
    }

    public Collection<LostMessageEnd> getAllLostMessageEnds() {
        ArrayList result = Lists.newArrayList();
        for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
            Option<LostMessageEnd> lostMessageEnd;
            if (!LostMessageEnd.notationPredicate().apply((Object)child) || !(lostMessageEnd = ISequenceElementAccessor.getLostMessageEnd(child)).some()) continue;
            result.add((LostMessageEnd)lostMessageEnd.get());
        }
        return result;
    }

    public Set<Message> getAllMessages() {
        ArrayList result = Lists.newArrayList();
        for (Edge edge : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getEdges(), Edge.class), Message.notationPredicate())) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
            assert (message.some()) : "Internal error.";
            result.add((Message)message.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<AbstractNodeEvent> getAllAbstractNodeEvents() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), AbstractNodeEvent.notationPredicate())) {
            Option<AbstractNodeEvent> exec = ISequenceElementAccessor.getAbstractNodeEvent((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((AbstractNodeEvent)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<Execution> getAllExecutions() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), Execution.notationPredicate())) {
            Option<Execution> exec = ISequenceElementAccessor.getExecution((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((Execution)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<State> getAllStates() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), State.notationPredicate())) {
            Option<State> exec = ISequenceElementAccessor.getState((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((State)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Collection<AbstractFrame> getAllFrames() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), AbstractFrame.notationPredicate())) {
            Option<ISequenceEvent> exec = ISequenceElementAccessor.getISequenceEvent((View)node);
            assert (exec.some()) : "Internal error.";
            if (!(exec.get() instanceof AbstractFrame)) continue;
            result.add((AbstractFrame)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<InteractionUse> getAllInteractionUses() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), InteractionUse.notationPredicate())) {
            Option<InteractionUse> exec = ISequenceElementAccessor.getInteractionUse((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((InteractionUse)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<CombinedFragment> getAllCombinedFragments() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), CombinedFragment.notationPredicate())) {
            Option<CombinedFragment> exec = ISequenceElementAccessor.getCombinedFragment((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((CombinedFragment)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<Operand> getAllOperands() {
        ArrayList result = Lists.newArrayList();
        for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), Operand.notationPredicate())) {
            Option<Operand> exec = ISequenceElementAccessor.getOperand((View)node);
            assert (exec.some()) : "Internal error.";
            result.add((Operand)exec.get());
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Set<EndOfLife> getAllEndOfLifes() {
        HashSet<EndOfLife> allEndOfLifes = new HashSet<EndOfLife>();
        for (Lifeline lifeline : this.getAllLifelines()) {
            if (!lifeline.getEndOfLife().some()) continue;
            allEndOfLifes.add((EndOfLife)lifeline.getEndOfLife().get());
        }
        return allEndOfLifes;
    }

    public Set<ISequenceEvent> getAllOrderedDelimitedSequenceEvents() {
        ArrayList result = Lists.newArrayList();
        Iterables.addAll((Collection)result, this.getAllDelimitedSequenceEvents());
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet((Iterable)result);
    }

    public Iterable<? extends ISequenceEvent> getAllDelimitedSequenceEvents() {
        Function<View, ISequenceEvent> getISE = new Function<View, ISequenceEvent>(){

            public ISequenceEvent apply(View from) {
                Option<ISequenceEvent> ise = ISequenceElementAccessor.getISequenceEvent(from);
                if (!$assertionsDisabled && !ise.some()) {
                    throw new AssertionError((Object)SequenceDiagram.INTERNAL_ERROR);
                }
                return (ISequenceEvent)ise.get();
            }
        };
        return Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), View.class), ISequenceEvent.ISEQUENCEEVENT_NOTATION_PREDICATE), (Function)getISE);
    }

    public List<EventEnd> findEnds(ISequenceEvent event) {
        ArrayList ends = Lists.newArrayList();
        EObject seqDiag = this.getNotationDiagram().getElement();
        Option<EObject> semanticEvent = event.getSemanticTargetElement();
        if (seqDiag instanceof SequenceDDiagram && semanticEvent.some()) {
            for (EventEnd ee : ((SequenceDDiagram)seqDiag).getGraphicalOrdering().getEventEnds()) {
                if (!EventEndHelper.getSemanticEvents(ee).contains(semanticEvent.get())) continue;
                ends.add(ee);
            }
        }
        return ends;
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    private static enum NotationPredicate implements Predicate<View>
    {
        INSTANCE;


        public boolean apply(View input) {
            if (input instanceof Diagram) {
                EObject element = input.getElement();
                return element instanceof DDiagram && SequenceDiagram.viewpointElementPredicate().apply((Object)((DDiagram)element));
            }
            return false;
        }
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagram>
    {
        INSTANCE;


        public boolean apply(DDiagram input) {
            if (input == null) {
                return false;
            }
            EClass sdDescClass = DescriptionPackage.eINSTANCE.getSequenceDiagramDescription();
            return input instanceof SequenceDDiagram && sdDescClass.isInstance((Object)input.getDescription());
        }
    }
}

