/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceMessageViewQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.RangeSetter;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEndsOrdering;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class Message
extends AbstractSequenceElement
implements ISequenceEvent {
    public static final Predicate<ISequenceEvent> NO_RECONNECTABLE_EVENTS = new Predicate<ISequenceEvent>(){

        public boolean apply(ISequenceEvent input) {
            return input instanceof AbstractFrame || input instanceof Operand || input instanceof State;
        }
    };
    public static final Function<DEdge, Kind> VIEWPOINT_MESSAGE_KIND = new Function<DEdge, Kind>(){

        public Kind apply(DEdge from) {
            Kind result = null;
            if (AbstractSequenceElement.isSequenceDiagramElement((DDiagramElement)from, DescriptionPackage.eINSTANCE.getBasicMessageMapping())) {
                result = Kind.BASIC;
            } else if (AbstractSequenceElement.isSequenceDiagramElement((DDiagramElement)from, DescriptionPackage.eINSTANCE.getReturnMessageMapping())) {
                result = Kind.REPLY;
            } else if (AbstractSequenceElement.isSequenceDiagramElement((DDiagramElement)from, DescriptionPackage.eINSTANCE.getCreationMessageMapping())) {
                result = Kind.CREATION;
            } else if (AbstractSequenceElement.isSequenceDiagramElement((DDiagramElement)from, DescriptionPackage.eINSTANCE.getDestructionMessageMapping())) {
                result = Kind.DESTRUCTION;
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError((Object)"Unsupported kind of message detected");
            }
            return result;
        }
    };
    public static final int VISUAL_ID = 4001;

    public Message(Edge edge) {
        super((View)edge);
        Preconditions.checkArgument((boolean)Message.notationPredicate().apply((Object)edge), (Object)"The edge does not represent a sequence message.");
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getEdge(), 4001, Message.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public Edge getNotationEdge() {
        return (Edge)this.view;
    }

    public Kind getKind() {
        EObject element = this.view.getElement();
        if (element instanceof DEdge) {
            return (Kind)((Object)VIEWPOINT_MESSAGE_KIND.apply((Object)((DEdge)element)));
        }
        return Kind.BASIC;
    }

    public ISequenceNode getSourceElement() {
        return (ISequenceNode)ISequenceElementAccessor.getISequenceNode(this.getNotationEdge().getSource()).get();
    }

    public ISequenceNode getTargetElement() {
        return (ISequenceNode)ISequenceElementAccessor.getISequenceNode(this.getNotationEdge().getTarget()).get();
    }

    @Override
    public Range getVerticalRange() {
        return new SequenceMessageViewQuery(this.getNotationEdge()).getVerticalRange();
    }

    @Override
    public boolean isLogicallyInstantaneous() {
        return !this.isReflective();
    }

    @Override
    public void setVerticalRange(Range range) throws IllegalStateException {
        RangeSetter.setVerticalRange(this, range);
    }

    @Override
    public Option<Lifeline> getLifeline() {
        if (this.isReflective()) {
            return this.getSourceLifeline();
        }
        return Options.newNone();
    }

    public boolean isReflective() {
        Option<Lifeline> sourceLifeline = this.getSourceLifeline();
        Option<Lifeline> targetLifeline = this.getTargetLifeline();
        return sourceLifeline.some() && targetLifeline.some() && sourceLifeline.get() == targetLifeline.get();
    }

    public Option<Lifeline> getSourceLifeline() {
        ISequenceNode sourceElement = this.getSourceElement();
        if (sourceElement != null) {
            return sourceElement.getLifeline();
        }
        return Options.newNone();
    }

    public Option<Lifeline> getTargetLifeline() {
        ISequenceNode targetElement = this.getTargetElement();
        if (targetElement != null) {
            return targetElement.getLifeline();
        }
        return Options.newNone();
    }

    public Option<Lifeline> getRemoteLifeline(Lifeline local) {
        Option<Lifeline> sourceLifeline = this.getSourceLifeline();
        if (local == sourceLifeline.get()) {
            return this.getTargetLifeline();
        }
        return sourceLifeline;
    }

    public boolean isCompoundMessage() {
        return !Iterables.isEmpty((Iterable)Iterables.filter(this.getDiagram().findEnds(this), CompoundEventEnd.class));
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        Range range = this.getVerticalRange();
        ISequenceNode srcElement = this.getSourceElement();
        ISequenceNode tgtElement = this.getTargetElement();
        Rectangle srcLogicalBounds = srcElement.getProperLogicalBounds().getCopy();
        Rectangle tgtLogicalBounds = tgtElement.getProperLogicalBounds().getCopy();
        int srcCenterX = srcLogicalBounds.getCenter().x;
        int tgtCenterX = tgtLogicalBounds.getCenter().x;
        int srcX = 0;
        int tgtX = 0;
        if (this.isReflective()) {
            srcX = srcLogicalBounds.getRight().x;
            tgtX = tgtLogicalBounds.getRight().x;
        } else if (srcCenterX <= tgtCenterX) {
            srcX = srcLogicalBounds.getRight().x;
            tgtX = tgtLogicalBounds.getLeft().x;
        } else {
            srcX = srcLogicalBounds.getLeft().x;
            tgtX = tgtLogicalBounds.getRight().x;
        }
        if (srcElement instanceof Lifeline) {
            srcX = srcLogicalBounds.getCenter().x;
        }
        if (tgtElement instanceof Lifeline) {
            tgtX = tgtLogicalBounds.getCenter().x;
        }
        return new Rectangle(srcX, range.getLowerBound(), tgtX - srcX, range.width());
    }

    @Override
    public List<ISequenceEvent> getSubEvents() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ISequenceEvent> getEventsToMoveWith() {
        return this.getSubEvents();
    }

    @Override
    public ISequenceEvent getParentEvent() {
        ISequenceNode sourceElement = this.getSourceElement();
        if (sourceElement instanceof ISequenceEvent) {
            return (ISequenceEvent)((Object)sourceElement);
        }
        return null;
    }

    @Override
    public ISequenceEvent getHierarchicalParentEvent() {
        return null;
    }

    @Override
    public Range getOccupiedRange() {
        return new ISequenceEventQuery(this).getOccupiedRange();
    }

    @Override
    public Range getValidSubEventsRange() {
        return Range.emptyRange();
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return false;
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        return false;
    }

    @Override
    public Option<Operand> getParentOperand() {
        Option<Lifeline> sourceLifeline = this.getSourceLifeline();
        Option<Operand> sourceParentOperand = Options.newNone();
        if (sourceLifeline.some()) {
            sourceParentOperand = ((Lifeline)sourceLifeline.get()).getParentOperand(this.getVerticalRange());
        }
        Option<Lifeline> targetLifeline = this.getTargetLifeline();
        Option<Operand> targetParentOperand = Options.newNone();
        if (targetLifeline.some()) {
            targetParentOperand = ((Lifeline)targetLifeline.get()).getParentOperand(this.getVerticalRange());
        }
        boolean noOperand = !sourceParentOperand.some() && !targetParentOperand.some();
        boolean lostEnd = sourceLifeline.some() && !targetLifeline.some() || !sourceLifeline.some() && targetLifeline.some();
        boolean sameOperand = lostEnd || noOperand || ((Operand)sourceParentOperand.get()).equals(targetParentOperand.get());
        Preconditions.checkArgument((noOperand || sameOperand ? 1 : 0) != 0, (Object)"The source and target parent operand must be the same one or not existing.");
        Option<Operand> parentOperand = sourceParentOperand;
        if (!parentOperand.some()) {
            parentOperand = targetParentOperand;
        }
        return parentOperand;
    }

    public boolean surroundsEventOnSameLifeline() {
        return !this.getSurroundedSameLifelineEvents().isEmpty();
    }

    public int getReflexiveMessageWidth() {
        Collection<ISequenceEvent> events = this.getSurroundedSameLifelineEvents();
        final Range range = this.getVerticalRange();
        Predicate<ISequenceEvent> toConsider = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                boolean toConsider = range.includes(input.getVerticalRange());
                if (input instanceof Message) {
                    toConsider = toConsider && ((Message)input).isReflective();
                }
                return toConsider;
            }
        };
        ArrayList impactingEvents = Lists.newArrayList((Iterable)Iterables.filter(events, (Predicate)toConsider));
        Collections.sort(impactingEvents, Ordering.natural().onResultOf(Functions.compose(RangeHelper.lowerBoundFunction(), ISequenceEvent.VERTICAL_RANGE)));
        int subMessagesMaxRight = 0;
        for (Message msg : Iterables.filter((Iterable)impactingEvents, Message.class)) {
            int reflexiveMessageWidth = msg.getReflexiveMessageWidth();
            int origin = msg.getSourceElement().getProperLogicalBounds().right();
            origin = Math.max(origin, msg.getTargetElement().getProperLogicalBounds().right());
            subMessagesMaxRight = Math.max(subMessagesMaxRight, origin + reflexiveMessageWidth);
        }
        int maxRight = 0;
        for (AbstractNodeEvent node : Iterables.filter((Iterable)impactingEvents, AbstractNodeEvent.class)) {
            maxRight = Math.max(maxRight, node.getProperLogicalBounds().right());
        }
        int origin = this.getSourceElement().getProperLogicalBounds().right();
        origin = Math.max(origin, this.getTargetElement().getProperLogicalBounds().right());
        int width = 30;
        width = Math.max(width, maxRight - origin + 20);
        width = Math.max(width, subMessagesMaxRight - origin + 20);
        return width;
    }

    public Collection<ISequenceEvent> getSurroundedSameLifelineEvents() {
        LinkedHashSet<ISequenceEvent> englobedEvents = new LinkedHashSet<ISequenceEvent>();
        if (this.isReflective()) {
            int end;
            int start;
            Lifeline lifeline = (Lifeline)this.getLifeline().get();
            SequenceDiagram diagram = this.getDiagram();
            EventEndsOrdering semanticOrdering = diagram.getSequenceDDiagram().getSemanticOrdering();
            List<EventEnd> msgEnds = EventEndHelper.findEndsFromSemanticOrdering(this);
            if (msgEnds.size() == 2 && Math.abs((start = semanticOrdering.getEventEnds().indexOf((Object)msgEnds.get(0))) - (end = semanticOrdering.getEventEnds().indexOf((Object)msgEnds.get(1)))) > 1) {
                HashSet sees = Sets.newHashSet();
                HashSet interEvents = Sets.newHashSet();
                int i = start + 1;
                while (i < end) {
                    EventEnd eventEnd = (EventEnd)semanticOrdering.getEventEnds().get(i);
                    if (eventEnd instanceof SingleEventEnd) {
                        sees.add((SingleEventEnd)eventEnd);
                    } else if (eventEnd instanceof CompoundEventEnd) {
                        sees.addAll(((CompoundEventEnd)eventEnd).getEventEnds());
                    }
                    ++i;
                }
                for (SingleEventEnd see : sees) {
                    ISequenceEvent perturbing = EventEndHelper.findISequenceEvent(see, diagram);
                    if (perturbing == null) continue;
                    interEvents.add(perturbing);
                }
                englobedEvents.addAll(this.getValidInterEvents(interEvents, lifeline));
            }
        }
        return englobedEvents;
    }

    private Collection<? extends ISequenceEvent> getValidInterEvents(Collection<ISequenceEvent> interEvents, Lifeline lifeline) {
        LinkedHashSet<ISequenceEvent> englobedEvents = new LinkedHashSet<ISequenceEvent>();
        for (ISequenceEvent pertub : interEvents) {
            if (pertub instanceof Message) {
                Message msg = (Message)pertub;
                Option<Lifeline> sourceLifeline = msg.getSourceLifeline();
                Option<Lifeline> targetLifeline = msg.getTargetLifeline();
                if (targetLifeline.some() && ((Lifeline)targetLifeline.get()).equals(lifeline)) {
                    englobedEvents.add(pertub);
                    continue;
                }
                if (!sourceLifeline.some() || !((Lifeline)sourceLifeline.get()).equals(lifeline)) continue;
                englobedEvents.add(pertub);
                continue;
            }
            if (pertub instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)pertub;
                Collection<Lifeline> coverage = cf.computeCoveredLifelines();
                if (!coverage.contains(lifeline)) continue;
                englobedEvents.add(pertub);
                continue;
            }
            Option<Lifeline> pLif = pertub.getLifeline();
            if (!pLif.some() || !((Lifeline)pLif.get()).equals(lifeline)) continue;
            englobedEvents.add(pertub);
        }
        return englobedEvents;
    }

    public static enum Kind {
        BASIC,
        REPLY,
        CREATION,
        DESTRUCTION;

    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getMessageMapping());
        }
    }
}

