/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.providers.AdapterFactoryHierarchicContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.tools.util.UIUtil;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.papyrus.uml.modelrepair.ui.BrowseProfilesDialog;
import org.eclipse.papyrus.uml.modelrepair.ui.ZombieStereotypesDialog;
import org.eclipse.papyrus.uml.modelrepair.ui.providers.NestedProfilesAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZombieStereotypeDialogPresenter {
    private final Shell parentShell;
    private final ModelSet modelSet;
    private final List<ZombieStereotypesDescriptor> zombieDescriptors = Lists.newArrayListWithExpectedSize((int)1);
    private final BrowseProfileSupplier dynamicProfileSupplier = new BrowseProfileSupplier();
    private Runnable presentation;
    private final Lock lock = new ReentrantLock();
    private final Condition pendingCond = this.lock.newCondition();
    private volatile boolean pending = false;
    private final ExecutorService uiExecutor;
    private ExecutorService pendingExecutor;

    public ZombieStereotypeDialogPresenter(Shell parentShell, ModelSet modelSet) {
        this.parentShell = parentShell;
        this.modelSet = modelSet;
        this.uiExecutor = UIUtil.createUIExecutor((Display)parentShell.getDisplay());
    }

    public void dispose() {
        this.detachPresentation();
        this.uiExecutor.shutdown();
    }

    void detachPresentation() {
        this.lock.lock();
        try {
            this.zombieDescriptors.clear();
            this.presentation = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Function<EPackage, Profile> getDynamicProfileSupplier() {
        return this.dynamicProfileSupplier;
    }

    public void addZombies(ZombieStereotypesDescriptor zombies) {
        this.lock.lock();
        try {
            this.zombieDescriptors.add(zombies);
            if (this.presentation == null) {
                this.internalSetPending(true);
                this.presentation = new Runnable(){

                    public void run() {
                        block14: {
                            ImmutableList zombies;
                            ZombieStereotypeDialogPresenter.this.lock.lock();
                            try {
                                if (ZombieStereotypeDialogPresenter.this.presentation != this) {
                                    ZombieStereotypeDialogPresenter.this.internalSetPending(false);
                                    return;
                                }
                                zombies = ImmutableList.copyOf((Collection)ZombieStereotypeDialogPresenter.this.zombieDescriptors);
                                ZombieStereotypeDialogPresenter.this.detachPresentation();
                            }
                            finally {
                                ZombieStereotypeDialogPresenter.this.lock.unlock();
                            }
                            try {
                                if (zombies.isEmpty()) break block14;
                                try {
                                    try {
                                        ZombieStereotypesDialog zombieDialog = new ZombieStereotypesDialog(ZombieStereotypeDialogPresenter.this.parentShell, ZombieStereotypeDialogPresenter.this.modelSet, (Iterable<? extends ZombieStereotypesDescriptor>)zombies);
                                        ZombieStereotypeDialogPresenter.this.dynamicProfileSupplier.setParentWindow((Window)zombieDialog);
                                        zombieDialog.setBlockOnOpen(true);
                                        zombieDialog.open();
                                    }
                                    catch (ServiceException e) {
                                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to open model repair dialog.", (Throwable)e), 2);
                                        ZombieStereotypeDialogPresenter.this.dynamicProfileSupplier.setParentWindow(null);
                                    }
                                }
                                finally {
                                    ZombieStereotypeDialogPresenter.this.dynamicProfileSupplier.setParentWindow(null);
                                }
                            }
                            finally {
                                ZombieStereotypeDialogPresenter.this.internalSetPending(false);
                            }
                        }
                    }
                };
                this.uiExecutor.submit(this.presentation);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPending() {
        return this.pending;
    }

    public void awaitPending(boolean expected) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.pending != expected) {
                this.pendingCond.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onPendingDone(final Runnable runnable) {
        this.lock.lock();
        try {
            if (!this.pending) {
                runnable.run();
            } else {
                if (this.pendingExecutor == null) {
                    this.pendingExecutor = Executors.newSingleThreadExecutor();
                }
                this.pendingExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ZombieStereotypeDialogPresenter.this.awaitPending(false);
                            runnable.run();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void internalSetPending(boolean pending) {
        this.lock.lock();
        try {
            this.pending = pending;
            this.pendingCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean hasNestedProfiles(Profile profile) {
        return Iterators.any((Iterator)profile.eAllContents(), (Predicate)Predicates.instanceOf(Profile.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BrowseProfileSupplier
    implements Function<EPackage, Profile> {
        private Window parentWindow;

        private BrowseProfileSupplier() {
        }

        void setParentWindow(Window parentWindow) {
            this.parentWindow = parentWindow;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Profile apply(EPackage schema) {
            Profile result = null;
            LabelProviderServiceImpl labelProvider = null;
            boolean localProvider = false;
            try {
                labelProvider = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)ZombieStereotypeDialogPresenter.this.modelSet);
            }
            catch (ServiceException e) {
                labelProvider = new LabelProviderServiceImpl();
                localProvider = true;
            }
            final BrowseProfilesDialog dlg = new BrowseProfilesDialog(this.parentWindow.getShell(), schema, (LabelProviderService)labelProvider);
            Future<URI> task = ZombieStereotypeDialogPresenter.this.uiExecutor.submit(new Callable<URI>(){

                @Override
                public URI call() {
                    dlg.setBlockOnOpen(true);
                    dlg.open();
                    return dlg.getSelectedProfileURI();
                }
            });
            try {
                try {
                    URI selectedProfileURI = task.get();
                    if (selectedProfileURI == null || (result = (Profile)EMFHelper.load((ResourceSet)ZombieStereotypeDialogPresenter.this.modelSet, (URI)selectedProfileURI, Profile.class)) == null || !ZombieStereotypeDialogPresenter.this.hasNestedProfiles(result)) return result;
                    final TreeSelectorDialog selectorDlg = new TreeSelectorDialog(this.parentWindow.getShell());
                    NestedProfilesAdapterFactory factory = new NestedProfilesAdapterFactory();
                    AdapterFactoryHierarchicContentProvider content = new AdapterFactoryHierarchicContentProvider((AdapterFactory)factory);
                    AdapterFactoryLabelProvider labels = new AdapterFactoryLabelProvider((AdapterFactory)factory);
                    try {
                        selectorDlg.setContentProvider((ITreeContentProvider)content);
                        selectorDlg.setLabelProvider((ILabelProvider)labels);
                        final Resource dlgInput = result.eResource();
                        Future<Profile> specific = ZombieStereotypeDialogPresenter.this.uiExecutor.submit(new Callable<Profile>(){

                            @Override
                            public Profile call() throws Exception {
                                selectorDlg.setTitle("Select a Profile");
                                selectorDlg.setDescription("Select a Profile from within the chosen resource.");
                                selectorDlg.setHelpAvailable(false);
                                selectorDlg.setBlockOnOpen(true);
                                selectorDlg.setInput(dlgInput);
                                selectorDlg.open();
                                Profile result = null;
                                Object[] selected = selectorDlg.getResult();
                                if (selected != null && selected.length > 0) {
                                    result = (Profile)selected[0];
                                }
                                return result;
                            }
                        });
                        result = specific.get();
                        return result;
                    }
                    finally {
                        content.dispose();
                        labels.dispose();
                        factory.dispose();
                    }
                }
                catch (ExecutionException e) {
                    Activator.log.error("Profile selection dialog presentation failed.", (Throwable)e);
                    if (!localProvider) return result;
                    try {
                        labelProvider.disposeService();
                        return result;
                    }
                    catch (ServiceException e2) {
                        Activator.log.error((Throwable)e2);
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    Activator.log.error("Profile selection dialog presentation interrupted.", (Throwable)e);
                    if (!localProvider) return result;
                    try {
                        labelProvider.disposeService();
                        return result;
                    }
                    catch (ServiceException e3) {
                        Activator.log.error((Throwable)e3);
                    }
                    return result;
                }
            }
            finally {
                if (localProvider) {
                    try {
                        labelProvider.disposeService();
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        }
    }
}

