/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.resource.DependencyManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.markerlistener.dialogs.DiagnosticDialog;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.tools.util.LibraryHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

public class SwitchPackageImportDialog
extends SelectionDialog {
    private static final int APPLY_ID = 1025;
    private static final String APPLY_LABEL = "Apply";
    private static final int BROWSE_WORKSPACE_ID = 1026;
    private static final int BROWSE_REGISTERED_ID = 1027;
    private ModelSet modelSet;
    private TransactionalEditingDomain editingDomain;
    protected TableViewer viewer;
    protected Table table;
    protected LabelProviderService labelProviderService;
    protected final Map<Resource, Resource> librariesToEdit = new HashMap<Resource, Resource>();

    public SwitchPackageImportDialog(Shell shell, ModelSet modelSet, TransactionalEditingDomain domain) throws ServiceException {
        super(shell);
        this.modelSet = modelSet;
        this.editingDomain = domain;
        this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)modelSet);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 64);
        String description = "Select an imported library, then select a new library (either from the workspace, or a registered one).\n";
        description = String.valueOf(description) + "If the libraries are equivalent, the selected library will replace the imported library.\n";
        description = String.valueOf(description) + "Two libraries are equivalent if one is the copy of the other or if you have deployed a workspace library in a plug-in.\n";
        description = String.valueOf(description) + "If a library P' is a copy of a library P, with some modifications, they are also equivalent.";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label warningLabel = new Label(self, 64);
        String warning = "Replacing an imported library with a totally different one could result in loss of information.";
        warningLabel.setText(warning);
        warningLabel.setForeground(parent.getDisplay().getSystemColor(4));
        warningLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite buttonsBarComposite = new Composite(self, 0);
        GridLayout buttonsLayout = new GridLayout(0, false);
        buttonsLayout.marginWidth = 0;
        buttonsBarComposite.setLayout((Layout)buttonsLayout);
        buttonsBarComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Button browseWorkspace = this.createButton(buttonsBarComposite, 1026, "", false);
        browseWorkspace.setImage(Activator.getDefault().getImage("icons/Add_12x12.gif"));
        Button browseRegistered = this.createButton(buttonsBarComposite, 1027, "", false);
        browseRegistered.setImage(Activator.getDefault().getImage("org.eclipse.papyrus.uml.modelrepair", "icons/AddReg.gif"));
        this.viewer = new TableViewer(self, 67584);
        this.table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText("Applied Library");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 150, true));
        TableColumn locationColumn = new TableColumn(this.table, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        TableColumn newLocationColumn = new TableColumn(this.table, 0);
        newLocationColumn.setText("New Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ModelSet) {
                    ModelSet modelSet = (ModelSet)inputElement;
                    Set allImportedPackages = LibraryHelper.getAllImportedPackages((ModelSet)modelSet);
                    HashSet<Resource> allResources = new HashSet<Resource>();
                    for (PackageImport importedLibrary : allImportedPackages) {
                        URI libraryResourceURI = EcoreUtil.getURI((EObject)importedLibrary.getImportedPackage()).trimFragment();
                        Resource resource = modelSet.getResource(libraryResourceURI, true);
                        allResources.add(resource);
                    }
                    return allResources.toArray();
                }
                return null;
            }
        });
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    for (EObject rootElement : resource.getContents()) {
                        if (!(rootElement instanceof Package)) continue;
                        return ((Package)rootElement).getName();
                    }
                    return resource.getURI().toString();
                }
                return super.getText(element);
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageImportsColumnsLabelProvider((ILabelProvider)labelProvider));
        this.viewer.setComparator(new ViewerComparator((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return Strings.nullToEmpty((String)this.val$labelProvider.getText(e1)).compareTo(Strings.nullToEmpty((String)this.val$labelProvider.getText(e2)));
            }
        });
        this.viewer.setInput((Object)this.modelSet);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchPackageImportDialog.this.updateControls();
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$labelProvider.dispose();
            }
        });
        return contents;
    }

    protected void updateControls() {
        String newTitle = "Switch Library Locations";
        if (!this.librariesToEdit.isEmpty()) {
            newTitle = String.valueOf(newTitle) + " *";
        }
        this.getShell().setText(newTitle);
        this.getButton(1025).setEnabled(!this.librariesToEdit.isEmpty());
        boolean enableBrowse = !this.viewer.getSelection().isEmpty();
        this.getButton(1027).setEnabled(enableBrowse);
        this.getButton(1026).setEnabled(enableBrowse);
        this.viewer.refresh();
    }

    protected void setButtonLayoutData(Button button) {
        int buttonId = (Integer)button.getData();
        if (buttonId == 1027 || buttonId == 1026) {
            return;
        }
        super.setButtonLayoutData(button);
    }

    protected void applyPressed() {
        if (this.librariesToEdit.isEmpty()) {
            return;
        }
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain, "Edit package imports"){

            protected void doExecute() {
                final LinkedList allReplacements = new LinkedList();
                final BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.papyrus.uml.modelrepair", 0, "Problems in switching library", null);
                IRunnableWithProgress runnable = TransactionHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)SwitchPackageImportDialog.this.editingDomain, (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this).SwitchPackageImportDialog.this.librariesToEdit.size());
                        for (Map.Entry<Resource, Resource> replacementEntry : (this).SwitchPackageImportDialog.this.librariesToEdit.entrySet()) {
                            URI targetURI;
                            URI uriToReplace = replacementEntry.getKey().getURI();
                            if (uriToReplace.equals(targetURI = replacementEntry.getValue().getURI())) continue;
                            Collection result = new DependencyManager((ResourceSet)SwitchPackageImportDialog.this.modelSet).updateDependencies(uriToReplace, targetURI, (DiagnosticChain)diagnostics, (IProgressMonitor)subMonitor.newChild(1));
                            allReplacements.addAll(result);
                        }
                        subMonitor.done();
                    }
                });
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to execute library switch."), 2);
                }
                if (allReplacements.isEmpty()) {
                    MessageDialog.openWarning((Shell)SwitchPackageImportDialog.this.getShell(), (String)"Switch Libraries", (String)"No library applications were found to update.");
                } else if (diagnostics.getSeverity() > 0) {
                    DiagnosticDialog dialog = new DiagnosticDialog(SwitchPackageImportDialog.this.getShell(), "Problems in Switching Libraries", "Some incompatible differences in the target library likely resulted in loss or transformation of data in stereotype applications. Please review the specific details and take any corrective action that may be required.", (Diagnostic)diagnostics, 6);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            }
        });
        this.librariesToEdit.clear();
        this.updateControls();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, APPLY_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                if (this.librariesToEdit.isEmpty() || MessageDialog.openQuestion((Shell)this.getShell(), (String)"Switch Libraries", (String)"You have not yet applied the pending library switch(es). Are you sure you want to cancel?")) break;
                return;
            }
            case 1025: {
                this.applyPressed();
                return;
            }
            case 1027: {
                this.browseRegisteredLibraries();
                return;
            }
            case 1026: {
                this.browseWorkspaceLibraries();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.updateControls();
        this.getShell().setText("Switch Library Locations");
        this.getShell().setMinimumSize(600, 400);
        this.getShell().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public boolean close() {
        this.librariesToEdit.clear();
        return super.close();
    }

    protected void browseWorkspaceLibraries() {
        if (this.getSelectedResource() == null) {
            return;
        }
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Workspace");
        dialog.setDescription("Select a library in the workspace.");
        WorkspaceContentProvider workspaceContentProvider = new WorkspaceContentProvider();
        workspaceContentProvider.setExtensionFilters(extensionFilters);
        dialog.setContentProvider((ITreeContentProvider)workspaceContentProvider);
        dialog.setLabelProvider(this.labelProviderService.getLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedFile = result[0];
            if (selectedFile instanceof IFile) {
                IPath filePath = ((IFile)selectedFile).getFullPath();
                URI workspaceURI = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
                this.replaceSelectionWith(workspaceURI);
            }
        }
    }

    protected Resource getSelectedResource() {
        Object selectedElement;
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Resource) {
            return (Resource)selectedElement;
        }
        return null;
    }

    protected void browseRegisteredLibraries() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Registered Libraries");
        dialog.setDescription("Select one of the registered libraries below.");
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)new StaticContentProvider((Object[])Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]))));
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IRegisteredLibrary) {
                    IRegisteredLibrary library = (IRegisteredLibrary)element;
                    return library.getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IRegisteredLibrary) {
                    IRegisteredLibrary library = (IRegisteredLibrary)element;
                    return library.getName();
                }
                return super.getText(element);
            }
        });
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedElement = result[0];
            if (selectedElement instanceof IRegisteredLibrary) {
                IRegisteredLibrary library = (IRegisteredLibrary)selectedElement;
                this.replaceSelectionWith(library.getUri());
            }
        }
    }

    protected void replaceSelectionWith(URI targetURI) {
        Resource targetResource = this.modelSet.getResource(targetURI, true);
        if (this.getSelectedResource() != targetResource) {
            this.librariesToEdit.put(this.getSelectedResource(), targetResource);
            this.updateControls();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Nothing changed", (String)"Nothing to change");
        }
    }

    private class PackageImportsColumnsLabelProvider
    extends ColumnLabelProvider {
        private ILabelProvider defaultLabelProvider;

        public PackageImportsColumnsLabelProvider(ILabelProvider defaultLabelProvider) {
            this.defaultLabelProvider = defaultLabelProvider;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Resource resource = element instanceof Resource ? (Resource)element : null;
            switch (cell.getColumnIndex()) {
                case 0: {
                    this.updateName(cell);
                    break;
                }
                case 1: {
                    this.updateLocation(cell, resource);
                    break;
                }
                case 2: {
                    this.updateNewLocation(cell, resource);
                }
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.defaultLabelProvider.getImage(cell.getElement()));
            cell.setText(this.defaultLabelProvider.getText(cell.getElement()));
        }

        public void updateLocation(ViewerCell cell, Resource resource) {
            URI uri;
            String location = "Unknown";
            if (resource != null && (uri = resource.getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }

        public void updateNewLocation(ViewerCell cell, Resource resource) {
            URI uri;
            String location = "";
            if ((resource = SwitchPackageImportDialog.this.librariesToEdit.get(resource)) != null && (uri = resource.getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }
    }
}

