/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.eventbus.EventBus;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BrowseProfilesBlock {
    public static final int ICON = 0;
    public static final int TEXT = 1;
    private final EventBus bus;
    private final LabelProviderService labelProviderService;
    private Composite control;
    private Button browseWorkspace;
    private Button browseRegistered;
    private boolean enabled = true;

    public BrowseProfilesBlock(EventBus bus, LabelProviderService labelProviderService) {
        this.bus = bus;
        this.labelProviderService = labelProviderService;
    }

    public Control createControl(Composite parent, int style) {
        this.control = new Composite(parent, 0);
        GridLayout buttonsLayout = new GridLayout(2, false);
        buttonsLayout.marginWidth = 0;
        this.control.setLayout((Layout)buttonsLayout);
        boolean useText = (style & 1) == 1;
        this.browseWorkspace = new Button(this.control, 8);
        if (useText) {
            this.browseWorkspace.setText("Workspace...");
        } else {
            this.browseWorkspace.setImage(Activator.getDefault().getImage("icons/Add_12x12.gif"));
        }
        this.browseRegistered = new Button(this.control, 8);
        if (useText) {
            this.browseRegistered.setText("Registered...");
        } else {
            this.browseRegistered.setImage(Activator.getDefault().getImage("org.eclipse.papyrus.uml.modelrepair", "icons/AddReg.gif"));
        }
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == BrowseProfilesBlock.this.browseWorkspace) {
                    BrowseProfilesBlock.this.browseWorkspaceProfiles();
                } else {
                    BrowseProfilesBlock.this.browseRegisteredProfiles();
                }
            }
        };
        this.browseWorkspace.addSelectionListener((SelectionListener)buttonListener);
        this.browseRegistered.addSelectionListener((SelectionListener)buttonListener);
        this.updateEnablement();
        return this.control;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.updateEnablement();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected Shell getShell() {
        return this.control == null ? null : this.control.getShell();
    }

    protected void updateEnablement() {
        if (this.browseWorkspace != null && !this.browseWorkspace.isDisposed()) {
            this.browseWorkspace.setEnabled(this.enabled);
            this.browseRegistered.setEnabled(this.enabled);
        }
    }

    protected void browseWorkspaceProfiles() {
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.profile.uml", "UML Profiles (*.profile.uml)");
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Workspace");
        dialog.setDescription("Select a profile in the workspace.");
        WorkspaceContentProvider workspaceContentProvider = new WorkspaceContentProvider();
        workspaceContentProvider.setExtensionFilters(extensionFilters);
        dialog.setContentProvider((ITreeContentProvider)workspaceContentProvider);
        dialog.setLabelProvider(this.labelProviderService.getLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedFile = result[0];
            if (selectedFile instanceof IFile) {
                this.bus.post((Object)((IFile)selectedFile));
            }
        }
    }

    protected void browseRegisteredProfiles() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Registered Profiles");
        dialog.setDescription("Select one of the registered profiles below.");
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)new StaticContentProvider((Object[])Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]))));
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IRegisteredProfile) {
                    IRegisteredProfile profile = (IRegisteredProfile)element;
                    return profile.getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IRegisteredProfile) {
                    IRegisteredProfile profile = (IRegisteredProfile)element;
                    return profile.getName();
                }
                return super.getText(element);
            }
        });
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedElement = result[0];
            if (selectedElement instanceof IRegisteredProfile) {
                this.bus.post((Object)((IRegisteredProfile)selectedElement));
            }
        }
    }
}

