/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.participants;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.papyrus.infra.emf.resource.IDependencyReplacementParticipant;
import org.eclipse.papyrus.infra.emf.resource.Replacement;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.operations.PackageOperations;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationRepairParticipant
extends PackageOperations
implements IDependencyReplacementParticipant {
    public void postProcessReplacements(Collection<? extends Replacement> replacements, Collection<? extends Resource> resources, IProgressMonitor monitor, DiagnosticChain diagnostics) {
        ProfileApplication application;
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating stereotype applications ...", (int)(replacements.size() + 1));
        HashMap applicationsToDefinitions = Maps.newHashMap();
        for (Replacement replacement : replacements) {
            if (replacement.getEStructuralFeature() == UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE) {
                application = (ProfileApplication)replacement.getEObject();
                if (application.getApplyingPackage() != null) {
                    if (applicationsToDefinitions.containsKey(application)) continue;
                    applicationsToDefinitions.put(application, replacement);
                    continue;
                }
                if (diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.papyrus.uml.modelrepair", 0, "Profile application has no applying package: " + application, null));
                continue;
            }
            if (replacement.getEStructuralFeature() != EcorePackage.Literals.EANNOTATION__REFERENCES || !(replacement.getOldValue() instanceof EPackage) || !((application = ((EAnnotation)replacement.getEObject()).getEModelElement()) instanceof ProfileApplication)) continue;
            applicationsToDefinitions.put(application, replacement);
        }
        for (Map.Entry entry : applicationsToDefinitions.entrySet()) {
            application = (ProfileApplication)entry.getKey();
            EPackage oldDefinition = (EPackage)((Replacement)entry.getValue()).getOldValue();
            this.migrateStereotypeApplications(application, application.getApplyingPackage(), oldDefinition, diagnostics);
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void migrateStereotypeApplications(ProfileApplication profileApplication, Package applyingPackage, EPackage oldDefinition, DiagnosticChain diagnostics) {
        Profile newProfile = profileApplication.getAppliedProfile();
        if (newProfile.eIsProxy() && (newProfile = this.resolveNewProfile(profileApplication.eResource().getResourceSet(), newProfile, oldDefinition)) != profileApplication.getAppliedProfile()) {
            profileApplication.setAppliedProfile(newProfile);
        }
        EPackage definition = profileApplication.getAppliedDefinition();
        EPackage newDefinition = newProfile.getDefinition();
        if (newDefinition != null && newDefinition != definition) {
            EList references = StereotypeApplicationRepairParticipant.getEAnnotation((EModelElement)profileApplication, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getReferences();
            if (references.isEmpty()) {
                references.add((Object)newDefinition);
            } else {
                references.set(0, (Object)newDefinition);
            }
        }
        ArrayList oldStereotypeApplications = Lists.newArrayList();
        TreeIterator iter = StereotypeApplicationRepairParticipant.getAllContents((EObject)applyingPackage, (boolean)true, (boolean)false);
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof Element) {
                for (EStructuralFeature.Setting setting : EMFHelper.getUsages((EObject)element)) {
                    EObject owner = setting.getEObject();
                    if (!this.isStereotypeApplicationExtensionSetting(owner, setting) || owner.eClass().getEPackage() != oldDefinition) continue;
                    oldStereotypeApplications.add(owner);
                }
                continue;
            }
            iter.prune();
        }
        StereotypeApplicationRepairParticipant.createStereotypeApplicationMigrator(newProfile, diagnostics).migrate(oldStereotypeApplications, null);
        if (!newProfile.getOwnedExtensions(true).isEmpty()) {
            StereotypeApplicationRepairParticipant.applyAllRequiredStereotypes((Element)profileApplication.getApplyingPackage());
        }
    }

    protected boolean isStereotypeApplicationExtensionSetting(EObject owner, EStructuralFeature.Setting setting) {
        EStructuralFeature feature = setting.getEStructuralFeature();
        return !(owner instanceof Element) && feature instanceof EReference && feature.getName().startsWith("base_") && UMLPackage.Literals.ELEMENT.isSuperTypeOf(((EReference)feature).getEReferenceType());
    }

    protected Profile resolveNewProfile(ResourceSet context, Profile proxy, EPackage oldDefinition) {
        Profile result = proxy;
        if (context != null) {
            try {
                Resource res = context.getResource(EcoreUtil.getURI((EObject)proxy).trimFragment(), true);
                if (res != null) {
                    Profile oldProfile = (Profile)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)oldDefinition);
                    String qname = oldProfile != null ? StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)oldProfile) : StereotypeApplicationRepairParticipant.getQualifiedName((ENamedElement)oldDefinition, (String)"::");
                    Collection resolved = StereotypeApplicationRepairParticipant.findNamedElements((Resource)res, (String)qname);
                    if (!resolved.isEmpty()) {
                        result = (Profile)resolved.iterator().next();
                    } else {
                        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.PROFILE);
                        if (profile != null) {
                            result = profile;
                        }
                    }
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return result;
    }

    public static StereotypeApplicationMigrator createStereotypeApplicationMigrator(Profile profile, DiagnosticChain diagnostics) {
        return new StereotypeApplicationMigrator(profile, diagnostics);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StereotypeApplicationMigrator {
        private StereotypeApplicationRepairCopier copier;

        StereotypeApplicationMigrator(Profile profile, DiagnosticChain diagnostics) {
            this.copier = new StereotypeApplicationRepairCopier(profile, diagnostics);
        }

        public void migrate(Collection<? extends EObject> stereotypeApplications, IProgressMonitor monitor) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * stereotypeApplications.size() + 2));
            for (EObject eObject : stereotypeApplications) {
                EObject newInstance = this.copier.copy(eObject);
                if (newInstance != null && newInstance != eObject && newInstance.eResource() == null) {
                    EcoreUtil.replace((EObject)eObject, (EObject)newInstance);
                }
                sub.worked(1);
            }
            this.copier.copyReferences();
            sub.worked(1);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)sub.newChild(stereotypeApplications.size()), (int)this.copier.size());
            for (Map.Entry next : this.copier.entrySet()) {
                EObject original = (EObject)next.getKey();
                EObject copy = (EObject)next.getValue();
                if (copy != null) {
                    XMLResource xml;
                    String id;
                    Resource res = original.eResource();
                    if (res instanceof XMLResource && (id = (xml = (XMLResource)res).getID(original)) != null) {
                        xml.setID(copy, id);
                    }
                    for (EStructuralFeature.Setting setting : ImmutableList.copyOf((Collection)StereotypeApplicationRepairParticipant.getNonNavigableInverseReferences((EObject)original))) {
                        EStructuralFeature ref = setting.getEStructuralFeature();
                        if (ref == null || !ref.isChangeable()) continue;
                        if (ref.isMany()) {
                            EList list = (EList)setting.getEObject().eGet(ref);
                            list.set(list.indexOf((Object)original), (Object)copy);
                            continue;
                        }
                        setting.set((Object)copy);
                    }
                }
                subMonitor.worked(1);
            }
            subMonitor.done();
            StereotypeApplicationRepairParticipant.destroyAll((Collection)stereotypeApplications);
            sub.worked(1);
            this.copier.clear();
        }
    }

    protected static class StereotypeApplicationRepairCopier
    extends PackageOperations.StereotypeApplicationCopier {
        private static final long serialVersionUID = 1L;
        private final Pattern whitespace = Pattern.compile("\\s+");
        private final DiagnosticChain diagnostics;
        private EObject copying;

        public StereotypeApplicationRepairCopier(Profile profile, DiagnosticChain diagnostics) {
            super(profile);
            this.diagnostics = diagnostics;
        }

        public EObject copy(EObject eObject) {
            EObject previousCopying = this.copying;
            try {
                this.copying = eObject;
                EObject eObject2 = super.copy(eObject);
                return eObject2;
            }
            finally {
                this.copying = previousCopying;
            }
        }

        protected NamedElement getNamedElement(ENamedElement element) {
            EStructuralFeature force;
            EClassifier classifier;
            EStructuralFeature feature;
            if (element instanceof EClassifier) {
                EClassifier force2;
                EClassifier classifier2 = (EClassifier)element;
                if (this.isUnrecognizedSchema(classifier2.getEPackage()) && this.profile.getDefinition() != null && (force2 = this.profile.getDefinition().getEClassifier(classifier2.getName())) != null) {
                    element = force2;
                }
            } else if (element instanceof EStructuralFeature && this.isUnrecognizedSchema((feature = (EStructuralFeature)element).getEContainingClass().getEPackage()) && this.profile.getDefinition() != null && (classifier = this.profile.getDefinition().getEClassifier(feature.getEContainingClass().getName())) instanceof EClass && (force = ((EClass)classifier).getEStructuralFeature(element.getName())) != null) {
                element = force;
            }
            return super.getNamedElement(element);
        }

        protected boolean isUnrecognizedSchema(EPackage ePackage) {
            boolean result = this.copying != null ? this.getExtendedMetadata(this.copying).demandedPackages().contains(ePackage) : ePackage.getName() == null;
            return result;
        }

        protected ExtendedMetaData getExtendedMetadata(EObject context) {
            Object option;
            ExtendedMetaData result = ExtendedMetaData.INSTANCE;
            Resource resource = context.eResource();
            if (resource instanceof XMLResource && (option = ((XMLResource)resource).getDefaultSaveOptions().get("EXTENDED_META_DATA")) instanceof ExtendedMetaData) {
                result = (ExtendedMetaData)option;
            }
            return result;
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (copyEObject == null) {
                return;
            }
            if (eAttribute == XMLTypePackage.Literals.ANY_TYPE__ANY_ATTRIBUTE) {
                this.copyUnrecognizedContentAnyAttribute(eAttribute, eObject, copyEObject);
            } else if (eAttribute == XMLTypePackage.Literals.ANY_TYPE__MIXED) {
                this.copyUnrecognizedContentMixed(eAttribute, eObject, copyEObject);
            } else {
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }
        }

        protected void copyUnrecognizedContentAnyAttribute(EAttribute anyAttribute, EObject eObject, EObject copyEObject) {
            FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)anyAttribute);
            for (FeatureMap.Entry next : featureMap) {
                EStructuralFeature f = next.getEStructuralFeature();
                EStructuralFeature copyFeature = copyEObject.eClass().getEStructuralFeature(f.getName());
                if (copyFeature instanceof EReference) {
                    String refs = String.valueOf(next.getValue());
                    String[] stringArray = this.whitespace.split(refs);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String propertyName;
                        String ref = stringArray[n2];
                        EObject referenced = this.resolveRef(eObject, ref);
                        if (referenced == null) {
                            propertyName = StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyFeature), (EObject)eObject));
                            this.handleException(new IllegalStateException(String.format("Unresolved reference in stereotype property %s: %s", propertyName, ref)));
                        } else if (!copyFeature.getEType().isInstance((Object)referenced)) {
                            propertyName = StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyFeature), (EObject)eObject));
                            this.handleException(new IllegalStateException(String.format("Attempt to reference object of type %s in stereotype property %s", UMLUtil.UML2EcoreConverter.getOriginalName((ENamedElement)referenced.eClass()), propertyName)));
                        } else {
                            this.eAdd(copyEObject, copyFeature, referenced);
                        }
                        ++n2;
                    }
                    continue;
                }
                if (copyFeature instanceof EAttribute) {
                    EDataType dataType = ((EAttribute)copyFeature).getEAttributeType();
                    try {
                        Object value = EcoreUtil.createFromString((EDataType)dataType, (String)String.valueOf(next.getValue()));
                        this.eAdd(copyEObject, copyFeature, value);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                    continue;
                }
                String qualifiedName = String.format("%s::%s", StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyEObject.eClass()), (EObject)eObject).getName(), f.getName());
                this.handleException(new IllegalStateException(String.format("Definition for property '%s' not found in profile '%s'", qualifiedName, StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)this.profile))));
            }
        }

        protected void eAdd(EObject owner, EStructuralFeature feature, Object value) {
            if (feature.isChangeable() && !feature.isDerived()) {
                if (feature.isMany()) {
                    Collection list = (Collection)owner.eGet(feature);
                    list.add(value);
                } else {
                    owner.eSet(feature, value);
                }
            }
        }

        protected EObject resolveRef(EObject anyType, String ref) {
            Resource baseResource = anyType.eResource();
            URI uri = ref.contains("#") ? baseResource.getURI().resolve(URI.createURI((String)ref)) : baseResource.getURI().appendFragment(ref);
            return baseResource.getResourceSet().getEObject(uri, true);
        }

        protected void copyUnrecognizedContentMixed(EAttribute mixed, EObject eObject, EObject copyEObject) {
            FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)mixed);
            for (FeatureMap.Entry next : featureMap) {
                EStructuralFeature f = next.getEStructuralFeature();
                if (f.getEContainingClass() == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT || !(f instanceof EReference)) continue;
                EObject anyType = (EObject)next.getValue();
                EStructuralFeature copyFeature = copyEObject.eClass().getEStructuralFeature(f.getName());
                if (copyFeature instanceof EAttribute) {
                    try {
                        String text = this.getTextContent(anyType);
                        if (text == null) continue;
                        EDataType dataType = ((EAttribute)copyFeature).getEAttributeType();
                        Object value = EcoreUtil.createFromString((EDataType)dataType, (String)text);
                        this.eAdd(copyEObject, copyFeature, value);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                    continue;
                }
                if (copyFeature instanceof EReference) {
                    EReference reference = (EReference)copyFeature;
                    if (!reference.isContainment()) {
                        String refs = this.getTextContent(anyType);
                        if (refs == null) continue;
                        String[] stringArray = this.whitespace.split(refs);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String propertyName;
                            String ref = stringArray[n2];
                            EObject referenced = this.resolveRef(eObject, ref);
                            if (referenced == null) {
                                propertyName = StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyFeature), (EObject)eObject));
                                this.handleException(new IllegalStateException(String.format("Unresolved reference in stereotype property %s: %s", propertyName, ref)));
                            } else if (!copyFeature.getEType().isInstance((Object)referenced)) {
                                propertyName = StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyFeature), (EObject)eObject));
                                this.handleException(new IllegalStateException(String.format("Attempt to reference object of type %s in stereotype property %s", UMLUtil.UML2EcoreConverter.getOriginalName((ENamedElement)referenced.eClass()), propertyName)));
                            } else {
                                this.eAdd(copyEObject, (EStructuralFeature)reference, referenced);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    EObject containedCopy = this.copy(anyType);
                    if (containedCopy == null) continue;
                    if (reference.getEReferenceType().isInstance((Object)containedCopy)) {
                        this.eAdd(copyEObject, (EStructuralFeature)reference, containedCopy);
                        continue;
                    }
                    String propertyName = StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)reference), (EObject)eObject));
                    this.handleException(new IllegalStateException(String.format("Attempt to contain object of type %s in stereotype property %s", UMLUtil.UML2EcoreConverter.getOriginalName((ENamedElement)containedCopy.eClass()), propertyName)));
                    continue;
                }
                String qualifiedName = String.format("%s::%s", StereotypeApplicationRepairParticipant.getNamedElement((ENamedElement)((ENamedElement)copyEObject.eClass()), (EObject)eObject).getName(), f.getName());
                this.handleException(new IllegalStateException(String.format("Definition for property '%s' not found in profile '%s'", qualifiedName, StereotypeApplicationRepairParticipant.getQualifiedName((NamedElement)this.profile))));
            }
        }

        protected String getTextContent(EObject anyType) {
            List list;
            String result = null;
            Object value = anyType.eGet((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT);
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof List && !(list = (List)value).isEmpty()) {
                result = (String)list.get(0);
            }
            return result;
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (copyEObject != null) {
                EObject previousCopying = this.copying;
                try {
                    this.copying = eObject;
                    super.copyReference(eReference, eObject, copyEObject);
                }
                finally {
                    this.copying = previousCopying;
                }
            }
        }

        protected void copyProxyURI(EObject eObject, EObject copyEObject) {
            if (copyEObject != null) {
                super.copyProxyURI(eObject, copyEObject);
            }
        }

        public void copyReferences() {
            for (Map.Entry entry : this.entrySet()) {
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                int i = 0;
                int size = eClass.getFeatureCount();
                while (i < size) {
                    EReference eReference;
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                    if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && eStructuralFeature instanceof EReference && !(eReference = (EReference)eStructuralFeature).isContainment() && !eReference.isContainer()) {
                        this.copyReference(eReference, eObject, copyEObject);
                    }
                    ++i;
                }
            }
        }

        protected EObject createCopy(EObject eObject) {
            try {
                return super.createCopy(eObject);
            }
            catch (IllegalStateException e) {
                this.handleException(e);
                return null;
            }
        }

        protected ENamedElement getDefinition(NamedElement element) {
            return super.getDefinition(this.getSameNamedElement(element, (Package)this.profile));
        }

        protected NamedElement getSameNamedElement(NamedElement namedElement, Package package_) {
            if (namedElement == null) {
                return null;
            }
            String qualifiedName = namedElement.getQualifiedName();
            String prefix = package_.getQualifiedName();
            int last = prefix.lastIndexOf("::");
            if (last >= 0 && qualifiedName.startsWith(prefix = prefix.substring(0, last + "::".length()))) {
                qualifiedName = qualifiedName.substring(prefix.length());
            }
            return StereotypeApplicationRepairCopier.findNamedElement((NamedElement)package_, qualifiedName, namedElement.eClass());
        }

        protected void handleException(Exception exception) {
            if (this.diagnostics != null) {
                Object[] data = null;
                if (this.copying != null) {
                    Element base = this.copying == null ? null : (this.copying instanceof AnyType ? this.guessAnyTypeBaseElement(this.copying) : StereotypeApplicationRepairParticipant.getBaseElement((EObject)this.copying));
                    data = base != null ? new Object[]{base} : new Object[]{this.copying.eResource()};
                }
                this.diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.papyrus.uml.modelrepair", 0, exception.getLocalizedMessage(), data));
            } else {
                super.handleException(exception);
            }
        }

        protected Element guessAnyTypeBaseElement(EObject anyType) {
            EObject referenced;
            Element result = null;
            for (FeatureMap.Entry next : (FeatureMap)anyType.eGet((EStructuralFeature)XMLTypePackage.Literals.ANY_TYPE__ANY_ATTRIBUTE)) {
                if (!next.getEStructuralFeature().getName().startsWith("base_") || !((referenced = this.resolveRef(anyType, String.valueOf(next.getValue()))) instanceof Element)) continue;
                result = (Element)referenced;
                break;
            }
            if (result == null) {
                for (FeatureMap.Entry next : (FeatureMap)anyType.eGet((EStructuralFeature)XMLTypePackage.Literals.ANY_TYPE__MIXED)) {
                    if (!(next.getEStructuralFeature() instanceof EReference) || !next.getEStructuralFeature().getName().startsWith("base_") || !((referenced = this.resolveRef(anyType, this.getTextContent((EObject)next.getValue()))) instanceof Element)) continue;
                    result = (Element)referenced;
                    break;
                }
            }
            return result;
        }

        private static NamedElement findNamedElement(NamedElement search, String qualifiedName, EClass metaclass) {
            NamedElement result = null;
            int separator = qualifiedName.indexOf("::");
            if (separator < 0) {
                if (qualifiedName.equals(search.getName()) && metaclass.isInstance((Object)search)) {
                    result = search;
                }
            } else {
                String nextSegment = qualifiedName.substring(0, separator);
                String rest = qualifiedName.substring(separator + "::".length());
                if (nextSegment.equals(search.getName()) && search instanceof Namespace) {
                    for (NamedElement next : ((Namespace)search).getMembers()) {
                        result = StereotypeApplicationRepairCopier.findNamedElement(next, rest, metaclass);
                        if (result != null) break;
                    }
                }
            }
            return result;
        }
    }
}

