/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.compare.CDOCompare;
import org.eclipse.emf.cdo.compare.CDOCompareUtil;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonEditorInput;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class CDOCompareEditorUtil {
    public static boolean openDialog(CDOSession session, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint) {
        boolean bl;
        CDOView leftView = null;
        CDOView rightView = null;
        try {
            leftView = session.openView(leftPoint);
            rightView = session.openView(rightPoint);
            bl = CDOCompareEditorUtil.openDialog(leftView, rightView, null);
        }
        catch (Throwable throwable) {
            LifecycleUtil.deactivate(rightView);
            LifecycleUtil.deactivate((Object)leftView);
            throw throwable;
        }
        LifecycleUtil.deactivate((Object)rightView);
        LifecycleUtil.deactivate((Object)leftView);
        return bl;
    }

    public static boolean openDialog(CDOCommitInfo leftCommitInfo, CDOBranchPoint rightPoint) {
        CDORepositoryInfo repositoryInfo = (CDORepositoryInfo)leftCommitInfo.getCommitInfoManager().getRepository();
        CDOSession session = repositoryInfo.getSession();
        return CDOCompareEditorUtil.openDialog(session, (CDOBranchPoint)leftCommitInfo, rightPoint);
    }

    public static boolean openDialog(CDOCommitInfo commitInfo) {
        long previousTimeStamp = commitInfo.getPreviousTimeStamp();
        if (previousTimeStamp == 0L) {
            return false;
        }
        CDOBranchPoint previous = CDOBranchUtil.normalizeBranchPoint((CDOBranch)commitInfo.getBranch(), (long)previousTimeStamp);
        return CDOCompareEditorUtil.openDialog(commitInfo, previous);
    }

    public static boolean openDialog(CDOView leftView, CDOView rightView, CDOView[] originView) {
        Comparison comparison = CDOCompareUtil.compare((CDOView)leftView, (CDOView)rightView, (CDOView[])originView);
        IComparisonScope scope = CDOCompare.getScope((Comparison)comparison);
        ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)scope.getLeft(), (Notifier)scope.getRight(), (Notifier)scope.getOrigin());
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(registry);
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftEditable(!leftView.isReadOnly());
        configuration.setRightEditable(!rightView.isReadOnly());
        Input input = new Input(configuration, comparison, editingDomain, (AdapterFactory)adapterFactory);
        CompareUI.openCompareDialog((CompareEditorInput)input);
        return input.isOK();
    }

    private static final class Input
    extends ComparisonEditorInput {
        private boolean ok;

        private Input(CompareConfiguration configuration, Comparison comparison, ICompareEditingDomain editingDomain, AdapterFactory adapterFactory) {
            super(new EMFCompareConfiguration(configuration), comparison, editingDomain, adapterFactory);
            this.setTitle("Model Comparison");
        }

        public boolean isOK() {
            return this.ok;
        }

        public boolean okPressed() {
            this.ok = true;
            return super.okPressed();
        }
    }
}

