/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.ide;

import java.util.ArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.team.IRepositoryProject;
import org.eclipse.emf.cdo.ui.ide.CommonNavigatorUtils;
import org.eclipse.emf.cdo.ui.internal.ide.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class Node
extends PlatformObject {
    private static final Object[] EMPTY = new Object[0];
    private IRepositoryProject repositoryProject;

    public Node(IRepositoryProject repositoryProject) {
        this.repositoryProject = repositoryProject;
    }

    public IRepositoryProject getRepositoryProject() {
        return this.repositoryProject;
    }

    public abstract String getText();

    public abstract String getImageKey();

    public Object[] getChildren() {
        return EMPTY;
    }

    public Object getParent() {
        return this.repositoryProject.getProject();
    }

    public abstract Type getType();

    public static final class BranchNode
    extends Node {
        private CDOBranch branch;

        public BranchNode(IRepositoryProject repositoryProject, CDOBranch branch) {
            super(repositoryProject);
            this.branch = branch;
        }

        public CDOBranch getBranch() {
            return this.branch;
        }

        public Type getType() {
            return Type.BRANCH;
        }

        public String getText() {
            return this.branch.getName();
        }

        public String getImageKey() {
            return "icons/full/obj16/branch.png";
        }

        public Object[] getChildren() {
            if (!this.getRepositoryProject().getView().getSession().getRepositoryInfo().isSupportingBranches()) {
                return CommonNavigatorUtils.createMessageProviderChild(Messages.getString("Node.1"), CommonNavigatorUtils.MessageType.INFO);
            }
            CDOBranch[] branches = this.branch.getBranches();
            BranchNode[] nodes = new BranchNode[branches.length];
            int i = 0;
            while (i < branches.length) {
                nodes[i] = new BranchNode(this.getRepositoryProject(), branches[i]);
                ++i;
            }
            return nodes;
        }

        public Object getParent() {
            if (this.branch.isMainBranch()) {
                return this.getRepositoryProject();
            }
            return this.branch.getBase().getBranch();
        }
    }

    public static final class PackagesNode
    extends Node {
        public PackagesNode(IRepositoryProject repositoryProject) {
            super(repositoryProject);
        }

        public Type getType() {
            return Type.PACKAGES;
        }

        public String getText() {
            return Messages.getString("Node.2");
        }

        public String getImageKey() {
            return "icons/full/obj16/Packages.gif";
        }

        public EPackage[] getChildren() {
            CDOPackageRegistry packageRegistry = this.getRepositoryProject().getView().getSession().getPackageRegistry();
            ArrayList<EPackage> children = new ArrayList<EPackage>();
            for (String nsURI : packageRegistry.keySet()) {
                try {
                    EPackage ePackage = packageRegistry.getEPackage(nsURI);
                    children.add(ePackage);
                }
                catch (CDOException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return children.toArray(new EPackage[children.size()]);
        }
    }

    public static final class ResourcesNode
    extends Node {
        public ResourcesNode(IRepositoryProject repositoryProject) {
            super(repositoryProject);
        }

        public Type getType() {
            return Type.RESOURCES;
        }

        public String getText() {
            return Messages.getString("Node.4");
        }

        public String getImageKey() {
            return "icons/full/obj16/Resources.gif";
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(CDOObject.class)) {
                return this.getRepositoryProject().getView().getRootResource();
            }
            return super.getAdapter(adapter);
        }

        public CDOResourceNode[] getChildren() {
            CDOView view = this.getRepositoryProject().getView();
            ArrayList<CDOResourceNode> children = new ArrayList<CDOResourceNode>();
            for (EObject resourceNode : view.getRootResource().getContents()) {
                if (!(resourceNode instanceof CDOResourceNode)) continue;
                children.add((CDOResourceNode)resourceNode);
            }
            return children.toArray(new CDOResourceNode[children.size()]);
        }
    }

    public static final class SessionsNode
    extends Node {
        public SessionsNode(IRepositoryProject repositoryProject) {
            super(repositoryProject);
        }

        public Type getType() {
            return Type.SESSIONS;
        }

        public String getText() {
            return Messages.getString("Node.0");
        }

        public String getImageKey() {
            return "icons/full/obj16/Sessions.gif";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BRANCH,
        PACKAGES,
        RESOURCES,
        SESSIONS;

    }
}

