/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceAttachmentBlock {
    private final IStatusChangeListener fContext;
    private StringButtonDialogField fWorkspaceFileNameField;
    private StringButtonDialogField fExternalFileNameField;
    private StringButtonDialogField fVariableFileNameField;
    private SelectionButtonDialogField fExternalFolderButton;
    private SelectionButtonDialogField fExternalRadio;
    private SelectionButtonDialogField fWorkspaceRadio;
    private ComboDialogField fEncodingCombo;
    private IStatus fWorkspaceNameStatus;
    private IStatus fExternalNameStatus;
    private IStatus fVariableNameStatus;
    private IPath fFileVariablePath;
    private final IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private Label fFullPathResolvedLabel;
    private IJavaProject fProject;
    private final IClasspathEntry fEntry;
    private final boolean fCanEditEncoding;
    private String fDefaultEncodingName;

    public SourceAttachmentBlock(IStatusChangeListener context, IClasspathEntry entry) {
        this(context, entry, false);
    }

    public SourceAttachmentBlock(IStatusChangeListener context, IClasspathEntry entry, boolean canEditEncoding) {
        Assert.isNotNull((Object)entry);
        this.fContext = context;
        this.fEntry = entry;
        this.fCanEditEncoding = canEditEncoding;
        try {
            String defaultEncoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
            this.fDefaultEncodingName = Messages.format(NewWizardMessages.SourceAttachmentBlock_encoding_default, defaultEncoding);
        }
        catch (CoreException coreException) {}
        int kind = entry.getEntryKind();
        Assert.isTrue((kind == 1 || kind == 4 ? 1 : 0) != 0);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fWorkspaceNameStatus = new StatusInfo();
        this.fExternalNameStatus = new StatusInfo();
        this.fVariableNameStatus = new StatusInfo();
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        if (this.isVariableEntry()) {
            this.fVariableFileNameField = new VariablePathDialogField(adapter);
            this.fVariableFileNameField.setDialogFieldListener(adapter);
            this.fVariableFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_varlabel);
            this.fVariableFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_external_varbutton);
            ((VariablePathDialogField)this.fVariableFileNameField).setVariableButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_variable_button);
        } else {
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(adapter);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.SourceAttachmentBlock_workspace_radiolabel);
            this.fWorkspaceFileNameField = new StringButtonDialogField(adapter);
            this.fWorkspaceFileNameField.setDialogFieldListener(adapter);
            this.fWorkspaceFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_workspace_label);
            this.fWorkspaceFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_workspace_browse);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(adapter);
            this.fExternalRadio.setLabelText(NewWizardMessages.SourceAttachmentBlock_external_radiolabel);
            this.fExternalFileNameField = new StringButtonDialogField(adapter);
            this.fExternalFileNameField.setDialogFieldListener(adapter);
            this.fExternalFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_external_label);
            this.fExternalFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_externalfile_button);
            this.fExternalFolderButton = new SelectionButtonDialogField(8);
            this.fExternalFolderButton.setDialogFieldListener(adapter);
            this.fExternalFolderButton.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_externalfolder_button);
        }
        this.fEncodingCombo = new ComboDialogField(4);
        this.fEncodingCombo.setDialogFieldListener(adapter);
        this.fEncodingCombo.setLabelText(NewWizardMessages.SourceAttachmentBlock_encoding_label);
        List encodings = IDEEncoding.getIDEEncodings();
        String[] encodingsArray = encodings.toArray(new String[encodings.size() + 1]);
        System.arraycopy(encodingsArray, 0, encodingsArray, 1, encodingsArray.length - 1);
        encodingsArray[0] = this.fDefaultEncodingName;
        this.fEncodingCombo.setItems(encodingsArray);
        this.setDefaults();
    }

    public void setDefaults() {
        String path;
        IPath sourceAttachmentPath = this.fEntry.getSourceAttachmentPath();
        String encoding = SourceAttachmentBlock.getSourceAttachmentEncoding(this.fEntry);
        String string = path = sourceAttachmentPath == null ? "" : sourceAttachmentPath.toString();
        if (this.isVariableEntry()) {
            this.fVariableFileNameField.setText(path);
        } else if (this.isWorkspacePath(sourceAttachmentPath)) {
            this.fWorkspaceRadio.setSelection(true);
            this.fWorkspaceFileNameField.setText(path);
        } else if (path.length() != 0 || encoding != null) {
            this.fExternalRadio.setSelection(true);
            this.fExternalFileNameField.setText(path);
        } else {
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
        }
        if (encoding == null) {
            encoding = this.fDefaultEncodingName;
        }
        this.fEncodingCombo.setText(encoding);
    }

    private boolean isWorkspacePath(IPath path) {
        if (path == null || path.getDevice() != null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.getRoot().findMember(path) != null;
    }

    private boolean isVariableEntry() {
        return this.fEntry.getEntryKind() == 4;
    }

    public IPath getSourceAttachmentPath() {
        return this.getFilePath().segmentCount() == 0 ? null : this.getFilePath();
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    private String getEncoding() {
        String encoding;
        if ((this.isVariableEntry() || this.fExternalRadio != null && this.fExternalRadio.isSelected()) && (encoding = this.fEncodingCombo.getText()).length() != 0 && !encoding.equals(this.fDefaultEncodingName)) {
            return encoding;
        }
        return null;
    }

    public IClasspathEntry getNewEntry() {
        CPListElement elem = CPListElement.createFromExisting(this.fEntry, this.fProject);
        IPath sourceAttachmentPath = this.getSourceAttachmentPath();
        String encoding = this.getEncoding();
        elem.setAttribute("sourcepath", sourceAttachmentPath);
        elem.setAttribute("source_encoding", encoding);
        return elem.getClasspathEntry();
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.isVariableEntry()) {
            int widthHint = converter.convertWidthInCharsToPixels(40);
            int labelWidthHint = widthHint * 2;
            Label message = new Label(composite, 64);
            GridData gd = new GridData(4, 1, false, false, 4, 1);
            message.setLayoutData((Object)gd);
            message.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, BasicElementLabels.getResourceName(this.fEntry.getPath().lastSegment())));
            Label desc = new Label(composite, 64);
            gd = new GridData(4, 1, false, false, 4, 1);
            gd.widthHint = labelWidthHint;
            desc.setLayoutData((Object)gd);
            desc.setText(NewWizardMessages.SourceAttachmentBlock_filename_description);
            this.fVariableFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fVariableFileNameField.getTextControl(null), widthHint);
            this.fFullPathResolvedLabel = new Label(composite, 64);
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
            gd = new GridData(4, 1, false, false, 4, 1);
            gd.widthHint = labelWidthHint;
            this.fFullPathResolvedLabel.setLayoutData((Object)gd);
            DialogField.createEmptySpace(composite, 4);
            this.fEncodingCombo.doFillIntoGrid(composite, 2);
        } else {
            int widthHint = converter.convertWidthInCharsToPixels(60);
            GridData gd = new GridData(4, 1, false, false, 3, 1);
            gd.widthHint = converter.convertWidthInCharsToPixels(50);
            Label message = new Label(composite, 16448);
            message.setLayoutData((Object)gd);
            message.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, BasicElementLabels.getResourceName(this.fEntry.getPath().lastSegment())));
            this.fWorkspaceRadio.doFillIntoGrid(composite, 4);
            this.fWorkspaceFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fWorkspaceFileNameField.getTextControl(null), widthHint);
            LayoutUtil.setHorizontalGrabbing((Control)this.fWorkspaceFileNameField.getTextControl(null));
            DialogField.createEmptySpace(composite, 4);
            this.fExternalRadio.doFillIntoGrid(composite, 4);
            this.fExternalFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fExternalFileNameField.getTextControl(null), widthHint);
            LayoutUtil.setHorizontalGrabbing((Control)this.fExternalFileNameField.getTextControl(null));
            this.fEncodingCombo.doFillIntoGrid(composite, 2);
            DialogField.createEmptySpace(composite, 1);
            this.fExternalFolderButton.doFillIntoGrid(composite, 1);
            LayoutUtil.setHorizontalIndent((Control)this.fWorkspaceFileNameField.getLabelControl(null));
            LayoutUtil.setHorizontalIndent((Control)this.fExternalFileNameField.getLabelControl(null));
            LayoutUtil.setHorizontalIndent((Control)this.fEncodingCombo.getLabelControl(null));
            this.fWorkspaceRadio.attachDialogField(this.fWorkspaceFileNameField);
            if (this.fCanEditEncoding) {
                this.fExternalRadio.attachDialogFields(new DialogField[]{this.fExternalFileNameField, this.fExternalFolderButton, this.fEncodingCombo});
            } else {
                this.fEncodingCombo.setEnabled(false);
                this.fExternalRadio.attachDialogFields(new DialogField[]{this.fExternalFileNameField, this.fExternalFolderButton});
            }
        }
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.source_attachment_context");
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        IPath jarFilePath;
        if (field == this.fWorkspaceFileNameField) {
            IPath jarFilePath2 = this.chooseInternal();
            if (jarFilePath2 != null) {
                this.fWorkspaceFileNameField.setText(jarFilePath2.toString());
            }
        } else if (field == this.fExternalFileNameField) {
            IPath jarFilePath3 = this.chooseExtJarFile();
            if (jarFilePath3 != null) {
                this.fExternalFileNameField.setText(jarFilePath3.toString());
            }
        } else if (field == this.fVariableFileNameField && (jarFilePath = this.chooseExtension()) != null) {
            this.fVariableFileNameField.setText(jarFilePath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fVariableFileNameField) {
            this.fVariableNameStatus = this.updateFileNameStatus(this.fVariableFileNameField);
        } else if (field == this.fWorkspaceFileNameField) {
            this.fWorkspaceNameStatus = this.updateFileNameStatus(this.fWorkspaceFileNameField);
        } else if (field == this.fExternalFileNameField) {
            this.fExternalNameStatus = this.updateFileNameStatus(this.fExternalFileNameField);
        } else if (field == this.fExternalFolderButton) {
            IPath folderPath = this.chooseExtFolder();
            if (folderPath != null) {
                this.fExternalFileNameField.setText(folderPath.toString());
            }
            return;
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        IStatus status;
        if (this.isVariableEntry()) {
            if (this.fFullPathResolvedLabel != null) {
                this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
            }
            this.fVariableFileNameField.enableButton(this.canBrowseFileName());
            status = this.fVariableNameStatus;
        } else {
            boolean isWorkSpace = this.fWorkspaceRadio.isSelected();
            if (isWorkSpace) {
                this.fWorkspaceFileNameField.enableButton(this.canBrowseFileName());
                status = this.fWorkspaceNameStatus;
            } else {
                this.fExternalFileNameField.enableButton(this.canBrowseFileName());
                status = this.fExternalNameStatus;
            }
        }
        this.fContext.statusChanged(status);
    }

    private boolean canBrowseFileName() {
        if (!this.isVariableEntry()) {
            return true;
        }
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private String getResolvedLabelString() {
        IPath resolvedPath = this.getResolvedPath(this.getFilePath());
        if (resolvedPath != null) {
            return BasicElementLabels.getPathLabel(resolvedPath, true);
        }
        return "";
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = JavaCore.getClasspathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IStatus updateFileNameStatus(StringButtonDialogField field) {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = field.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
            return status;
        }
        IPath filePath = Path.fromOSString((String)fileName);
        if (this.isVariableEntry()) {
            if (filePath.getDevice() != null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_deviceinpath);
                return status;
            }
            String varName = filePath.segment(0);
            if (varName == null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
                return status;
            }
            this.fFileVariablePath = JavaCore.getClasspathVariable((String)varName);
            if (this.fFileVariablePath == null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_varnotexists);
                return status;
            }
            IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
            if (resolvedPath.isEmpty()) {
                status.setWarning(NewWizardMessages.SourceAttachmentBlock_filename_warning_varempty);
                return status;
            }
            File file = resolvedPath.toFile();
            if (!file.exists()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, BasicElementLabels.getPathLabel(resolvedPath, true));
                status.setWarning(message);
                return status;
            }
            if (!resolvedPath.isAbsolute()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
            String deprecationMessage = BuildPathSupport.getDeprecationMessage(varName);
            if (deprecationMessage != null) {
                status.setWarning(deprecationMessage);
                return status;
            }
        } else {
            String message;
            IPath location;
            File file = filePath.toFile();
            IResource res = this.fWorkspaceRoot.findMember(filePath);
            boolean exists = res != null ? ((location = res.getLocation()) != null ? location.toFile().exists() : res.exists()) : file.exists();
            if (!exists) {
                message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
            if (!filePath.isAbsolute()) {
                message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
        }
        return status;
    }

    private IPath getFilePath() {
        String filePath = this.isVariableEntry() ? this.fVariableFileNameField.getText() : (this.fWorkspaceRadio.isSelected() ? this.fWorkspaceFileNameField.getText() : this.fExternalFileNameField.getText());
        return Path.fromOSString((String)filePath).makeAbsolute();
    }

    private IPath chooseExtension() {
        IPath resolvedPath;
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry.getPath();
        }
        File initialSelection = (resolvedPath = this.getResolvedPath(currPath)) != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        JARFileSelectionDialog dialog = new JARFileSelectionDialog(this.getShell(), false, true, false);
        dialog.setTitle(NewWizardMessages.SourceAttachmentBlock_extvardialog_title);
        dialog.setMessage(NewWizardMessages.SourceAttachmentBlock_extvardialog_description);
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = Path.fromOSString((String)result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath chooseExtJarFile() {
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath(currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(NewWizardMessages.SourceAttachmentBlock_extjardialog_text);
        dialog.setFilterExtensions(ArchiveFileFilter.JAR_ZIP_FILTER_EXTENSIONS);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath(currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(NewWizardMessages.SourceAttachmentBlock_extfolderdialog_message);
        dialog.setText(NewWizardMessages.SourceAttachmentBlock_extfolderdialog_text);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternal() {
        String initSelection = this.fWorkspaceFileNameField.getText();
        ArchiveFileFilter filter = new ArchiveFileFilter(null, false, false);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSel = null;
        if (initSelection.length() > 0) {
            initSel = this.fWorkspaceRoot.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.addFilter(filter);
        dialog.setTitle(NewWizardMessages.SourceAttachmentBlock_intjardialog_title);
        dialog.setMessage(NewWizardMessages.SourceAttachmentBlock_intjardialog_message);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSel);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = JavaCore.getClasspathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    public static IRunnableWithProgress getRunnable(final Shell shell, final IClasspathEntry newEntry, final IJavaProject jproject, final IPath containerPath, final boolean isReferencedEntry) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    String[] changedAttributes = new String[]{"sourcepath", "source_encoding"};
                    BuildPathSupport.modifyClasspathEntry(shell, newEntry, changedAttributes, jproject, containerPath, isReferencedEntry, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public static String getSourceAttachmentEncoding(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("source_encoding".equals(attrib.getName())) {
                return attrib.getValue();
            }
            ++i;
        }
        return null;
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(field);
        }
    }
}

