/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.examples.domain.values.SequenceValue;

public class StringCharactersOperation
extends AbstractSimpleUnaryOperation {
    @NonNull
    public static final StringCharactersOperation INSTANCE = new StringCharactersOperation();
    @NonNull
    public static final CollectionTypeId SEQ_STRING = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{TypeId.STRING});

    @NonNull
    public SequenceValue evaluate(@Nullable Object sourceVal) {
        String sourceString = StringCharactersOperation.asString((Object)sourceVal);
        ArrayList<String> results = new ArrayList<String>(sourceString.length());
        int i = 0;
        while (i < sourceString.length()) {
            String s = sourceString.substring(i, i + 1);
            results.add(s);
            ++i;
        }
        return StringCharactersOperation.createSequenceValue((CollectionTypeId)SEQ_STRING, results);
    }
}

