/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.logical;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class BooleanAndOperation
extends AbstractSimpleBinaryOperation {
    @NonNull
    public static final BooleanAndOperation INSTANCE = new BooleanAndOperation();

    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        Object firstArgument;
        if (sourceValue == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        List arguments = callExp.getArgument();
        DomainExpression argument0 = (DomainExpression)arguments.get(0);
        assert (argument0 != null);
        try {
            firstArgument = evaluator.evaluate(argument0);
        }
        catch (InvalidValueException e) {
            firstArgument = e;
        }
        return this.evaluate(sourceValue, firstArgument);
    }

    @Nullable
    public Boolean evaluate(@Nullable Object left, @Nullable Object right) {
        if (left == Boolean.FALSE || right == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        if (left == Boolean.TRUE && right == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        if (left instanceof InvalidValueException) {
            throw (InvalidValueException)((Object)left);
        }
        if (right instanceof InvalidValueException) {
            throw (InvalidValueException)((Object)right);
        }
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Boolean)) {
            throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, new Object[]{"Boolean", BooleanAndOperation.getTypeName((Object)left)});
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, new Object[]{"Boolean", BooleanAndOperation.getTypeName((Object)right)});
    }
}

