/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class ClosureIteration
extends AbstractIteration {
    @NonNull
    public static final ClosureIteration INSTANCE = new ClosureIteration();

    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return ClosureIteration.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)accumulatorTypeId));
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        CollectionValue collectionValue;
        Object value = iterationManager.get();
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (!accumulatorValue.add(value)) {
            return CARRY_ON;
        }
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal instanceof InvalidValueException) {
            throw (InvalidValueException)bodyVal;
        }
        if (bodyVal == null) {
            return iterationManager.getAccumulatorValue();
        }
        if (bodyVal instanceof CollectionValue) {
            collectionValue = (CollectionValue)bodyVal;
        } else {
            DomainEvaluator evaluator = iterationManager.getEvaluator();
            DomainType elementType = evaluator.getStaticTypeOf(bodyVal);
            CollectionTypeId sequenceId = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{elementType.getTypeId()});
            collectionValue = evaluator.getIdResolver().createSequenceOfEach(sequenceId, new Object[]{bodyVal});
        }
        this.evaluateIteration(iterationManager.createNestedIterationManager(collectionValue));
        return CARRY_ON;
    }
}

