/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectivePackage
extends ExecutorPackage {
    @Nullable
    protected Map<DomainType, DomainInheritance> types = null;

    public ReflectivePackage(@NonNull String name, @Nullable String nsPrefix, @Nullable String nsURI, @NonNull PackageId packageId) {
        super(name, nsPrefix, nsURI, packageId);
    }

    @NonNull
    protected synchronized Map<DomainType, DomainInheritance> computeClasses() {
        this.types = new HashMap<DomainType, DomainInheritance>();
        HashMap<DomainType, DomainInheritance> types2 = this.types;
        for (DomainType domainType : this.getDomainTypes()) {
            if (domainType == null) continue;
            DomainInheritance executorType = this.createExecutorType(domainType);
            types2.put(domainType, executorType);
        }
        return types2;
    }

    @NonNull
    protected abstract DomainInheritance createExecutorType(@NonNull DomainType var1);

    @NonNull
    protected abstract Iterable<? extends DomainType> getDomainTypes();

    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainType type) {
        Map<DomainType, DomainInheritance> types2 = this.types;
        if (types2 == null) {
            types2 = this.computeClasses();
        }
        return (DomainInheritance)DomainUtil.nonNullState((Object)types2.get(type));
    }

    @Override
    @NonNull
    public List<? extends DomainType> getOwnedType() {
        Map<DomainType, DomainInheritance> types2 = this.types;
        if (types2 == null) {
            types2 = this.computeClasses();
        }
        ArrayList<DomainInheritance> values2 = new ArrayList<DomainInheritance>(types2.values());
        return values2;
    }

    @NonNull
    protected abstract DomainStandardLibrary getStandardLibrary();
}

