/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.utilities.IndexableIterable;
import org.eclipse.ocl.examples.library.oclany.OclAnyUnsupportedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveFragment
extends AbstractFragment {
    protected Map<DomainOperation, LibraryFeature> operationMap = null;
    protected Map<DomainProperty, LibraryFeature> propertyMap = null;

    public ReflectiveFragment(@NonNull DomainInheritance derivedInheritance, @NonNull DomainInheritance baseInheritance) {
        super(derivedInheritance, baseInheritance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LibraryFeature getImplementation(@NonNull DomainOperation baseOperation) {
        Object libraryFeature;
        if (this.operationMap == null) {
            ReflectiveFragment reflectiveFragment = this;
            synchronized (reflectiveFragment) {
                if (this.operationMap == null) {
                    this.operationMap = new HashMap<DomainOperation, LibraryFeature>();
                }
            }
        }
        if ((libraryFeature = this.operationMap.get(baseOperation)) != null) {
            return libraryFeature;
        }
        Map<DomainOperation, LibraryFeature> map = this.operationMap;
        synchronized (map) {
            libraryFeature = this.operationMap.get(baseOperation);
            if (libraryFeature != null) {
                return libraryFeature;
            }
            DomainOperation localOperation = this.getLocalOperation(baseOperation);
            if (localOperation == null && this.derivedInheritance == this.baseInheritance) {
                localOperation = baseOperation;
            }
            if (localOperation != null) {
                libraryFeature = localOperation.getImplementation();
            } else {
                DomainOperation bestOverload = null;
                DomainInheritance bestInheritance = null;
                int bestDepth = -1;
                int minDepth = this.baseInheritance.getDepth();
                int depth = this.derivedInheritance.getDepth() - 1;
                while (depth >= minDepth) {
                    IndexableIterable derivedSuperFragments = this.derivedInheritance.getSuperFragments(depth);
                    for (DomainFragment derivedSuperFragment : derivedSuperFragments) {
                        DomainOperation overload;
                        DomainInheritance superInheritance = derivedSuperFragment.getBaseInheritance();
                        DomainFragment superFragment = superInheritance.getFragment(this.baseInheritance);
                        if (superFragment == null || (overload = superFragment.getLocalOperation(baseOperation)) == null) continue;
                        if (bestInheritance == null) {
                            bestDepth = depth;
                            bestInheritance = superInheritance;
                            bestOverload = overload;
                            continue;
                        }
                        if (depth == bestDepth) {
                            bestOverload = null;
                            depth = -1;
                            break;
                        }
                        if (bestInheritance.isSubInheritanceOf(superInheritance)) continue;
                        bestOverload = null;
                        depth = -1;
                        break;
                    }
                    --depth;
                }
                libraryFeature = bestOverload != null ? bestOverload.getImplementation() : OclAnyUnsupportedOperation.AMBIGUOUS;
            }
            if (libraryFeature == null) {
                libraryFeature = OclAnyUnsupportedOperation.INSTANCE;
            }
            this.operationMap.put(baseOperation, (LibraryFeature)libraryFeature);
            return libraryFeature;
        }
    }

    @NonNull
    public Iterable<? extends DomainOperation> getLocalOperations() {
        return this.operationMap != null ? this.operationMap.keySet() : Collections.emptyList();
    }

    @NonNull
    public Iterable<? extends DomainProperty> getLocalProperties() {
        return this.propertyMap != null ? this.propertyMap.keySet() : Collections.emptyList();
    }
}

