/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyModelManager
implements DomainModelManager {
    private final Map<DomainType, Set<EObject>> modelManager = new HashMap<DomainType, Set<EObject>>();
    private final Collection<EObject> roots;

    public LazyModelManager(EObject context) {
        context = EcoreUtil.getRootContainer((EObject)context);
        this.roots = context.eResource() != null ? context.eResource().getContents() : Collections.singleton(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<EObject> get(@NonNull DomainType type) {
        Set<EObject> result = this.modelManager.get(type);
        if (result == null) {
            Map<DomainType, Set<EObject>> map = this.modelManager;
            synchronized (map) {
                result = this.modelManager.get(type);
                if (result == null) {
                    result = new HashSet<EObject>();
                    this.modelManager.put(type, result);
                    TreeIterator iter = EcoreUtil.getAllContents(this.roots);
                    while (iter.hasNext()) {
                        EObject next = (EObject)iter.next();
                        if (next == null || !this.isInstance(type, next)) continue;
                        result.add(next);
                    }
                }
            }
        }
        return result;
    }

    protected abstract boolean isInstance(@NonNull DomainType var1, @NonNull EObject var2);

    public String toString() {
        return this.modelManager.toString();
    }
}

