/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.values.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeParameters<T extends DomainType>
implements Iterable<Object> {
    private final int hashCode;
    @NonNull
    private final T elementType;
    @NonNull
    private final IntegerValue lower;
    @NonNull
    private final IntegerValue upper;

    public CollectionTypeParameters(@NonNull T elementType, @NonNull IntegerValue lower, @NonNull IntegerValue upper) {
        this.elementType = elementType;
        this.lower = lower;
        this.upper = upper;
        int hash = elementType.hashCode();
        hash = 111 * hash + lower.hashCode();
        this.hashCode = hash = 111 * hash + upper.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CollectionTypeParameters)) {
            return false;
        }
        CollectionTypeParameters that = (CollectionTypeParameters)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.elementType.equals(that.elementType)) {
            return false;
        }
        if (!this.lower.equals(that.lower)) {
            return false;
        }
        return this.upper.equals(that.upper);
    }

    @NonNull
    public T getElementType() {
        return this.elementType;
    }

    @NonNull
    public IntegerValue getLower() {
        return this.lower;
    }

    @NonNull
    public IntegerValue getUpper() {
        return this.upper;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NonNull
    public Iterator iterator() {
        return new Iterator();
    }

    public int parametersSize() {
        return 1;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(this.elementType);
        s.append(',');
        s.append(this.lower);
        s.append(',');
        s.append(this.upper);
        s.append(')');
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Iterator
    implements java.util.Iterator<Object> {
        private int position = 0;

        protected Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < 3;
        }

        @Override
        public Object next() {
            switch (this.position++) {
                case 0: {
                    return CollectionTypeParameters.this.elementType;
                }
                case 1: {
                    return CollectionTypeParameters.this.lower;
                }
                case 2: {
                    return CollectionTypeParameters.this.upper;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

