/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.examples.library.executor.ExecutorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreExecutorPackage
extends ExecutorPackage {
    protected final EPackage ePackage;
    private ExecutorStandardLibrary standardLibrary = null;
    private ExecutorType[] types = null;
    @Nullable
    private List<EcoreExecutorPackage> packages = null;

    public EcoreExecutorPackage(EPackage ePackage) {
        super((String)DomainUtil.nonNullEMF((Object)ePackage.getName()), ePackage.getNsPrefix(), ePackage.getNsURI(), IdManager.getPackageId((EPackage)ePackage));
        this.ePackage = ePackage;
    }

    @Override
    public final EPackage getEPackage() {
        return this.ePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends DomainPackage> getNestedPackage() {
        List<EcoreExecutorPackage> packages2 = this.packages;
        if (packages2 == null) {
            EcoreExecutorPackage ecoreExecutorPackage = this;
            synchronized (ecoreExecutorPackage) {
                packages2 = this.packages;
                if (packages2 == null) {
                    packages2 = this.packages = new ArrayList<EcoreExecutorPackage>();
                    for (EPackage eSubPackage : this.ePackage.getESubpackages()) {
                        assert (eSubPackage != null);
                        EcoreExecutorPackage subPackage = this.standardLibrary.getPackage(eSubPackage);
                        if (subPackage == null) continue;
                        packages2.add(subPackage);
                    }
                }
            }
        }
        return packages2;
    }

    public DomainPackage getNestingPackage() {
        EPackage eSuperPackage = this.ePackage.getESuperPackage();
        if (eSuperPackage == null) {
            return null;
        }
        return this.standardLibrary.getPackage(eSuperPackage);
    }

    @NonNull
    public List<DomainInheritance> getOwnedType() {
        if (this.types != null) {
            return Lists.newArrayList((Object[])this.types);
        }
        return Collections.emptyList();
    }

    public DomainInheritance getType(String typeName) {
        for (DomainInheritance type : this.getOwnedType()) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public void init(@Nullable ExecutorStandardLibrary standardLibrary, @NonNull ExecutorType[] types) {
        assert (this.standardLibrary == null);
        assert (this.types == null);
        this.standardLibrary = standardLibrary;
        this.types = types;
        if (standardLibrary != null) {
            standardLibrary.addPackage(this, null);
        }
    }

    @Deprecated
    public void init(@NonNull ExecutorType[] types) {
        this.init(null, types);
    }
}

