/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.numeric.NumericPlusOperation;

public class CollectionSumOperation
extends AbstractUnaryOperation {
    @NonNull
    public static final CollectionSumOperation INSTANCE = new CollectionSumOperation();

    @NonNull
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceVal) {
        CollectionValue collectionValue = CollectionSumOperation.asCollectionValue((Object)sourceVal);
        DomainStandardLibrary standardLibrary = evaluator.getStandardLibrary();
        DomainType returnType = evaluator.getIdResolver().getType(returnTypeId, null);
        Object result = returnType.conformsTo(standardLibrary, standardLibrary.getIntegerType()) ? ValuesUtil.integerValueOf((int)0) : ValuesUtil.realValueOf((double)0.0);
        for (Object element : collectionValue.iterable()) {
            result = NumericPlusOperation.INSTANCE.evaluate(result, element);
        }
        return result;
    }
}

