/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.widgets;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.views.properties.widgets.StringEditorWithReferences;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StringMultilineWithReferences
extends AbstractPropertyEditor {
    protected TextReferencesHelper textReferencesHelper;
    protected StringEditorWithReferences editor;

    public void setTextReferencesHelper(TextReferencesHelper helper) {
        this.textReferencesHelper = helper;
        this.editor.setTextReferencesHelper(helper);
        this.installDropListener();
    }

    protected void doBinding() {
        super.doBinding();
        IStaticContentProvider provider = this.input.getContentProvider(this.propertyPath);
        if (provider != null) {
            this.editor.setReferenceBrowserContentProvider(provider);
        }
        if (this.getInputObservableValue() instanceof ICommitListener) {
            this.editor.addCommitListener((ICommitListener)this.getInputObservableValue());
        }
    }

    public StringMultilineWithReferences(Composite parent, int style) {
        this.editor = new StringEditorWithReferences(parent, style);
        this.setEditor((AbstractValueEditor)this.editor);
    }

    protected void installDropListener() {
        DropTarget target = new DropTarget((Control)this.getStringEditor().getText(), 4);
        LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
        target.setTransfer(new Transfer[]{selectionTransfer});
        target.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                IStructuredSelection dropSelection = this.getSelection(event);
                if (dropSelection == null) {
                    return;
                }
                Iterator selectionIterator = dropSelection.iterator();
                Text textWidget = StringMultilineWithReferences.this.getStringEditor().getText();
                String textToEdit = textWidget.getText();
                int caretPosition = textWidget.getCaretPosition();
                while (selectionIterator.hasNext()) {
                    EObject selectedEObject = EMFHelper.getEObject(selectionIterator.next());
                    if (selectedEObject == null) continue;
                    textToEdit = StringMultilineWithReferences.this.textReferencesHelper.insertReference(selectedEObject, textToEdit, caretPosition);
                }
                textWidget.setText(textToEdit);
                StringMultilineWithReferences.this.getStringEditor().setFocus();
            }

            public void dragOver(DropTargetEvent event) {
                this.verifyDrop(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.verifyDrop(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
                this.verifyDrop(event);
            }

            private void verifyDrop(DropTargetEvent event) {
                IStructuredSelection selection = this.getSelection(event);
                if (this.isValidSelection(selection)) {
                    event.feedback = 4;
                    event.detail = 4;
                } else {
                    event.detail = 0;
                }
            }

            private IStructuredSelection getSelection(DropTargetEvent event) {
                if (!(event.getSource() instanceof DropTarget)) {
                    return null;
                }
                DropTarget target = (DropTarget)event.getSource();
                Transfer[] transferArray = target.getTransfer();
                int n = transferArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LocalSelectionTransfer selectionTransfer;
                    ISelection selection;
                    Transfer transfer = transferArray[n2];
                    if (transfer instanceof LocalSelectionTransfer && (selection = (selectionTransfer = (LocalSelectionTransfer)transfer).getSelection()) instanceof IStructuredSelection) {
                        return (IStructuredSelection)selection;
                    }
                    ++n2;
                }
                return null;
            }

            private boolean isValidSelection(IStructuredSelection dropSelection) {
                if (StringMultilineWithReferences.this.textReferencesHelper == null) {
                    return false;
                }
                if (dropSelection.isEmpty()) {
                    return false;
                }
                IStructuredSelection structuredSelection = dropSelection;
                Iterator selectionIterator = structuredSelection.iterator();
                while (selectionIterator.hasNext()) {
                    EObject selectedElement = EMFHelper.getEObject(selectionIterator.next());
                    if (selectedElement != null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    protected StringEditor getStringEditor() {
        return (StringEditor)this.valueEditor;
    }

    protected void setContentProvider(IStaticContentProvider provider) {
        this.editor.setReferenceBrowserContentProvider(provider);
    }

    protected void setLabelProvider(ILabelProvider labelProvider) {
        this.editor.setLabelProvider(labelProvider);
    }
}

