/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.modelelement;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.MultipleObservableValue;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeModelElement
extends AbstractModelElement {
    private List<ModelElement> elements = new LinkedList<ModelElement>();

    @Override
    public IObservable doGetObservable(String propertyPath) {
        AggregatedObservable observableComposite = null;
        for (ModelElement element : this.elements) {
            IObservable observable = element.getObservable(propertyPath);
            if (observableComposite == null) {
                if (observable instanceof AggregatedObservable) {
                    observableComposite = (AggregatedObservable)observable;
                    continue;
                }
                if (observable instanceof IObservableValue) {
                    observableComposite = new MultipleObservableValue().aggregate(observable);
                    if (observableComposite != null) continue;
                    return null;
                }
                return null;
            }
            if ((observableComposite = observableComposite.aggregate(observable)) != null) continue;
            return null;
        }
        return observableComposite;
    }

    public void addModelElement(ModelElement element) {
        this.elements.add(element);
    }

    @Override
    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (this.elements.isEmpty()) {
            return EmptyContentProvider.instance;
        }
        return this.elements.get(0).getContentProvider(propertyPath);
    }

    @Override
    public ILabelProvider getLabelProvider(String propertyPath) {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0).getLabelProvider(propertyPath);
    }

    @Override
    public boolean isOrdered(String propertyPath) {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (ModelElement element : this.elements) {
            if (!element.isOrdered(propertyPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnique(String propertyPath) {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (ModelElement element : this.elements) {
            if (element.isUnique(propertyPath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMandatory(String propertyPath) {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (ModelElement element : this.elements) {
            if (element.isMandatory(propertyPath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEditable(String propertyPath) {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (ModelElement element : this.elements) {
            if (element.isEditable(propertyPath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forceRefresh(String propertyPath) {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (ModelElement element : this.elements) {
            if (!element.forceRefresh(propertyPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultValue(String propertyPath) {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0).getDefaultValue(propertyPath);
    }

    public List<ModelElement> getSubElements() {
        return this.elements;
    }
}

