/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSFactory;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DetailCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ImportCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityCS;
import org.eclipse.ocl.examples.xtext.base.basecs.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PackageCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementWithURICS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.RootCS;
import org.eclipse.ocl.examples.xtext.base.basecs.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseReferenceVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2CSConversion
extends AbstractConversion
implements PivotConstants {
    private static final Logger logger = Logger.getLogger(Pivot2CSConversion.class);
    @NonNull
    protected final Pivot2CS converter;
    @NonNull
    protected final BaseDeclarationVisitor defaultDeclarationVisitor;
    @NonNull
    protected final BaseReferenceVisitor defaultReferenceVisitor;
    private org.eclipse.ocl.examples.pivot.Class scope = null;
    @NonNull
    private final Map<EClass, BaseDeclarationVisitor> declarationVisitorMap = new HashMap<EClass, BaseDeclarationVisitor>();
    @NonNull
    private final Map<EClass, BaseReferenceVisitor> referenceVisitorMap = new HashMap<EClass, BaseReferenceVisitor>();
    private Map<Namespace, List<String>> importedNamespaces = null;

    public Pivot2CSConversion(@NonNull Pivot2CS converter) {
        super(converter.getMetaModelManager());
        this.converter = converter;
        this.defaultDeclarationVisitor = converter.createDefaultDeclarationVisitor(this);
        this.defaultReferenceVisitor = converter.createDefaultReferenceVisitor(this);
    }

    protected void addBooleanQualifier(@NonNull List<String> qualifiers, @NonNull DetailCS csDetail, @NonNull String csString) {
        if (csDetail.getValue().size() == 1 && Boolean.valueOf((String)csDetail.getValue().get(0)).booleanValue()) {
            qualifiers.add(csString);
        } else {
            qualifiers.add("!" + csString);
        }
    }

    protected void createImports(@NonNull Resource csResource, @NonNull Map<Namespace, List<String>> importedNamespaces) {
        String alias;
        AliasAnalysis.dispose(csResource);
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)csResource);
        if (metaModelManager == null) {
            throw new IllegalStateException("No MetaModelManager");
        }
        AliasAnalysis aliasAnalysis = null;
        URI csURI = csResource.getURI();
        RootCS documentCS = (RootCS)csResource.getContents().get(0);
        ArrayList<ImportCS> imports = new ArrayList<ImportCS>();
        for (Namespace importedNamespace : importedNamespaces.keySet()) {
            EPackage ePackage;
            Resource resource;
            List<String> aliases;
            if (importedNamespace == null) continue;
            if (importedNamespace instanceof Package) {
                Package pivotPackage = metaModelManager.getPackageServer((DomainPackage)((Package)importedNamespace)).getPivotPackage();
                if (metaModelManager.getLibraries().contains(pivotPackage)) continue;
            }
            if ((aliases = importedNamespaces.get(importedNamespace)) == null || aliases.isEmpty()) {
                if (aliasAnalysis == null) {
                    aliasAnalysis = AliasAnalysis.getAdapter(csResource, metaModelManager);
                }
                alias = aliasAnalysis.getAlias((EObject)importedNamespace, null);
                aliases = Collections.singletonList(alias);
            }
            EObject eObject = importedNamespace.getETarget();
            String importURI = null;
            if (eObject instanceof EPackage && DomainUtil.isRegistered((Resource)(resource = (ePackage = (EPackage)eObject).eResource()))) {
                importURI = ePackage.getNsURI();
            }
            if (importURI == null) {
                URI fullURI = EcoreUtil.getURI((EObject)(eObject != null ? eObject : importedNamespace));
                URI deresolvedURI = fullURI.deresolve(csURI, true, true, false);
                importURI = deresolvedURI.toString();
            }
            for (String alias2 : aliases) {
                ImportCS importCS = BaseCSFactory.eINSTANCE.createImportCS();
                importCS.setName(alias2);
                PathNameCS csPathName = BaseCSFactory.eINSTANCE.createPathNameCS();
                importCS.setPathName(csPathName);
                EList<PathElementCS> csPath = csPathName.getPath();
                PathElementWithURICS csSimpleRef = BaseCSFactory.eINSTANCE.createPathElementWithURICS();
                csPath.add(csSimpleRef);
                csSimpleRef.setElement((Element)importedNamespace);
                csSimpleRef.setUri(importURI);
                importCS.setPivot((Element)importedNamespace);
                imports.add(importCS);
            }
        }
        if (aliasAnalysis != null) {
            aliasAnalysis.dispose();
        }
        aliasAnalysis = AliasAnalysis.getAdapter(csResource, metaModelManager);
        for (ImportCS csImport : imports) {
            Namespace namespace = csImport.getNamespace();
            alias = csImport.getName();
            if (namespace == null || alias != null) continue;
            alias = aliasAnalysis.getAlias((EObject)namespace, null);
            if (alias == null) {
                String name;
                String hint = null;
                if (namespace instanceof Package) {
                    hint = ((Package)namespace).getNsPrefix();
                }
                if (hint == null && (name = namespace.getName()).length() > 0) {
                    hint = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
                }
                if (hint != null) {
                    alias = aliasAnalysis.getAlias((EObject)namespace, hint);
                }
            }
            if (alias == null) continue;
            csImport.setName(alias);
        }
        Collections.sort(imports, new Comparator<ImportCS>(){

            @Override
            public int compare(ImportCS o1, ImportCS o2) {
                int d2;
                Namespace ns1 = o1.getNamespace();
                Namespace ns2 = o2.getNamespace();
                int d1 = PivotUtil.getContainmentDepth((EObject)ns1);
                if (d1 != (d2 = PivotUtil.getContainmentDepth((EObject)ns2))) {
                    return d1 - d2;
                }
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        documentCS.getOwnedImport().addAll(imports);
    }

    @Nullable
    public BaseDeclarationVisitor getDeclarationVisitor(@NonNull EClass eClass) {
        BaseDeclarationVisitor declarationVisitor = this.declarationVisitorMap.get(eClass);
        if (declarationVisitor == null && !this.declarationVisitorMap.containsKey(eClass)) {
            Pivot2CS.Factory factory = this.converter.getFactory(eClass);
            declarationVisitor = factory != null ? factory.createDeclarationVisitor(this) : this.defaultDeclarationVisitor;
            this.declarationVisitorMap.put(eClass, declarationVisitor);
        }
        return declarationVisitor;
    }

    @Nullable
    public BaseReferenceVisitor getReferenceVisitor(@NonNull EClass eClass) {
        BaseReferenceVisitor referenceVisitor = this.referenceVisitorMap.get(eClass);
        if (referenceVisitor == null && !this.referenceVisitorMap.containsKey(eClass)) {
            Pivot2CS.Factory factory = this.converter.getFactory(eClass);
            referenceVisitor = factory != null ? factory.createReferenceVisitor(this) : this.defaultReferenceVisitor;
            this.referenceVisitorMap.put(eClass, referenceVisitor);
        }
        return referenceVisitor;
    }

    public org.eclipse.ocl.examples.pivot.Class getScope() {
        return this.scope;
    }

    protected List<TemplateBindingCS> getTemplateBindings(ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedTemplateBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    public void importNamespace(@NonNull Namespace importNamespace, @Nullable String alias) {
        Namespace primaryNamespace = (Namespace)this.metaModelManager.getPrimaryElement((EObject)importNamespace);
        List<String> aliases = this.importedNamespaces.get(primaryNamespace);
        if (aliases == null) {
            aliases = new ArrayList<String>();
            this.importedNamespaces.put(primaryNamespace, aliases);
        }
        if (alias != null && !aliases.contains(alias)) {
            aliases.add(alias);
        }
    }

    protected <T extends ClassifierCS> T refreshClassifier(@NonNull Class<T> csClass, EClass csEClass, @NonNull Type object) {
        ClassifierCS csElement = (ClassifierCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        List<ConstraintCS> csInvariants = this.visitDeclarations(ConstraintCS.class, object.getOwnedInvariant(), null);
        for (ConstraintCS csInvariant : csInvariants) {
            csInvariant.setStereotype("invariant");
        }
        this.refreshList((List)csElement.getOwnedConstraint(), csInvariants);
        TemplateSignature ownedTemplateSignature = object.getOwnedTemplateSignature();
        if (ownedTemplateSignature != null) {
            csElement.setOwnedTemplateSignature(this.visitDeclaration(TemplateSignatureCS.class, (EObject)ownedTemplateSignature));
        }
        if (object.eIsSet((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME)) {
            csElement.setInstanceClassName(object.getInstanceClassName());
        } else {
            csElement.eUnset((EStructuralFeature)BaseCSPackage.Literals.CLASSIFIER_CS__INSTANCE_CLASS_NAME);
        }
        return (T)csElement;
    }

    public <T extends ModelElementCS> T refreshElement(@NonNull Class<T> csClass, EClass csEClass, @NonNull Element object) {
        assert (csClass == csEClass.getInstanceClass());
        EFactory eFactoryInstance = csEClass.getEPackage().getEFactoryInstance();
        ModelElementCS csElement = (ModelElementCS)eFactoryInstance.create(csEClass);
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            throw new ClassCastException();
        }
        csElement.setPivot(object);
        ModelElementCS castElement = csElement;
        return (T)castElement;
    }

    public <T extends NamedElementCS> T refreshNamedElement(@NonNull Class<T> csClass, EClass csEClass, @NonNull NamedElement object) {
        NamedElementCS csElement = (NamedElementCS)this.refreshElement(csClass, csEClass, (Element)object);
        String name = object.getName();
        csElement.setName(name);
        this.refreshList((List)csElement.getOwnedAnnotation(), this.visitDeclarations(AnnotationCS.class, object.getOwnedAnnotation(), null));
        return (T)csElement;
    }

    public void refreshPathName(@NonNull PathNameCS csPathName, @NonNull Element element, @Nullable Namespace scope) {
        Namespace safeScope = scope;
        Element primaryElement = (Element)this.metaModelManager.getPrimaryElement((EObject)element);
        if (safeScope != null && primaryElement instanceof Type) {
            String name = ((Type)primaryElement).getName();
            Namespace eObject = safeScope;
            while (eObject != null) {
                PackageServer packageServer;
                Type memberType;
                if (eObject instanceof Namespace) {
                    safeScope = eObject;
                }
                if (eObject instanceof DomainPackage && (memberType = (packageServer = this.metaModelManager.getPackageServer((DomainPackage)eObject)).getMemberType(name)) == primaryElement) {
                    if (eObject != scope && eObject != PivotUtil.getContainingPackage((EObject)scope)) {
                        eObject = eObject.eContainer();
                    }
                    if (!(eObject instanceof Namespace)) break;
                    safeScope = eObject;
                    break;
                }
                eObject = eObject.eContainer();
            }
        }
        ElementUtil.setPathName(csPathName, primaryElement, safeScope);
    }

    public void refreshQualifiers(List<String> qualifiers, String string, boolean polarity) {
        for (String qualifier : qualifiers) {
            if (!qualifier.equals(string)) continue;
            if (!polarity) {
                qualifiers.remove(qualifier);
            }
            return;
        }
        if (polarity) {
            qualifiers.add(string);
        }
    }

    public void refreshQualifiers(List<String> qualifiers, String trueString, String falseString, Boolean polarity) {
        boolean isFalse = false;
        boolean isTrue = false;
        for (String qualifier : qualifiers) {
            if (qualifier.equals(trueString)) {
                if (isTrue || polarity != Boolean.TRUE) {
                    qualifiers.remove(qualifier);
                }
                isTrue = true;
            }
            if (!qualifier.equals(falseString)) continue;
            if (isTrue || polarity != Boolean.FALSE) {
                qualifiers.remove(qualifier);
            }
            isFalse = true;
        }
        if (polarity == Boolean.TRUE) {
            if (!isTrue) {
                qualifiers.add(trueString);
            }
        } else if (polarity == Boolean.FALSE && !isFalse) {
            qualifiers.add(falseString);
        }
    }

    public <T extends StructuralFeatureCS> T refreshStructuralFeature(@NonNull Class<T> csClass, EClass csEClass, @NonNull Property object) {
        StructuralFeatureCS csElement = (StructuralFeatureCS)this.refreshTypedMultiplicityElement(csClass, csEClass, (TypedMultiplicityElement)object);
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "derived", object.isDerived());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "readonly", object.isReadOnly());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "static", object.isStatic());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "transient", object.isTransient());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "unsettable", object.isUnsettable());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "volatile", object.isVolatile());
        if (object.eIsSet((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT)) {
            csElement.setDefault(object.getDefault());
        } else {
            csElement.eUnset((EStructuralFeature)BaseCSPackage.Literals.STRUCTURAL_FEATURE_CS__DEFAULT);
        }
        return (T)csElement;
    }

    public <T extends TypedElementCS> T refreshTypedElement(@NonNull Class<T> csClass, EClass csEClass, @NonNull TypedElement object) {
        TypedElementCS csElement = (TypedElementCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        Type type = object.getType();
        if (type instanceof CollectionType && type.getUnspecializedElement() != this.metaModelManager.getCollectionType()) {
            PivotUtil.debugWellContainedness((Type)type);
            type = ((CollectionType)type).getElementType();
        } else if (type instanceof VoidType) {
            type = null;
        }
        if (type != null) {
            PivotUtil.debugWellContainedness((Type)type);
            TypedRefCS typeRef = this.visitReference(TypedRefCS.class, (EObject)type);
            csElement.setOwnedType(typeRef);
        } else {
            csElement.setOwnedType(null);
        }
        return (T)csElement;
    }

    public <T extends TypedElementCS> T refreshTypedMultiplicityElement(@NonNull Class<T> csClass, EClass csEClass, @NonNull TypedMultiplicityElement object) {
        T csElement = this.refreshTypedElement(csClass, csEClass, (TypedElement)object);
        TypedRefCS csTypeRef = csElement.getOwnedType();
        if (csTypeRef != null) {
            int upper;
            int lower;
            Type type = object.getType();
            if (type instanceof CollectionType && type.getUnspecializedElement() != this.metaModelManager.getCollectionType()) {
                CollectionType collectionType = (CollectionType)type;
                lower = collectionType.getLower().intValue();
                Number upper2 = collectionType.getUpper();
                upper = upper2 instanceof Unlimited ? -1 : upper2.intValue();
                EList<String> qualifiers = csElement.getQualifier();
                this.refreshQualifiers((List<String>)qualifiers, "ordered", "!ordered", collectionType.isOrdered() ? Boolean.TRUE : null);
                this.refreshQualifiers((List<String>)qualifiers, "unique", "!unique", collectionType.isUnique() ? null : Boolean.FALSE);
            } else {
                lower = object.isRequired() ? 1 : 0;
                upper = 1;
            }
            if (lower == 1 && upper == 1) {
                csTypeRef.setMultiplicity(null);
            } else {
                MultiplicityCS csMultiplicity;
                String stringValue = null;
                if (lower == 0) {
                    if (upper == 1) {
                        stringValue = "?";
                    } else if (upper == -1) {
                        stringValue = "*";
                    }
                } else if (lower == 1 && upper == -1) {
                    stringValue = "+";
                }
                if (stringValue != null) {
                    csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityStringCS();
                    csMultiplicity.setStringBounds(stringValue);
                    csTypeRef.setMultiplicity(csMultiplicity);
                } else {
                    csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityBoundsCS();
                    if (lower != 1) {
                        csMultiplicity.setLowerBound(lower);
                    }
                    if (upper != 1) {
                        csMultiplicity.setUpperBound(upper);
                    }
                    csTypeRef.setMultiplicity(csMultiplicity);
                }
            }
        }
        return csElement;
    }

    public org.eclipse.ocl.examples.pivot.Class setScope(org.eclipse.ocl.examples.pivot.Class object) {
        org.eclipse.ocl.examples.pivot.Class savedScope = this.scope;
        this.scope = object;
        return savedScope;
    }

    public void update(@NonNull Collection<? extends Resource> csResources) {
        HashMap<Resource, Map<Namespace, List<String>>> imports = new HashMap<Resource, Map<Namespace, List<String>>>();
        for (Resource resource : csResources) {
            if (resource == null) continue;
            this.importedNamespaces = new HashMap<Namespace, List<String>>();
            Resource asResource = this.converter.getPivotResource(resource);
            if (asResource == null) continue;
            List<PackageCS> list = this.visitDeclarations((Class)PackageCS.class, (List)asResource.getContents(), null);
            this.refreshList((List)resource.getContents(), list);
            imports.put(resource, this.importedNamespaces);
        }
        for (Resource resource : csResources) {
            Map importedNamespaces;
            if (resource == null || (importedNamespaces = (Map)imports.get(resource)) == null) continue;
            this.createImports(resource, importedNamespaces);
        }
    }

    @Nullable
    public <T extends ElementCS> T visitDeclaration(@NonNull Class<T> csClass, @Nullable EObject eObject) {
        ElementCS csElement;
        if (eObject == null) {
            return null;
        }
        EClass eClass = eObject.eClass();
        BaseDeclarationVisitor declarationVisitor = this.getDeclarationVisitor(eClass);
        if (declarationVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported declaration " + eClass.getName()));
            return null;
        }
        ElementCS castElement = csElement = (ElementCS)((Visitable)eObject).accept((Visitor)declarationVisitor);
        return (T)castElement;
    }

    @Nullable
    public <T extends ElementCS, V extends EObject> List<T> visitDeclarationAsList(@NonNull Class<T> csClass, @Nullable V eObject) {
        if (eObject == null) {
            return null;
        }
        T csElement = this.visitDeclaration(csClass, eObject);
        if (csElement == null) {
            return null;
        }
        return Collections.singletonList(csElement);
    }

    @NonNull
    public <T extends ElementCS, V extends EObject> List<T> visitDeclarations(@NonNull Class<T> csClass, List<V> eObjects, @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (eObjects != null);
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            T csElement;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (csElement = this.visitDeclaration(csClass, eObject)) == null) continue;
            csElements.add(csElement);
        }
        return csElements;
    }

    @Nullable
    public <T extends ElementCS> T visitReference(@NonNull Class<T> csClass, @NonNull EObject eObject) {
        EClass eClass = eObject.eClass();
        BaseReferenceVisitor referenceVisitor = this.getReferenceVisitor(eClass);
        if (referenceVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported reference " + eObject.eClass().getName()));
            return null;
        }
        ElementCS csElement = (ElementCS)((Visitable)eObject).accept((Visitor)referenceVisitor);
        if (csElement == null) {
            return null;
        }
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            logger.error((Object)("CS " + csElement.getClass().getName() + "' element is not a '" + csClass.getName() + "'"));
            return null;
        }
        ElementCS castElement = csElement;
        return (T)castElement;
    }

    @NonNull
    public <T extends ElementCS, V extends EObject> List<T> visitReferences(@NonNull Class<T> csClass, List<? extends V> eObjects, @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (eObjects != null);
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            T csElement;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (csElement = this.visitReference(csClass, eObject)) == null) continue;
            csElements.add(csElement);
        }
        return csElements;
    }
}

