/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.context.AbstractBase2PivotConversion;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.util.MorePivotable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityCS;
import org.eclipse.ocl.examples.xtext.base.basecs.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.OperationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PackageCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PivotableElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2as.BaseCSPreOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.InterDependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.PivotDependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2PivotConversion
extends AbstractBase2PivotConversion {
    private static final Logger logger = Logger.getLogger(CS2PivotConversion.class);
    @NonNull
    public static final TracingOption CONTINUATION = new TracingOption("org.eclipse.ocl.examples.xtext.base", "continuation");
    @NonNull
    protected final CS2Pivot converter;
    @NonNull
    protected final Collection<? extends BaseCSResource> csResources;
    @NonNull
    private final BaseCSVisitor<Continuation<?>> containmentVisitor;
    @NonNull
    private final BaseCSVisitor<Element> left2RightVisitor;
    @NonNull
    private final BaseCSVisitor<Continuation<?>> postOrderVisitor;
    @NonNull
    private final BaseCSVisitor<Continuation<?>> preOrderVisitor;
    @NonNull
    private InterDependency<BaseCSPreOrderVisitor.TemplateSignatureContinuation> typesHaveSignatures = new InterDependency("All unspecialized signatures defined", null);
    @NonNull
    private final Map<CacheKey<?>, Object> intermediateCache = new HashMap();
    private Map<String, Package> oldPackagesByName = null;
    private Map<String, Package> oldPackagesByQualifiedName = null;
    private final IDiagnosticConsumer diagnosticsConsumer;

    public CS2PivotConversion(@NonNull CS2Pivot converter, @NonNull IDiagnosticConsumer diagnosticsConsumer, @NonNull Collection<? extends BaseCSResource> csResources) {
        super(converter.getMetaModelManager());
        this.converter = converter;
        this.diagnosticsConsumer = diagnosticsConsumer;
        this.csResources = csResources;
        this.containmentVisitor = converter.createContainmentVisitor(this);
        this.left2RightVisitor = converter.createLeft2RightVisitor(this);
        this.postOrderVisitor = converter.createPostOrderVisitor(this);
        this.preOrderVisitor = converter.createPreOrderVisitor(this);
        ArrayList<ASResource> mappedResources = new ArrayList<ASResource>();
        for (BaseCSResource baseCSResource : csResources) {
            if (baseCSResource == null) continue;
            mappedResources.add(converter.getPivotResource(baseCSResource));
        }
    }

    @NonNull
    public OCLExpression addBadExpressionError(@NonNull ModelElementCS csElement, @NonNull String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
        InvalidLiteralExp invalidLiteralExp = this.metaModelManager.createInvalidExpression();
        csElement.setPivot((Element)invalidLiteralExp);
        return invalidLiteralExp;
    }

    public void addDiagnostic(@NonNull ModelElementCS csElement, @NonNull Diagnostic diagnostic) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, diagnostic.getMessage());
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addDiagnostic(@NonNull ElementCS csElement, @NonNull String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addWarning(@NonNull ModelElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    @NonNull
    public String bind(@NonNull EObject csContext, String messageTemplate, Object ... bindings) {
        return this.converter.bind(csContext, messageTemplate, bindings);
    }

    public boolean checkForNoErrors(@NonNull Collection<? extends BaseCSResource> csResources) {
        for (BaseCSResource baseCSResource : csResources) {
            EList errors = baseCSResource.getErrors();
            if (!ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)errors)) continue;
            return false;
        }
        return true;
    }

    public Dependency createTypeIsReferenceableDependency(@NonNull TypeRefCS csTemplateParameter) {
        if (csTemplateParameter instanceof WildcardTypeRefCS) {
            return null;
        }
        return new PivotDependency(csTemplateParameter);
    }

    protected void diagnoseContinuationFailure(@NonNull List<BasicContinuation<?>> continuations) {
        if (CONTINUATION.isActive()) {
            for (BasicContinuation<?> continuation : continuations) {
                CONTINUATION.println((String)DomainUtil.nonNullState((Object)continuation.toString()));
                Dependency[] dependencyArray = continuation.getDependencies();
                int n = dependencyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Dependency dependency = dependencyArray[n2];
                    boolean canExecute = dependency.canExecute();
                    CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + dependency.toString());
                    ++n2;
                }
            }
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        for (BasicContinuation<?> continuation : continuations) {
            s.append("\n  ");
            s.append(continuation);
            Dependency[] dependencyArray = continuation.getDependencies();
            int n = dependencyArray.length;
            int n3 = 0;
            while (n3 < n) {
                Dependency dependency = dependencyArray[n3];
                s.append("\n    ");
                if (!dependency.canExecute()) {
                    s.append("BLOCKED ");
                    dependency.canExecute();
                }
                s.append(dependency);
                ++n3;
            }
            continuation.canExecute();
            if (++i < 10) continue;
            s.append("\n  ...");
            break;
        }
        logger.error((Object)("Failed to complete continuations" + s.toString()));
    }

    public void garbageCollect(@NonNull Map<? extends Resource, ? extends ASResource> cs2asResourceMap) {
        Object eObject;
        Object referencedOrphan;
        final ArrayList<? extends ASResource> prunableResources = new ArrayList<ASResource>(cs2asResourceMap.values());
        ArrayList<Object> allPivotResources = new ArrayList<Object>((Collection<Object>)this.metaModelManager.getASResourceSet().getResources());
        EObject lockingObject = this.metaModelManager.getLockingObject();
        if (lockingObject != null) {
            allPivotResources.add(lockingObject);
        }
        allPivotResources.addAll(this.metaModelManager.getLibraries());
        allPivotResources.addAll(cs2asResourceMap.keySet());
        allPivotResources.remove(this.metaModelManager.getOrphanage().eResource());
        EcoreUtil.CrossReferencer referencesToOrphans = new EcoreUtil.CrossReferencer(allPivotResources){
            {
                super($anonymous0);
                this.crossReference();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                Resource eResource = crossReferencedEObject.eResource();
                boolean isPrunable = prunableResources.contains(eResource);
                return isPrunable;
            }

            protected void handleCrossReference(EObject eObject) {
                try {
                    super.handleCrossReference(eObject);
                    InternalEObject internalEObject = (InternalEObject)eObject;
                    for (EObject eContent : eObject.eContents()) {
                        EReference eReference = (EReference)eContent.eContainingFeature();
                        this.add(internalEObject, eReference, eContent);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            protected boolean resolve() {
                return false;
            }
        };
        HashSet<Object> wantedOrphans = new HashSet<Object>();
        ArrayList<Map.Entry> suspects = new ArrayList<Map.Entry>();
        for (Map.Entry entry : referencesToOrphans.entrySet()) {
            referencedOrphan = (EObject)entry.getKey();
            Collection referencesToOrphan = (Collection)entry.getValue();
            boolean wantIt = false;
            for (EStructuralFeature.Setting setting : referencesToOrphan) {
                eObject = setting.getEObject();
                Resource eResource = eObject.eResource();
                if (prunableResources.contains(eResource)) continue;
                wantedOrphans.add(referencedOrphan);
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            suspects.add(entry);
        }
        while (!suspects.isEmpty()) {
            ArrayList<Map.Entry> arrayList = suspects;
            suspects = new ArrayList();
            for (Map.Entry entry : arrayList) {
                EObject referencedOrphan2 = (EObject)entry.getKey();
                Collection referencesToOrphan = (Collection)entry.getValue();
                boolean wantIt = false;
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    EObject eObject2 = setting.getEObject();
                    if (!wantedOrphans.contains(eObject2)) continue;
                    wantedOrphans.add(referencedOrphan2);
                    wantIt = true;
                    break;
                }
                if (wantIt) continue;
                suspects.add(entry);
            }
            if (arrayList.size() <= suspects.size()) break;
        }
        for (Map.Entry entry : suspects) {
            EObject eContainer;
            referencedOrphan = (EObject)entry.getKey();
            boolean wantIt = false;
            for (EObject eChild : referencedOrphan.eContents()) {
                if (!wantedOrphans.contains(eChild)) continue;
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            Collection referencesToOrphan = (Collection)entry.getValue();
            if (referencesToOrphan != null) {
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    eObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature.isMany()) {
                        Collection list = (Collection)eObject.eGet(eStructuralFeature);
                        list.remove(referencedOrphan);
                        continue;
                    }
                    eObject.eSet(eStructuralFeature, null);
                }
            }
            if ((eContainer = referencedOrphan.eContainer()) == null) continue;
            PivotUtil.debugObjectUsage((String)"  container ", (EObject)eContainer);
            referencedOrphan.eSet(referencedOrphan.eContainingFeature(), null);
        }
    }

    protected void gatherNewPackage(@NonNull Set<Package> newPackages, @NonNull EObject pivot) {
        EObject eContainer;
        if (pivot instanceof Package) {
            newPackages.add((Package)pivot);
        }
        if ((eContainer = pivot.eContainer()) != null) {
            this.gatherNewPackage(newPackages, eContainer);
        }
    }

    protected void gatherNewPackages(@NonNull Set<Package> newPackages, @NonNull Resource csResource) {
        TreeIterator tit = csResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Pivotable)) continue;
            Element pObject = ((Pivotable)eObject).getPivot();
            if (pObject instanceof Package) {
                this.gatherNewPackage(newPackages, (EObject)pObject);
            } else if (pObject instanceof Root) {
                this.gatherNewPackage(newPackages, (EObject)pObject);
            } else {
                if (pObject instanceof Type) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Operation) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Property) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                }
                tit.prune();
            }
            if (!(eObject instanceof MorePivotable)) continue;
            for (Element pivot : ((MorePivotable)eObject).getMorePivots()) {
                if (pivot == null) continue;
                this.gatherNewPackage(newPackages, (EObject)pivot);
            }
        }
    }

    protected void gatherOldPackages(@NonNull List<? extends Package> pkgs) {
        for (Package package_ : pkgs) {
            String qualifiedName;
            Package oldPkg;
            String name = package_.getName();
            if (name == null) {
                name = "$null$";
            }
            if ((oldPkg = this.oldPackagesByQualifiedName.put(qualifiedName = this.getQualifiedName(new StringBuilder(), package_), package_)) != null) {
                logger.warn((Object)("Duplicate qualified package name: " + qualifiedName));
            }
            if (name.equals(qualifiedName)) {
                oldPkg = this.oldPackagesByName.put(name, package_);
                if (oldPkg != null && name.equals(this.getQualifiedName(new StringBuilder(), oldPkg))) {
                    logger.warn((Object)("Duplicate unqualified package name: " + qualifiedName));
                }
            } else {
                oldPkg = this.oldPackagesByName.get(name);
                if (oldPkg == null) {
                    this.oldPackagesByName.put(name, package_);
                }
            }
            List nestedPackage = package_.getNestedPackage();
            this.gatherOldPackages(nestedPackage);
        }
    }

    @NonNull
    public final CS2Pivot getConverter() {
        return this.converter;
    }

    public <T> T getIntermediate(@NonNull CacheKey<T> key) {
        return (T)this.intermediateCache.get(key);
    }

    @Nullable
    public Package getOldPackageByQualifiedName(@NonNull PackageCS csElement) {
        String qualifiedName = this.getQualifiedName(new StringBuilder(), csElement);
        return this.oldPackagesByQualifiedName.get(qualifiedName);
    }

    @Nullable
    public Package getOldPackageBySimpleName(@NonNull String name) {
        return this.oldPackagesByName.get(name);
    }

    @NonNull
    protected String getQualifiedName(@NonNull StringBuilder s, @NonNull Package pkg) {
        String name;
        Package nestingPackage = pkg.getNestingPackage();
        if (nestingPackage != null) {
            this.getQualifiedName(s, nestingPackage);
            s.append("$$");
        }
        if ((name = pkg.getName()) == null) {
            name = "$null$";
        }
        s.append(name);
        String string = s.toString();
        return string;
    }

    @NonNull
    protected String getQualifiedName(@NonNull StringBuilder s, @NonNull PackageCS csPackage) {
        String name;
        EObject eContainer = csPackage.eContainer();
        if (eContainer instanceof PackageCS) {
            this.getQualifiedName(s, (PackageCS)eContainer);
            s.append("$$");
        }
        if ((name = csPackage.getName()) == null) {
            URI csURI;
            Resource csResource;
            name = "$null$";
            if (eContainer == null && (csResource = csPackage.eResource()) != null && (csURI = csResource.getURI()) != null) {
                name = csURI.lastSegment();
            }
        }
        s.append(name);
        String string = s.toString();
        return string;
    }

    @NonNull
    protected List<TemplateBindingCS> getTemplateBindings(@NonNull ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedTemplateBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    @NonNull
    protected List<TemplateSignature> getTemplateSignatures(@NonNull Element pivotElement) {
        TemplateableElement templateableElement;
        TemplateSignature templateSignature;
        EObject container = pivotElement.eContainer();
        List<Object> pivotTemplateSignatures = container instanceof Element ? this.getTemplateSignatures((Element)container) : new ArrayList();
        if (pivotElement instanceof TemplateableElement && (templateSignature = (templateableElement = (TemplateableElement)pivotElement).getOwnedTemplateSignature()) != null) {
            pivotTemplateSignatures.add(templateSignature);
        }
        return pivotTemplateSignatures;
    }

    @NonNull
    public InterDependency<BaseCSPreOrderVisitor.TemplateSignatureContinuation> getTypesHaveSignaturesInterDependency() {
        return this.typesHaveSignatures;
    }

    public void handleVisitNamedElement(@NonNull NamedElementCS csNamedElement, @NonNull NamedElement pivotElement) {
        List pivotAnnotations = pivotElement.getOwnedAnnotation();
        EList<AnnotationElementCS> csAnnotations = csNamedElement.getOwnedAnnotation();
        this.refreshPivotList((Class)Annotation.class, pivotAnnotations, (List<? extends ModelElementCS>)csAnnotations);
    }

    public void installPivotReference(@NonNull ElementRefCS csElement, @NonNull Element newPivotElement, EReference eReference) {
        assert (eReference != null);
        this.converter.installPivotReference(csElement, newPivotElement, eReference);
    }

    public void installPivotUsage(@NonNull ModelElementCS csElement, @NonNull Element newPivotElement) {
        this.converter.installPivotUsage(csElement, newPivotElement);
    }

    protected void installRootContents(@NonNull BaseCSResource csResource) {
        for (EObject eObject : csResource.getContents()) {
            Resource asResource;
            Element pivotElement;
            if (!(eObject instanceof Pivotable) || (pivotElement = ((Pivotable)eObject).getPivot()) == null || (asResource = pivotElement.eResource()) != null) continue;
            this.installRootElement(csResource, pivotElement);
        }
    }

    public void installPivotTypeWithMultiplicity(@NonNull Type pivotType, @NonNull TypedRefCS csElement) {
        int lower = 1;
        int upper = 1;
        MultiplicityCS multiplicity = csElement.getMultiplicity();
        if (multiplicity != null) {
            lower = multiplicity.getLower();
            upper = multiplicity.getUpper();
        }
        if (upper == 1) {
            this.installPivotReference(csElement, (Element)pivotType, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        } else {
            boolean isOrdered = false;
            boolean isUnique = false;
            EObject eContainer = csElement.eContainer();
            if (eContainer instanceof TypedElementCS) {
                isOrdered = ElementUtil.isOrdered((TypedElementCS)eContainer);
                isUnique = ElementUtil.isUnique((TypedElementCS)eContainer);
            }
            IntegerValue lowerValue = ValuesUtil.integerValueOf((int)lower);
            UnlimitedValue upperValue = upper != -1 ? ValuesUtil.integerValueOf((int)upper) : ValuesUtil.UNLIMITED_VALUE;
            CollectionType pivotCollectionType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, (IntegerValue)upperValue);
            this.installPivotReference(csElement, (Element)pivotCollectionType, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        }
    }

    @Deprecated
    public void installRootElement(@NonNull Resource csResource, @NonNull Element pivotElement) {
        this.installRootElement((BaseCSResource)csResource, pivotElement);
    }

    public void installRootElement(@NonNull BaseCSResource csResource, @NonNull Element pivotElement) {
        ASResource asResource = this.converter.getPivotResource(csResource);
        if (asResource != null) {
            asResource.getContents().add((Object)pivotElement);
            this.metaModelManager.installResource((Resource)asResource);
        }
    }

    public boolean isInReturnTypeWithUnresolvedParameters(@NonNull ElementCS csElement) {
        OperationCS csOperation = null;
        ElementCS eObject = csElement;
        EObject eContainer = csElement.eContainer();
        while (true) {
            if (eContainer == null) {
                return false;
            }
            if (eContainer instanceof OperationCS) {
                csOperation = (OperationCS)eContainer;
                if (eObject == csOperation.getOwnedType()) break;
                return false;
            }
            eObject = eContainer;
            eContainer = eContainer.eContainer();
        }
        if (csOperation == null) {
            return false;
        }
        for (ParameterCS csParameter : csOperation.getOwnedParameter()) {
            Parameter pivot = (Parameter)PivotUtil.getPivot(Parameter.class, (Pivotable)csParameter);
            if (pivot == null) {
                return true;
            }
            if (pivot.getType() != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected List<BasicContinuation<?>> progressContinuations(@NonNull List<BasicContinuation<?>> continuations) {
        ArrayList moreContinuations = new ArrayList();
        boolean madeProgress = false;
        boolean tracingOn = CONTINUATION.isActive();
        if (tracingOn) {
            CONTINUATION.println("------------------------------------------------ " + continuations.size());
            CONTINUATION.println((String)DomainUtil.nonNullState((Object)this.typesHaveSignatures.toString()));
        }
        for (BasicContinuation<?> continuation : continuations) {
            boolean canExecute = continuation.canExecute();
            if (tracingOn) {
                CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + continuation);
            }
            if (canExecute) {
                madeProgress = true;
                BasicContinuation<?> nextContinuation = continuation.execute();
                if (nextContinuation == null) continue;
                nextContinuation.addTo(moreContinuations);
                continue;
            }
            moreContinuations.add(continuation);
        }
        return madeProgress ? moreContinuations : null;
    }

    public <T> T putIntermediate(CacheKey<T> key, T object) {
        return (T)this.intermediateCache.put(key, object);
    }

    public void refreshComments(Element pivotElement, ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node != null) {
            List<ILeafNode> documentationNodes = CS2Pivot.getDocumentationNodes(node);
            List ownedComments = pivotElement.getOwnedComment();
            if (documentationNodes != null) {
                Comment comment;
                String trimmedString;
                String string;
                ArrayList<String> documentationStrings = new ArrayList<String>();
                for (ILeafNode documentationNode : documentationNodes) {
                    String text = documentationNode.getText().replace("\r", "");
                    if (text.startsWith("/*") && text.endsWith("*/")) {
                        StringBuilder s = new StringBuilder();
                        String contentString = text.substring(2, text.length() - 2).trim();
                        String[] stringArray = contentString.split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string2 = stringArray[n2];
                            String trimmedString2 = string2.trim();
                            if (s.length() > 0) {
                                s.append("\n");
                            }
                            s.append(trimmedString2.startsWith("*") ? trimmedString2.substring(1).trim() : trimmedString2);
                            ++n2;
                        }
                        documentationStrings.add(s.toString());
                        continue;
                    }
                    documentationStrings.add(text.trim());
                }
                int iMax = Math.min(documentationStrings.size(), ownedComments.size());
                int i = 0;
                while (i < iMax) {
                    string = (String)documentationStrings.get(i);
                    if (string != null && !(trimmedString = string).equals((comment = (Comment)ownedComments.get(i)).getBody())) {
                        comment.setBody(trimmedString);
                    }
                    ++i;
                }
                while (i < documentationStrings.size()) {
                    string = (String)documentationStrings.get(i);
                    if (string != null) {
                        trimmedString = string;
                        comment = PivotFactory.eINSTANCE.createComment();
                        comment.setBody(trimmedString);
                        ownedComments.add(comment);
                    }
                    ++i;
                }
                while (i < ownedComments.size()) {
                    ownedComments.remove(ownedComments.size() - 1);
                }
            } else if (ownedComments.size() > 0) {
                ownedComments.clear();
            }
        }
    }

    public void refreshContextVariable(@NonNull ExpressionInOCL pivotSpecification) {
        EObject eContainer = pivotSpecification.eContainer();
        EStructuralFeature eContainingFeature = pivotSpecification.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.CONSTRAINT__SPECIFICATION) {
            Constraint contextConstraint = (Constraint)eContainer;
            eContainer = contextConstraint.eContainer();
            eContainingFeature = contextConstraint.eContainingFeature();
            if (eContainingFeature == PivotPackage.Literals.TYPE__OWNED_INVARIANT) {
                Type contextType = (Type)eContainer;
                if (contextType != null) {
                    this.setClassifierContext(pivotSpecification, contextType);
                }
                this.setContextVariable(pivotSpecification, "self", contextType);
            } else if (eContainingFeature == PivotPackage.Literals.OPERATION__PRECONDITION) {
                Operation contextOperation = (Operation)eContainer;
                if (contextOperation != null) {
                    this.setContextVariable(pivotSpecification, "self", contextOperation.getOwningType());
                    this.setOperationContext(pivotSpecification, contextOperation, null);
                } else {
                    this.setContextVariable(pivotSpecification, "self", null);
                }
            } else if (eContainingFeature == PivotPackage.Literals.OPERATION__POSTCONDITION) {
                Operation contextOperation = (Operation)eContainer;
                if (contextOperation != null) {
                    this.setContextVariable(pivotSpecification, "self", contextOperation.getOwningType());
                    this.setOperationContext(pivotSpecification, contextOperation, "result");
                } else {
                    this.setContextVariable(pivotSpecification, "self", null);
                }
            } else if (eContainingFeature == null) {
                logger.error((Object)("No context container for: " + pivotSpecification));
            } else {
                logger.error((Object)("Unsupported refreshContextVariable for a constraint: " + eContainingFeature));
            }
        } else if (eContainingFeature == PivotPackage.Literals.PROPERTY__DEFAULT_EXPRESSION) {
            Property contextProperty = (Property)eContainer;
            if (contextProperty != null) {
                this.setPropertyContext(pivotSpecification, contextProperty);
                this.setContextVariable(pivotSpecification, "self", contextProperty.getOwningType());
            } else {
                this.setContextVariable(pivotSpecification, "self", null);
            }
        } else if (eContainingFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
            Operation contextOperation = (Operation)eContainer;
            if (contextOperation != null) {
                this.setContextVariable(pivotSpecification, "self", contextOperation.getOwningType());
                this.setOperationContext(pivotSpecification, contextOperation, null);
            } else {
                this.setContextVariable(pivotSpecification, "self", null);
            }
        } else {
            logger.error((Object)("Unsupported refreshContextVariable for a specification: " + eContainingFeature));
        }
    }

    public <T extends Element> void refreshList(@NonNull Class<T> pivotClass, List<T> pivotElements, List<? extends PivotableElementCS> csElements) {
        assert (csElements != null);
        if (!pivotElements.isEmpty() || !csElements.isEmpty()) {
            ArrayList<Element> newPivotElements = new ArrayList<Element>();
            for (PivotableElementCS pivotableElementCS : csElements) {
                Object pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)pivotableElementCS);
                if (pivotElement == null && pivotableElementCS instanceof ModelElementCS) {
                    pivotElement = this.converter.getPivotElement(pivotClass, (ModelElementCS)pivotableElementCS);
                }
                if (pivotElement == null || newPivotElements.contains(pivotElement)) continue;
                newPivotElements.add((Element)pivotElement);
            }
            PivotUtil.refreshList(pivotElements, newPivotElements);
        }
    }

    @NonNull
    public <T extends Element> T refreshModelElement(@NonNull Class<T> pivotClass, EClass pivotEClass, @Nullable ModelElementCS csElement) {
        assert (pivotEClass != null);
        return this.converter.refreshModelElement(pivotClass, pivotEClass, csElement);
    }

    public <T extends Element> void refreshPivotList(@NonNull Class<T> pivotClass, List<? super T> pivotElements, List<? extends ModelElementCS> csElements) {
        assert (pivotElements != null);
        assert (csElements != null);
        if (pivotElements.isEmpty() && csElements.isEmpty()) {
            return;
        }
        ArrayList<Element> newPivotElements = new ArrayList<Element>();
        for (ModelElementCS modelElementCS : csElements) {
            Element pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)modelElementCS);
            if (pivotElement == null) continue;
            newPivotElements.add(pivotElement);
        }
        PivotUtil.refreshList(pivotElements, newPivotElements);
    }

    public Type refreshRequiredType(@NonNull TypedMultiplicityElement pivotElement, @NonNull TypedElementCS csTypedElement) {
        TypedRefCS ownedType = csTypedElement.getOwnedType();
        Type pivotType = null;
        boolean isRequired = false;
        if (ownedType != null) {
            pivotType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)ownedType);
            int lower = ElementUtil.getLower(csTypedElement);
            int upper = ElementUtil.getUpper(csTypedElement);
            isRequired = upper == 1 ? lower == 1 : true;
        }
        if (pivotType == null) {
            pivotType = this.metaModelManager.getOclVoidType();
            isRequired = false;
        }
        this.setType((TypedElement)pivotElement, pivotType, isRequired);
        return pivotType;
    }

    public void refreshTemplateSignature(@NonNull TemplateableElementCS csTemplateableElement, @NonNull TemplateableElement pivotTemplateableElement) {
        TemplateSignatureCS csTemplateSignature = csTemplateableElement.getOwnedTemplateSignature();
        if (csTemplateSignature == null) {
            if (pivotTemplateableElement.getOwnedTemplateSignature() != null) {
                pivotTemplateableElement.setOwnedTemplateSignature(null);
            }
            return;
        }
        TemplateSignature pivotTemplateSignature = (TemplateSignature)PivotUtil.getPivot(TemplateSignature.class, (Pivotable)csTemplateSignature);
        if (pivotTemplateableElement.getOwnedTemplateSignature() != pivotTemplateSignature) {
            pivotTemplateableElement.setOwnedTemplateSignature(pivotTemplateSignature);
        }
    }

    protected void resetPivotMappings(@NonNull Collection<? extends BaseCSResource> csResources) {
        for (BaseCSResource baseCSResource : csResources) {
            TreeIterator tit = baseCSResource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Pivotable)) continue;
                Pivotable pivotable = (Pivotable)eObject;
                pivotable.resetPivot();
            }
        }
    }

    public void setReferredIteration(@NonNull LoopExp expression, @Nullable Iteration iteration) {
        expression.setReferredIteration(iteration);
    }

    public void setReferredOperation(@NonNull OperationCallExp expression, @Nullable Operation operation) {
        expression.setReferredOperation(operation);
    }

    protected void specializeTemplateBindings(@NonNull List<TemplateBinding> templateBindings, @NonNull List<TemplateSignature> templateSignatures, @NonNull List<TemplateBindingCS> csTemplateBindings) {
        int pivotIMax;
        int csIMax = csTemplateBindings.size();
        if (csIMax != (pivotIMax = templateSignatures.size())) {
            TypedTypeRefCS owningTemplateBindableElement = csTemplateBindings.get(0).getOwningTemplateBindableElement();
            String string = owningTemplateBindableElement != null ? owningTemplateBindableElement.toString() : "<null>";
            logger.warn((Object)("Inconsistent template bindings size for " + string));
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            TemplateBindingCS csTemplateBinding = csTemplateBindings.get(i);
            if (csTemplateBinding != null) {
                TemplateSignature templateSignature = templateSignatures.get(i);
                int oldMax = templateBindings.size();
                TemplateBinding templateBinding = null;
                int j = i;
                while (j < oldMax) {
                    TemplateBinding oldTemplateBinding = templateBindings.get(j);
                    if (oldTemplateBinding.getSignature() == templateSignature) {
                        if (j != i) {
                            templateBindings.add(i, templateBindings.remove(j));
                        }
                        templateBinding = oldTemplateBinding;
                        break;
                    }
                    ++j;
                }
                if (templateBinding == null) {
                    templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
                    templateBinding.setSignature(templateSignature);
                    if (i < oldMax) {
                        templateBindings.add(i, templateBinding);
                    } else {
                        templateBindings.add(templateBinding);
                    }
                }
                this.installPivotReference(csTemplateBinding, (Element)templateBinding, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
                List parameterSubstitutions = templateBinding.getParameterSubstitution();
                List templateParameters = templateSignature.getOwnedParameter();
                EList<TemplateParameterSubstitutionCS> csParameterSubstitutions = csTemplateBinding.getOwnedParameterSubstitution();
                this.specializeTemplateParameterSubstitutions(parameterSubstitutions, templateParameters, (List<TemplateParameterSubstitutionCS>)csParameterSubstitutions);
                assert (templateSignatures.get(i) == templateBindings.get(i).getSignature());
            }
            ++i;
        }
        int k = templateBindings.size();
        while (k > newMax) {
            templateBindings.remove(--k);
        }
        assert (templateSignatures.size() == templateBindings.size());
    }

    protected void specializeTemplateParameterSubstitutions(@NonNull List<TemplateParameterSubstitution> templateParameterSubstitutions, @NonNull List<TemplateParameter> templateParameters, @NonNull List<TemplateParameterSubstitutionCS> csTemplateParameterSubstitutions) {
        int pivotIMax;
        int csIMax = csTemplateParameterSubstitutions.size();
        if (csIMax != (pivotIMax = templateParameters.size())) {
            logger.warn((Object)"Inconsistent template parameter substitutions size");
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            ParameterableElement pivotActualParameter;
            TypeRefCS csActualParameter;
            TemplateParameterSubstitutionCS csTemplateParameterSubstitution = csTemplateParameterSubstitutions.get(i);
            TemplateParameter templateParameter = templateParameters.get(i);
            int oldMax = templateParameterSubstitutions.size();
            TemplateParameterSubstitution templateParameterSubstitution = null;
            int j = i;
            while (j < oldMax) {
                TemplateParameterSubstitution oldTemplateParameterSubstitution = templateParameterSubstitutions.get(j);
                if (oldTemplateParameterSubstitution.getFormal() == templateParameter) {
                    if (j != i) {
                        templateParameterSubstitutions.add(i, templateParameterSubstitutions.remove(j));
                    }
                    templateParameterSubstitution = oldTemplateParameterSubstitution;
                    this.converter.installPivotDefinition(csTemplateParameterSubstitution, (Element)templateParameterSubstitution);
                    break;
                }
                ++j;
            }
            if (templateParameterSubstitution == null) {
                templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(templateParameter);
                if (i < oldMax) {
                    templateParameterSubstitutions.add(i, templateParameterSubstitution);
                } else {
                    templateParameterSubstitutions.add(templateParameterSubstitution);
                }
            }
            if ((csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter()) instanceof WildcardTypeRefCS) {
                pivotActualParameter = templateParameterSubstitution.getOwnedActual();
                if (pivotActualParameter == null) {
                    pivotActualParameter = PivotFactory.eINSTANCE.createClass();
                    templateParameterSubstitution.setOwnedActual(pivotActualParameter);
                }
                String name = "wildcard";
                if (i > 1) {
                    name = String.valueOf(name) + i;
                }
                ((NamedElement)pivotActualParameter).setName(name);
            } else {
                pivotActualParameter = (ParameterableElement)PivotUtil.getPivot(ParameterableElement.class, (Pivotable)csActualParameter);
                templateParameterSubstitution.setActual(pivotActualParameter);
            }
            this.converter.installPivotDefinition(csTemplateParameterSubstitution, (Element)templateParameterSubstitution);
            assert (templateParameters.get(i) == templateParameterSubstitutions.get(i).getFormal());
            ++i;
        }
        int k = templateParameterSubstitutions.size();
        while (k > newMax) {
            templateParameterSubstitutions.remove(--k);
        }
        assert (templateParameters.size() == templateParameterSubstitutions.size());
    }

    @Nullable
    protected TemplateableElement specializeTemplates(@NonNull TypedTypeRefCS csElement) {
        TemplateBindingCS ownedTemplateBinding = csElement.getOwnedTemplateBinding();
        assert (ownedTemplateBinding != null);
        Type unspecializedPivotElement = csElement.getType();
        if (unspecializedPivotElement == null || unspecializedPivotElement.eIsProxy()) {
            String moniker = csElement.toString();
            logger.error((Object)("Nothing to specialize as " + moniker));
            return null;
        }
        Type specializedPivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csElement);
        if (specializedPivotElement == null) {
            Type templateArgument;
            TemplateParameterSubstitutionCS csTemplateParameterSubstitution;
            if (unspecializedPivotElement instanceof CollectionType) {
                csTemplateParameterSubstitution = (TemplateParameterSubstitutionCS)ownedTemplateBinding.getOwnedParameterSubstitution().get(0);
                templateArgument = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution.getOwnedActualParameter());
                specializedPivotElement = templateArgument != null ? this.metaModelManager.getCollectionType((CollectionType)unspecializedPivotElement, templateArgument, null, null) : unspecializedPivotElement;
            } else if (unspecializedPivotElement instanceof Metaclass) {
                csTemplateParameterSubstitution = (TemplateParameterSubstitutionCS)ownedTemplateBinding.getOwnedParameterSubstitution().get(0);
                templateArgument = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution.getOwnedActualParameter());
                specializedPivotElement = templateArgument != null ? this.metaModelManager.getMetaclass((DomainType)templateArgument) : unspecializedPivotElement;
            } else {
                ArrayList<Type> templateArguments = new ArrayList<Type>();
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution2 : ownedTemplateBinding.getOwnedParameterSubstitution()) {
                    Type templateArgument2 = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution2.getOwnedActualParameter());
                    templateArguments.add(templateArgument2);
                }
                specializedPivotElement = this.metaModelManager.getLibraryType(unspecializedPivotElement, templateArguments);
            }
        }
        this.installPivotReference(csElement, (Element)specializedPivotElement, BaseCSPackage.Literals.TYPED_TYPE_REF_CS__TYPE);
        if (specializedPivotElement != unspecializedPivotElement) {
            List templateBindings = specializedPivotElement.getTemplateBinding();
            List<TemplateSignature> templateSignatures = this.getTemplateSignatures((Element)unspecializedPivotElement);
            List<TemplateBindingCS> csTemplateBindings = this.getTemplateBindings(csElement);
            this.specializeTemplateBindings(templateBindings, templateSignatures, csTemplateBindings);
        }
        return specializedPivotElement;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean update() {
        this.resetPivotMappings(this.csResources);
        this.oldPackagesByName = new HashMap<String, Package>();
        this.oldPackagesByQualifiedName = new HashMap<String, Package>();
        for (BaseCSResource csResource : this.converter.csResources) {
            asResource = this.converter.cs2PivotMapping.getASResource(csResource);
            if (asResource == null) continue;
            for (Object eObject : asResource.getContents()) {
                if (!(eObject instanceof Root)) continue;
                nestedPackage = ((Root)eObject).getNestedPackage();
                this.gatherOldPackages(nestedPackage);
            }
        }
        continuations = new ArrayList<BasicContinuation<?>>();
        for (BaseCSResource csResource : this.csResources) {
            for (Object eObject : csResource.getContents()) {
                if (!(eObject instanceof ElementCS)) continue;
                this.visitContainment((ElementCS)eObject, continuations);
            }
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(this.csResources);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        for (BaseCSResource csResource : this.csResources) {
            if (csResource == null) continue;
            this.installRootContents(csResource);
        }
        for (BaseCSResource csResource : this.csResources) {
            for (Object eObject : csResource.getContents()) {
                if (!(eObject instanceof ElementCS)) continue;
                this.visitInPreOrder((ElementCS)eObject, continuations);
            }
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(this.csResources);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        oclAnyType = this.metaModelManager.getOclAnyType();
        for (BaseCSResource csResource : this.csResources) {
            for (EObject eObject : csResource.getContents()) {
                if (!(eObject instanceof ElementCS)) continue;
                this.visitInPostOrder((ElementCS)eObject, continuations);
            }
        }
        hasNoErrors = this.checkForNoErrors(this.csResources);
        if (hasNoErrors) ** GOTO lbl65
        return false;
lbl-1000:
        // 1 sources

        {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
lbl65:
            // 2 sources

            ** while (continuations.size() > 0)
        }
lbl66:
        // 4 sources

        for (BaseCSResource csResource : this.csResources) {
            if (csResource == null) continue;
            this.installRootContents(csResource);
        }
        this.resolveUnderspecifiedTypes();
        hasNoMoreErrors = this.checkForNoErrors(this.csResources);
        if (!hasNoMoreErrors) {
            return false;
        }
        newPackages = new HashSet<Package>();
        for (BaseCSResource csResource : this.csResources) {
            if (csResource == null) continue;
            this.gatherNewPackages(newPackages, (Resource)csResource);
        }
        obsoletePackages = new HashSet<Package>(this.oldPackagesByQualifiedName.values());
        obsoletePackages.removeAll(newPackages);
        for (Package obsoletePackage : obsoletePackages) {
            eContainer = obsoletePackage.eContainer();
            if (eContainer == null) continue;
            eContainmentFeature = obsoletePackage.eContainmentFeature();
            if (eContainmentFeature.isMany()) {
                siblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                siblings.remove(obsoletePackage);
                continue;
            }
            eContainer.eSet((EStructuralFeature)eContainmentFeature, null);
        }
        return true;
    }

    protected void visitContainment(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        String message;
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitContainment((ElementCS)eContent, continuations);
        }
        try {
            Continuation<?> continuation = csElement.accept(this.containmentVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (IllegalLibraryException e) {
            message = e.getMessage();
            this.addDiagnostic(csElement, message);
        }
        catch (Throwable e) {
            message = String.valueOf(e);
            this.addDiagnostic(csElement, message);
        }
    }

    protected void visitInPostOrder(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitInPostOrder((ElementCS)eContent, continuations);
        }
        try {
            Continuation<?> continuation = csElement.accept(this.postOrderVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (Throwable e) {
            String message = String.valueOf(e);
            this.addDiagnostic(csElement, message);
        }
    }

    protected void visitInPreOrder(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        try {
            Continuation<?> continuation = csElement.accept(this.preOrderVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (Throwable e) {
            String message = String.valueOf(e);
            this.addDiagnostic(csElement, message);
        }
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitInPreOrder((ElementCS)eContent, continuations);
        }
    }

    public <T extends Element> T visitLeft2Right(@NonNull Class<T> pivotClass, @NonNull ElementCS csElement) {
        Element element = null;
        try {
            element = csElement.accept(this.left2RightVisitor);
        }
        catch (Throwable e) {
            String message = String.valueOf(e);
            this.addDiagnostic(csElement, message);
        }
        if (element == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheKey<T> {
        @NonNull
        protected final String name;

        public CacheKey(@NonNull String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

