/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.projectedEditing;

import com.google.inject.Inject;
import java.io.InputStream;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codetemplates.ui.projectedEditing.PartialParser;
import org.eclipse.xtext.ui.codetemplates.ui.registry.LanguageRegistry;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporaryResourceProvider {
    @Inject
    private LanguageRegistry languageRegistry;

    public <Result> Result useTemporaryResource(ResourceSet resourceSet, Grammar language, AbstractRule rootRule, String content, IUnitOfWork<Result, XtextResource> runnable) {
        XtextResource resource = this.languageRegistry.createTemporaryResourceIn(language, resourceSet);
        if (rootRule != null) {
            PartialParser.assignRootRule(resource, (ParserRule)rootRule);
        }
        try {
            resource.load((InputStream)new StringInputStream(content, resource.getEncoding()), null);
            Object object = runnable.exec((Object)resource);
            return (Result)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (resource != null) {
                if (resource.isLoaded()) {
                    resource.unload();
                }
                resourceSet.getResources().remove((Object)resource);
            }
        }
    }
}

