/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.menu.actions.ZoomAction;
import org.eclipse.papyrus.uml.diagram.menu.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomToolbar
extends ContributionItem
implements ZoomListener,
Listener,
IPageChangedListener {
    protected Combo combo = null;
    private IPartService partService = null;
    private IPartListener partListener = null;

    public ZoomToolbar() {
        this("");
    }

    public ZoomToolbar(String id) {
        super(id);
        this.init();
    }

    public void dispose() {
        super.dispose();
        if (this.partService != null) {
            this.partService.removePartListener(this.partListener);
        }
    }

    protected void init() {
        this.addPartListener();
        this.refreshCombo();
    }

    protected void addPartListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbench = workbench.getActiveWorkbenchWindow();
        if (activeWorkbench != null) {
            this.partService = activeWorkbench.getPartService();
            if (this.partService != null) {
                this.partListener = new CustomPartListener();
                this.partService.addPartListener(this.partListener);
            }
        }
    }

    public void fill(ToolBar parent, int index) {
        ToolItem toolItem = new ToolItem(parent, 2);
        Image zoomImage = Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.menu", (String)"/icons/zoomplus.gif");
        toolItem.setImage(zoomImage);
        toolItem.setToolTipText(Messages.ZoomToolbar_Zoom);
        this.combo = new Combo((Composite)parent, 4);
        this.combo.setItems(this.getZoomLevelsAsText(this.getZoomManager()));
        this.combo.setVisibleItemCount(20);
        this.combo.pack();
        toolItem.setWidth(this.combo.getSize().x);
        toolItem.setControl((Control)this.combo);
        this.combo.addListener(13, (Listener)this);
        this.combo.addListener(1, (Listener)this);
        this.combo.setEnabled(this.getDiagramEditPart() != null);
        this.refreshCombo();
        parent.pack();
    }

    public boolean isDynamic() {
        return true;
    }

    public String[] getZoomLevelsAsText(ZoomManager manager) {
        int nNumericZoomLevels = 0;
        if (manager != null) {
            nNumericZoomLevels = manager.getZoomLevels().length;
        }
        String[] allZoomLevels = new String[nNumericZoomLevels + 6];
        allZoomLevels[0] = ZoomAction.ZOOM_IN;
        allZoomLevels[1] = ZoomAction.ZOOM_OUT;
        allZoomLevels[2] = ZoomAction.ZOOM_FIT;
        allZoomLevels[3] = ZoomAction.ZOOM_WIDTH;
        allZoomLevels[4] = ZoomAction.ZOOM_HEIGHT;
        allZoomLevels[5] = ZoomAction.ZOOM_SELECTION;
        if (manager != null) {
            String[] numericZoomLevels = manager.getZoomLevelsAsText();
            int i = 0;
            while (i < manager.getZoomLevels().length) {
                allZoomLevels[i + 6] = numericZoomLevels[i];
                ++i;
            }
        }
        return allZoomLevels;
    }

    protected IDiagramWorkbenchPart getWorkbenchPart() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof IDiagramWorkbenchPart) {
            return (IDiagramWorkbenchPart)part;
        }
        return null;
    }

    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        return this.getWorkbenchPart() instanceof IDiagramWorkbenchPart ? this.getWorkbenchPart() : null;
    }

    protected DiagramEditPart getDiagramEditPart() {
        IDiagramWorkbenchPart editor = this.getDiagramWorkbenchPart();
        return editor != null ? editor.getDiagramEditPart() : null;
    }

    protected ZoomManager getZoomManager() {
        if (this.getDiagramWorkbenchPart() != null) {
            return (ZoomManager)this.getDiagramWorkbenchPart().getAdapter(ZoomManager.class);
        }
        return null;
    }

    public void zoomChanged(double zoom) {
        this.refreshCombo();
    }

    public void refreshCombo() {
        if (this.combo != null && !this.combo.isDisposed() && this.combo.isEnabled()) {
            ZoomManager zoomManager = this.getZoomManager();
            if (this.getZoomManager() != null) {
                this.combo.setItems(this.getZoomLevelsAsText(zoomManager));
                if (zoomManager != null) {
                    String zoomText = zoomManager.getZoomAsText();
                    int index = this.combo.indexOf(zoomText);
                    if (index != -1) {
                        this.combo.select(index);
                    } else {
                        this.combo.setText(zoomText);
                    }
                }
            }
        }
    }

    public void setZoomAsText(String zoomText) {
        String parameter = null;
        if (zoomText.equals(ZoomAction.ZOOM_IN)) {
            parameter = "parameter_zoom_in";
        } else if (zoomText.equals(ZoomAction.ZOOM_OUT)) {
            parameter = "parameter_zoom_out";
        } else if (zoomText.equals(ZoomAction.ZOOM_100)) {
            parameter = "parameter_zoom_100";
        } else if (zoomText.equals(ZoomAction.ZOOM_FIT)) {
            parameter = "parameter_zoom_fit";
        } else if (zoomText.equals(ZoomAction.ZOOM_WIDTH)) {
            parameter = "parameter_zoom_width";
        } else if (zoomText.equals(ZoomAction.ZOOM_WIDTH)) {
            parameter = "parameter_zoom_height";
        } else if (zoomText.equals(ZoomAction.ZOOM_SELECTION)) {
            parameter = "parameter_zoom_selection";
        } else {
            parameter = zoomText;
            ZoomManager manager = this.getZoomManager();
            if (manager != null) {
                manager.setZoomAsText(parameter);
            }
        }
        ZoomAction action = new ZoomAction(parameter, this.getSelectedElements());
        if (action.isEnabled()) {
            action.doRun(null);
        } else {
            this.refreshCombo();
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 1 && event.character != '\r') {
            return;
        }
        this.setZoomAsText(this.combo.getText());
    }

    protected List<IGraphicalEditPart> getSelectedElements() {
        ArrayList<IGraphicalEditPart> editparts = new ArrayList<IGraphicalEditPart>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object object : structuredSelection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    editparts.add((IGraphicalEditPart)object);
                }
            } else if (selection instanceof IGraphicalEditPart) {
                editparts.add((IGraphicalEditPart)selection);
            }
        }
        return editparts;
    }

    public void pageChanged(IPage newPage) {
        this.refreshCombo();
        this.removeListeners(this.partService.getActivePart());
        this.addListeners(this.partService.getActivePart());
    }

    protected void removeListeners(IWorkbenchPart part) {
        ISashWindowsContainer windowContainer;
        ZoomManager manager = (ZoomManager)part.getAdapter(ZoomManager.class);
        if (manager != null) {
            manager.removeZoomListener((ZoomListener)this.getInstance());
        }
        if ((windowContainer = (ISashWindowsContainer)part.getAdapter(ISashWindowsContainer.class)) != null) {
            windowContainer.removePageChangedListener((IPageChangedListener)this.getInstance());
        }
        this.refreshStatusCombo(part);
    }

    protected void addListeners(IWorkbenchPart part) {
        ISashWindowsContainer windowContainer;
        ZoomManager manager = (ZoomManager)part.getAdapter(ZoomManager.class);
        if (manager != null) {
            manager.addZoomListener((ZoomListener)this.getInstance());
        }
        if ((windowContainer = (ISashWindowsContainer)part.getAdapter(ISashWindowsContainer.class)) != null) {
            windowContainer.addPageChangedListener((IPageChangedListener)this.getInstance());
        }
        this.refreshStatusCombo(part);
    }

    protected void refreshStatusCombo(IWorkbenchPart part) {
        ZoomManager zoomManager = (ZoomManager)part.getAdapter(ZoomManager.class);
        if (this.combo != null && !this.combo.isDisposed()) {
            if (zoomManager == null) {
                this.combo.setEnabled(false);
            } else {
                this.combo.setEnabled(this.getDiagramEditPart() != null);
                this.refreshCombo();
            }
        }
    }

    protected ZoomToolbar getInstance() {
        return this;
    }

    public class CustomPartListener
    implements IPartListener {
        public void partActivated(IWorkbenchPart part) {
            if (part instanceof CoreMultiDiagramEditor) {
                ZoomToolbar.this.removeListeners(part);
                ZoomToolbar.this.addListeners(part);
            }
            ZoomToolbar.this.refreshStatusCombo(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            ZoomToolbar.this.refreshStatusCombo(part);
        }

        public void partClosed(IWorkbenchPart part) {
            ZoomToolbar.this.refreshStatusCombo(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            boolean cfr_ignored_0 = part instanceof CoreMultiDiagramEditor;
            ZoomToolbar.this.refreshStatusCombo(part);
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof CoreMultiDiagramEditor) {
                ZoomToolbar.this.removeListeners(part);
                ZoomToolbar.this.addListeners(part);
            }
            ZoomToolbar.this.refreshStatusCombo(part);
        }
    }
}

