/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.menu.actions.DistributeAffixedChildNodeLinkAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.ZoomAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeAction {
    public static final String PARAMETER_AUTOSIZE = "parameter_autosize";
    public static final String PARAMETER_BOTH = "parameter_both";
    public static final String PARAMETER_HEIGHT = "parameter_height";
    public static final String PARAMETER_WIDTH = "parameter_width";
    protected int sizeActionType = 0;
    public static final int AUTOSIZE = 0;
    public static final int BOTH = 1;
    public static final int HEIGHT = 2;
    public static final int WIDTH = 3;
    public List<IGraphicalEditPart> selectedElements;

    public SizeAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        this.selectedElements = selectedElements;
        if (PARAMETER_AUTOSIZE.equals(parameter)) {
            this.sizeActionType = 0;
        } else if (PARAMETER_BOTH.equals(parameter)) {
            this.sizeActionType = 1;
        } else if (PARAMETER_HEIGHT.equals(parameter)) {
            this.sizeActionType = 2;
        } else if (PARAMETER_WIDTH.equals(parameter)) {
            this.sizeActionType = 3;
        }
    }

    public Command getCommand() {
        switch (this.sizeActionType) {
            case 0: {
                return this.getAutoSizeCommand();
            }
            case 1: {
                return this.getBothCommand();
            }
            case 2: {
                return this.getHeightCommand();
            }
            case 3: {
                return this.getWidthCommand();
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAutoSizeCommand() {
        if (this.selectedElements.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean foundNonAutosizedPart = false;
        List<IGraphicalEditPart> operationSet = this.selectedElements;
        CompoundCommand command = new CompoundCommand("AutoSize Command");
        for (IGraphicalEditPart editPart : this.selectedElements) {
            int posRightParent = 0;
            int posDownParent = 0;
            double[] zoomMargin = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5, 2.5, 3.5, 4.5, 13.5};
            if (editPart instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Integer containerWidth = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer containerHeight = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                List listept = editPart.getChildren();
                if (containerWidth != -1 || containerHeight != -1 || !listept.isEmpty()) {
                    foundNonAutosizedPart = true;
                    PrecisionRectangle boundsEditPart = LayoutUtils.getAbsolutePosition((EditPart)graphicalEditPart);
                    posRightParent = boundsEditPart.right();
                    posDownParent = boundsEditPart.bottom();
                } else {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            Dimension d = this.findSizeChildren(editPart);
            if (d.height > 0 && d.width > 0) {
                ZoomAction zoomAction = new ZoomAction("Zoom", operationSet);
                ZoomManager zoomMngr = zoomAction.getZoomManager();
                if (zoomMngr == null) {
                    return null;
                }
                double[] zoomLevel = zoomMngr.getZoomLevels();
                double currentZoomLevel = zoomMngr.getZoom();
                int index = this.findIndex(currentZoomLevel, zoomLevel);
                double cstZoom = 0.0;
                if (index != -1) {
                    cstZoom = zoomMargin[index];
                }
                int newW = (int)((double)(posRightParent - d.width) - 6.0 - cstZoom);
                int newH = (int)((double)(posDownParent - d.height) - 6.0 - cstZoom);
                Dimension delta = new Dimension(-newW, -newH);
                ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
                bRequest.setSizeDelta(delta);
                bRequest.setType((Object)"resize");
                Command resizeCommand = editPart.getCommand((Request)bRequest);
                command.add(resizeCommand);
                continue;
            }
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(32);
            bRequest.setType((Object)"autosize");
            Command resizeCommand = editPart.getCommand((Request)bRequest);
            command.add(resizeCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() || !foundNonAutosizedPart ? UnexecutableCommand.INSTANCE : command;
    }

    private Dimension findSizeChildren(IGraphicalEditPart editPart) {
        Dimension sizeChild = new Dimension(0, 0);
        int maxRight = 0;
        int maxDown = 0;
        List contents = editPart.getChildren();
        int index = 0;
        while (index < contents.size()) {
            EditPart editPartCompar = (EditPart)contents.get(index);
            List editPartChild = editPartCompar.getChildren();
            if (!editPartChild.isEmpty()) {
                int index2 = 0;
                while (index2 < editPartChild.size()) {
                    if (editPartChild.get(index2) != null) {
                        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPartChild.get(index2);
                        if (graphicalEditPart.getChildren().size() > 1 && !(editPartChild instanceof DistributeAffixedChildNodeLinkAction.AffixedChildNodeRepresentation)) {
                            PrecisionRectangle rectEditPartChild = LayoutUtils.getAbsolutePosition((EditPart)graphicalEditPart);
                            maxRight = rectEditPartChild.right() > maxRight ? rectEditPartChild.right() : maxRight;
                            maxDown = rectEditPartChild.bottom() > maxDown ? rectEditPartChild.bottom() : maxDown;
                            sizeChild = new Dimension(maxRight, maxDown);
                        } else {
                            return this.findSizeChildren((IGraphicalEditPart)graphicalEditPart);
                        }
                    }
                    ++index2;
                }
            } else {
                sizeChild = new Dimension(0, 0);
            }
            ++index;
        }
        return sizeChild;
    }

    private int findIndex(double currentZoomLevel, double[] zoomLevel) {
        int i = 0;
        while (i <= zoomLevel.length) {
            if (zoomLevel[i] == currentZoomLevel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Command getBothCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(primarySize.width - previousSize.width, primarySize.height - previousSize.height);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(20);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }

    protected Command getHeightCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(0, primarySize.height - previousSize.height);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(4);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }

    protected Command getWidthCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(primarySize.width - previousSize.width, 0);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(16);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }
}

