/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineStyleAction
extends AbstractGraphicalParametricAction {
    public static final String RECTILINEAR = "rectilinear";
    public static final String OBLIQUE = "oblique";
    public static final String TREE = "tree";
    public static final String REMOVE_BENDPOINTS = "remove_benpoints";
    public static final String PROPERTY_ID = "notation.RoutingStyle.routing";
    public static final String PROPERTY_NAME = "Routing";

    public LineStyleAction(String parameter, List<IGraphicalEditPart> selectedEditPart) {
        super(parameter, selectedEditPart);
    }

    @Override
    protected Command getBuildedCommand() {
        CompoundCommand command = new CompoundCommand("Routing command");
        ChangePropertyValueRequest request = new ChangePropertyValueRequest(PROPERTY_NAME, PROPERTY_ID);
        request.setValue((Object)this.getValue());
        for (IGraphicalEditPart current : this.getSelection()) {
            Command cmd;
            if (this.getParameter().equals(REMOVE_BENDPOINTS) && (cmd = current.getCommand((Request)new SetAllBendpointRequest("set_all_connection_bendpoint", new PointList(), null, null))) != null && cmd.canExecute()) {
                command.add(cmd);
            }
            if ((cmd = current.getCommand((Request)request)) == null || !cmd.canExecute()) continue;
            command.add(cmd);
        }
        return command != null && !command.isEmpty() ? command : UnexecutableCommand.INSTANCE;
    }

    private Routing getValue() {
        if (this.getParameter().equals(RECTILINEAR)) {
            return Routing.RECTILINEAR_LITERAL;
        }
        if (this.getParameter().equals(OBLIQUE)) {
            return Routing.MANUAL_LITERAL;
        }
        if (this.getParameter().equals(TREE)) {
            return Routing.TREE_LITERAL;
        }
        if (this.getParameter().equals(REMOVE_BENDPOINTS)) {
            return Routing.MANUAL_LITERAL;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        for (IGraphicalEditPart current : this.getSelection()) {
            if (!(current instanceof ConnectionEditPart)) {
                return false;
            }
            if (!this.getParameter().equals(TREE) || current instanceof ITreeBranchEditPart) continue;
            return false;
        }
        return true;
    }
}

