/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColorAction
extends AbstractGraphicalParametricAction {
    private String propertyID;
    private String propertyName;
    public static final String requestType = "property_change";
    private static final RGB DEFAULT_PREF_COLOR = new RGB(0, 0, 0);
    public static final InventoryColorDescriptor WHITE = new InventoryColorDescriptor(new RGB(255, 255, 255), DiagramUIActionsMessages.ColorPropertyChangeAction_white);
    public static final InventoryColorDescriptor BLACK_ = new InventoryColorDescriptor(new RGB(0, 0, 0), DiagramUIActionsMessages.ColorPropertyChangeAction_black);
    public static final InventoryColorDescriptor LIGHT_GRAY = new InventoryColorDescriptor(new RGB(192, 192, 192), DiagramUIActionsMessages.ColorPropertyChangeAction_lightGray);
    public static final InventoryColorDescriptor GRAY = new InventoryColorDescriptor(new RGB(128, 128, 128), DiagramUIActionsMessages.ColorPropertyChangeAction_gray);
    public static final InventoryColorDescriptor DARK_GRAY = new InventoryColorDescriptor(new RGB(64, 64, 64), DiagramUIActionsMessages.ColorPropertyChangeAction_darkGray);
    public static final InventoryColorDescriptor RED = new InventoryColorDescriptor(new RGB(227, 164, 156), DiagramUIActionsMessages.ColorPropertyChangeAction_red);
    public static final InventoryColorDescriptor GREEN = new InventoryColorDescriptor(new RGB(166, 193, 152), DiagramUIActionsMessages.ColorPropertyChangeAction_green);
    public static final InventoryColorDescriptor BLUE = new InventoryColorDescriptor(new RGB(152, 168, 191), DiagramUIActionsMessages.ColorPropertyChangeAction_blue);
    public static final InventoryColorDescriptor YELLOW = new InventoryColorDescriptor(new RGB(225, 225, 135), DiagramUIActionsMessages.ColorPropertyChangeAction_yellow);
    public static final InventoryColorDescriptor PURPLE = new InventoryColorDescriptor(new RGB(184, 151, 192), DiagramUIActionsMessages.ColorPropertyChangeAction_magenta);
    public static final InventoryColorDescriptor TEAL = new InventoryColorDescriptor(new RGB(155, 199, 204), DiagramUIActionsMessages.ColorPropertyChangeAction_cyan);
    public static final InventoryColorDescriptor PINK = new InventoryColorDescriptor(new RGB(228, 179, 229), DiagramUIActionsMessages.ColorPropertyChangeAction_pink);
    public static final InventoryColorDescriptor ORANGE = new InventoryColorDescriptor(new RGB(237, 201, 122), DiagramUIActionsMessages.ColorPropertyChangeAction_orange);
    public static final String DEFAULT_COLOR = "default_color";
    public static final String MORE_COLORS = "more_colors";

    public AbstractColorAction(String propertyID, String propertyName, String parameter, List<IGraphicalEditPart> selectedEditPart) {
        super(parameter, selectedEditPart);
        this.propertyID = propertyID;
        this.propertyName = propertyName;
    }

    protected int getColor() {
        InventoryColorDescriptor currentColor = null;
        if (AbstractColorAction.WHITE.colorName.equals(this.getParameter())) {
            currentColor = WHITE;
        } else if (AbstractColorAction.BLACK_.colorName.equals(this.getParameter())) {
            currentColor = BLACK_;
        } else if (AbstractColorAction.LIGHT_GRAY.colorName.equals(this.getParameter())) {
            currentColor = LIGHT_GRAY;
        } else if (AbstractColorAction.GRAY.colorName.equals(this.getParameter())) {
            currentColor = GRAY;
        } else if (AbstractColorAction.DARK_GRAY.colorName.equals(this.getParameter())) {
            currentColor = DARK_GRAY;
        } else if (AbstractColorAction.RED.colorName.equals(this.getParameter())) {
            currentColor = RED;
        } else if (AbstractColorAction.GREEN.colorName.equals(this.getParameter())) {
            currentColor = GREEN;
        } else if (AbstractColorAction.BLUE.colorName.equals(this.getParameter())) {
            currentColor = BLUE;
        } else if (AbstractColorAction.YELLOW.colorName.equals(this.getParameter())) {
            currentColor = YELLOW;
        } else if (AbstractColorAction.PURPLE.colorName.equals(this.getParameter())) {
            currentColor = PURPLE;
        } else if (AbstractColorAction.TEAL.colorName.equals(this.getParameter())) {
            currentColor = TEAL;
        } else if (AbstractColorAction.PINK.colorName.equals(this.getParameter())) {
            currentColor = PINK;
        } else if (AbstractColorAction.ORANGE.colorName.equals(this.getParameter())) {
            currentColor = ORANGE;
        } else if (DEFAULT_COLOR.equals(this.getParameter())) {
            currentColor = new InventoryColorDescriptor(this.getDefaultColor(), "");
        }
        return FigureUtilities.RGBToInteger((RGB)currentColor.colorValue);
    }

    protected RGB getDefaultColor() {
        for (EditPart editPart : this.getSelection()) {
            EStructuralFeature feature;
            Object preferredValue;
            if (!(editPart instanceof IGraphicalEditPart) || !((preferredValue = ((IGraphicalEditPart)editPart).getPreferredValue(feature = (EStructuralFeature)PackageUtil.getElement((String)this.getPropertyId()))) instanceof Integer)) continue;
            return FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
        }
        return DEFAULT_PREF_COLOR;
    }

    protected RGB getCurrentColor() {
        for (EditPart editPart : this.getSelection()) {
            EStructuralFeature feature;
            Object preferredValue;
            if (!(editPart instanceof IGraphicalEditPart) || !((preferredValue = ((IGraphicalEditPart)editPart).getStructuralFeatureValue(feature = (EStructuralFeature)PackageUtil.getElement((String)this.getPropertyId()))) instanceof Integer)) continue;
            return FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
        }
        return DEFAULT_PREF_COLOR;
    }

    protected String getPropertyId() {
        return this.propertyID;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected Command getCommand(ChangePropertyValueRequest request) {
        CompoundCommand command = new CompoundCommand();
        for (IGraphicalEditPart current : this.getSelection()) {
            Command tmp = current.getCommand((Request)request);
            if (tmp == null || !tmp.canExecute()) continue;
            command.add(tmp);
        }
        return command;
    }

    @Override
    protected Command getBuildedCommand() {
        if (this.getParameter().equals(MORE_COLORS)) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            CustomColorCommand cmd = new CustomColorCommand(editingDomain, "More Colors Command");
            return new ICommandProxy((ICommand)cmd);
        }
        ChangePropertyValueRequest request = new ChangePropertyValueRequest(this.getPropertyName(), this.getPropertyId());
        request.setType((Object)requestType);
        request.setValue((Object)this.getColor());
        return this.getCommand(request);
    }

    public class CustomColorCommand
    extends AbstractTransactionalCommand {
        public CustomColorCommand(TransactionalEditingDomain domain, String label) {
            super(domain, label, null);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
            WindowUtil.centerDialog((Shell)dialog.getParent(), (Shell)Display.getCurrent().getActiveShell());
            if (AbstractColorAction.this.getCurrentColor() != null) {
                dialog.setRGB(AbstractColorAction.this.getCurrentColor());
            }
            dialog.open();
            ChangePropertyValueRequest request = new ChangePropertyValueRequest(AbstractColorAction.this.getPropertyName(), AbstractColorAction.this.getPropertyId());
            request.setType((Object)AbstractColorAction.requestType);
            RGB rgb = dialog.getRGB();
            request.setValue((Object)FigureUtilities.RGBToInteger((RGB)rgb));
            Command cmd = AbstractColorAction.this.getCommand(request);
            if (cmd.canExecute()) {
                cmd.execute();
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canExecute() {
            ChangePropertyValueRequest request = new ChangePropertyValueRequest(AbstractColorAction.this.getPropertyName(), AbstractColorAction.this.getPropertyId());
            request.setValue((Object)FigureUtilities.RGBToInteger((RGB)AbstractColorAction.BLACK_.colorValue));
            return AbstractColorAction.this.getCommand(request).canExecute();
        }
    }

    public static class InventoryColorDescriptor {
        public RGB colorValue;
        public String colorName;

        public InventoryColorDescriptor(RGB colorValue, String colorName) {
            this.colorValue = colorValue;
            this.colorName = colorName;
        }
    }
}

