/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class OCLVMRootEvaluationEnvironment
extends VMRootEvaluationEnvironment<ExpressionInOCL>
implements IOCLVMEvaluationEnvironment {
    private List<Runnable> myDeferredTasks;
    private boolean myIsDeferedExecution;
    @NonNull
    private Element myCurrentIP;
    @NonNull
    private NamedElement myOperation;
    private final long id;
    @NonNull
    private final Variable pcVariable;

    public OCLVMRootEvaluationEnvironment(@NonNull MetaModelManager metaModelManager, @NonNull IVMModelManager modelManager, @NonNull ExpressionInOCL expressionInOCL, long id) {
        super(metaModelManager, modelManager, (NamedElement)expressionInOCL);
        this.myCurrentIP = expressionInOCL;
        this.myOperation = expressionInOCL;
        this.id = id;
        this.pcVariable = (Variable)DomainUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.pcVariable.setName("$pc");
        String typeName = (String)DomainUtil.nonNullEMF((Object)PivotPackage.Literals.OCL_EXPRESSION.getName());
        this.pcVariable.setType(metaModelManager.getPivotType(typeName));
    }

    @Override
    @NonNull
    public IOCLVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    @NonNull
    public OCLDebugCore getDebugCore() {
        return OCLDebugCore.INSTANCE;
    }

    public int getDepth() {
        return 1;
    }

    public long getID() {
        return this.id;
    }

    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        NamedElement currentModule = this.getDebuggableElement();
        HashMap<String, Resource> result = new HashMap<String, Resource>(2);
        ExpressionInOCL currentExpressionInOCL = (ExpressionInOCL)currentModule;
        IVMModelManager modelManager = this.getModelManager();
        return result;
    }

    @NonNull
    public NamedElement getOperation() {
        return this.myOperation;
    }

    @Override
    @Nullable
    public OCLVMRootEvaluationEnvironment getParentEvaluationEnvironment() {
        return (OCLVMRootEvaluationEnvironment)super.getParentEvaluationEnvironment();
    }

    @NonNull
    public Variable getPCVariable() {
        return this.pcVariable;
    }

    @Override
    @NonNull
    public OCLVMRootEvaluationEnvironment getRootEvaluationEnvironment() {
        return this;
    }

    public boolean isDeferredExecution() {
        return this.myIsDeferedExecution;
    }

    public void processDeferredTasks() {
        if (this.myDeferredTasks != null) {
            try {
                this.myIsDeferedExecution = true;
                ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                for (Runnable task : tasksCopy) {
                    task.run();
                }
            }
            finally {
                this.myIsDeferedExecution = false;
            }
        }
    }

    protected void saveThrownException(@NonNull VMRuntimeException exception) {
    }

    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setException(@NonNull VMRuntimeException exception) {
        this.saveThrownException(exception);
    }

    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", e);
        }
        throw exception;
    }
}

