/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluator;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;

public class OCLVMEvaluator
implements IVMEvaluator {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final ExpressionInOCL expressionInOCL;
    @NonNull
    protected final OCLVMEnvironmentFactory envFactory;
    @NonNull
    protected final OCLVMEnvironment env;
    @NonNull
    protected final IVMModelManager modelManager;
    @Nullable
    private EObject context;
    private boolean suspendOnStartup = false;

    @NonNull
    public static EObject loadContext(@NonNull MetaModelManager metaModelManager, @NonNull URI contextURI) throws IOException {
        EObject eObject = metaModelManager.getExternalResourceSet().getEObject(contextURI, true);
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + contextURI + "'");
        }
        return eObject;
    }

    @NonNull
    public static ExpressionInOCL loadExpression(@NonNull MetaModelManager metaModelManager, @NonNull URI constraintURI, boolean keepDebug) throws IOException {
        EObject eObject = metaModelManager.getASResourceSet().getEObject(constraintURI, true);
        return OCLVMEvaluator.loadExpression(eObject, constraintURI);
    }

    @NonNull
    public static ExpressionInOCL loadExpression(EObject eObject, URI constraintURI) throws IOException {
        ExpressionInOCL expressionInOCL;
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + constraintURI + "'");
        }
        if (!(eObject instanceof Constraint)) {
            throw new IOException("Constraint rather than " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
        }
        OpaqueExpression specification = ((Constraint)eObject).getSpecification();
        if (specification != null && (expressionInOCL = specification.getExpressionInOCL()) != null) {
            return expressionInOCL;
        }
        throw new IOException("Missing OCL expression " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory envFactory, @NonNull URI oclURI, @Nullable URI contextURI) throws IOException {
        this(envFactory, OCLVMEvaluator.loadExpression(envFactory.getMetaModelManager(), oclURI, envFactory.keepDebug()), contextURI != null ? OCLVMEvaluator.loadContext(envFactory.getMetaModelManager(), contextURI) : null);
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory envFactory, @NonNull Constraint constraint, @NonNull EObject context) throws IOException {
        this(envFactory, OCLVMEvaluator.loadExpression((EObject)constraint, EcoreUtil.getURI((EObject)constraint)), context);
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory envFactory, @NonNull ExpressionInOCL expressionInOCL, @Nullable EObject context) throws IOException {
        this.envFactory = envFactory;
        this.metaModelManager = envFactory.getMetaModelManager();
        this.expressionInOCL = expressionInOCL;
        this.env = envFactory.createEnvironment();
        this.modelManager = envFactory.createModelManager(this.metaModelManager);
        this.context = context;
    }

    public void dispose() {
        this.modelManager.dispose();
    }

    public Object execute() {
        ExpressionInOCL expressionInOCL = this.getExpressionInOCL();
        IOCLVMEvaluationEnvironment evalEnv = this.envFactory.createEvaluationEnvironment(this.modelManager, expressionInOCL);
        Variable contextVariable = expressionInOCL.getContextVariable();
        if (contextVariable != null) {
            evalEnv.add((DomainTypedElement)contextVariable, this.context);
        }
        OCLVMRootEvaluationVisitor visitor = this.envFactory.createEvaluationVisitor(this.env, evalEnv);
        visitor.start(this.suspendOnStartup);
        return expressionInOCL.accept((Visitor)visitor);
    }

    @NonNull
    public ExpressionInOCL getDebuggable() {
        return this.getExpressionInOCL();
    }

    @NonNull
    public final OCLVMEnvironment getEnvironment() {
        return this.env;
    }

    @NonNull
    public final OCLVMEnvironmentFactory getEnvironmentFactory() {
        return this.envFactory;
    }

    @NonNull
    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public final IVMModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public ExpressionInOCL getExpressionInOCL() {
        return this.expressionInOCL;
    }

    public void saveModels() {
    }

    public void setSuspendOnStartUp(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }
}

