/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationVisitorDecorator;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;

public abstract class OCLAbstractTracingEvaluationVisitor
extends OCLVMEvaluationVisitorDecorator {
    protected static Logger logger = Logger.getLogger(OCLAbstractTracingEvaluationVisitor.class);
    protected static final String DEFAULT_INDENT = "  ";
    static int VERBOSE_LEVEL_LOW = 0;
    static int VERBOSE_LEVEL_MED = 1;
    static int VERBOSE_LEVEL_HIGH = 2;
    protected static int verboseLevel = VERBOSE_LEVEL_LOW;
    private int indentLevel = 0;

    public OCLAbstractTracingEvaluationVisitor(@NonNull IOCLVMEvaluationVisitor decorated) {
        this(decorated, 0);
        if (logger.getAppender("OCLTrace") == null) {
            FileAppender appender = new FileAppender();
            appender.setFile("OCLTrace.log");
            appender.setName("OCLTrace");
            appender.setLayout((Layout)new PatternLayout("%m%n"));
            appender.setAppend(false);
            appender.activateOptions();
            logger.addAppender((Appender)appender);
        }
        logger.setAdditivity(false);
        logger.setLevel(Level.DEBUG);
    }

    protected OCLAbstractTracingEvaluationVisitor(@NonNull IOCLVMEvaluationVisitor decorated, int indentLevel) {
        super(decorated);
        this.indentLevel = indentLevel;
    }

    public int getVerboseLevel() {
        return verboseLevel;
    }

    public void setVerboseLevel(int verboseLevel) {
        OCLAbstractTracingEvaluationVisitor.verboseLevel = verboseLevel;
    }

    @NonNull
    protected String getIndent() {
        StringBuilder outputBuffer = new StringBuilder(this.indentLevel);
        int i = 0;
        while (i < this.indentLevel) {
            outputBuffer.append(DEFAULT_INDENT);
            ++i;
        }
        String string = outputBuffer.toString();
        return string;
    }

    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getRegexPattern(regex);
    }

    @NonNull
    protected String safePrint(@Nullable Element element) {
        return element != null ? PrettyPrinter.print((Element)element) : "null";
    }

    protected String prettyPrint(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = String.valueOf(this.getIndent()) + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add(String.valueOf(this.getIndent()) + "}");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }

    protected String prettyPrintUnident(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = DEFAULT_INDENT + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add("  }");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }
}

