/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.java.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.papyrus.emf.facet.efacet.EFacetFactory;
import org.eclipse.papyrus.emf.facet.efacet.Parameter;
import org.eclipse.papyrus.emf.facet.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterValueList
extends ArrayList<ParameterValue>
implements IParameterValueList {
    private static final long serialVersionUID = 1L;

    ParameterValueList(ParameterValue ... values) {
        this.addAll(Arrays.asList(values));
    }

    @Override
    public Object getValueByParameterName(String name) {
        ParameterValue param = this.getParameterValueByName(name);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    @Override
    public ParameterValue getParameterValueByName(String name) {
        for (ParameterValue param : this) {
            if (!param.getParameter().getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static ParameterValue createParameterValue(Object value, Parameter parameter) {
        ParameterValue paramValue = EFacetFactory.eINSTANCE.createParameterValue();
        paramValue.setParameter(parameter);
        paramValue.getValue().add(value);
        return paramValue;
    }

    @Override
    public ParameterValue getParameterValue(Parameter parameter) {
        for (ParameterValue paramValue : this) {
            if (paramValue.getParameter() != parameter) continue;
            return paramValue;
        }
        return null;
    }

    @Override
    public Object getValue(Parameter parameter) {
        return this.getParameterValue(parameter).getValue();
    }
}

