/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.tool;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DragSource implements Enumerator
{
    DIAGRAM_LITERAL(1, "DIAGRAM", "DIAGRAM"),
    PROJECT_EXPLORER_LITERAL(2, "PROJECT_EXPLORER", "PROJECT_EXPLORER"),
    BOTH_LITERAL(3, "BOTH", "BOTH");

    public static final int DIAGRAM = 1;
    public static final int PROJECT_EXPLORER = 2;
    public static final int BOTH = 3;
    private static final DragSource[] VALUES_ARRAY;
    public static final List<DragSource> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DragSource[]{DIAGRAM_LITERAL, PROJECT_EXPLORER_LITERAL, BOTH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DragSource get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DragSource result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DragSource getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DragSource result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DragSource get(int value) {
        switch (value) {
            case 1: {
                return DIAGRAM_LITERAL;
            }
            case 2: {
                return PROJECT_EXPLORER_LITERAL;
            }
            case 3: {
                return BOTH_LITERAL;
            }
        }
        return null;
    }

    private DragSource(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

