/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NavigationTargetType implements Enumerator
{
    MODEL_LITERAL(0, "model", "model"),
    FILE_LITERAL(1, "file", "file");

    public static final int MODEL = 0;
    public static final int FILE = 1;
    private static final NavigationTargetType[] VALUES_ARRAY;
    public static final List<NavigationTargetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NavigationTargetType[]{MODEL_LITERAL, FILE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NavigationTargetType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NavigationTargetType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NavigationTargetType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NavigationTargetType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NavigationTargetType get(int value) {
        switch (value) {
            case 0: {
                return MODEL_LITERAL;
            }
            case 1: {
                return FILE_LITERAL;
            }
        }
        return null;
    }

    private NavigationTargetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

