/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.tools.internal.validation.description.constraints.AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;

public class EReferenceCustomizationReferenceNameCommonToAppliedOnConstraint
extends AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint {
    private static final String EREFERENCE_NAME_ON = " EReference name on ";

    public IStatus validate(IValidationContext ctx) {
        IStatus status = null;
        EObject target = ctx.getTarget();
        if (target instanceof EReferenceCustomization) {
            EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)target;
            status = this.validateEReferenceCustomization(eReferenceCustomization, ctx);
        }
        if (status == null) {
            status = ctx.createSuccessStatus();
        }
        return status;
    }

    private IStatus validateEReferenceCustomization(EReferenceCustomization eReferenceCustomization, IValidationContext ctx) {
        IStatus status = null;
        String referenceName = eReferenceCustomization.getReferenceName();
        Iterator appliedOnIterator = eReferenceCustomization.getAppliedOn().iterator();
        if (appliedOnIterator.hasNext()) {
            EObject firstStyleDescriptionElt = (EObject)appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(firstStyleDescriptionElt)) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(firstStyleDescriptionElt)) + " doesn't concerns a style description or a style description element"});
            } else {
                EStructuralFeature eStructuralFeature = firstStyleDescriptionElt.eClass().getEStructuralFeature(referenceName);
                if (eStructuralFeature instanceof EReference) {
                    EClassifier firstEType = eStructuralFeature.getEType();
                    status = this.validateFollowingStyleDescriptionElts(appliedOnIterator, firstStyleDescriptionElt, firstEType, referenceName, ctx);
                } else {
                    status = eStructuralFeature == null ? ctx.createFailureStatus(new Object[]{String.valueOf(referenceName) + EREFERENCE_NAME_ON + this.getPath(firstStyleDescriptionElt) + " doesn't exists"}) : ctx.createFailureStatus(new Object[]{String.valueOf(referenceName) + EREFERENCE_NAME_ON + this.getPath(firstStyleDescriptionElt) + " concerns " + eStructuralFeature + " which is not a EReference"});
                }
            }
        }
        return status;
    }

    private IStatus validateFollowingStyleDescriptionElts(Iterator<EObject> appliedOnIterator, EObject firstStyleDescriptionElt, EClassifier firstEType, String referenceName, IValidationContext ctx) {
        IStatus status = null;
        while (appliedOnIterator.hasNext()) {
            EObject next = appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(next)) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(next)) + " doesn't concerns a style description or a style description element"});
                break;
            }
            EStructuralFeature eStructuralFeature = next.eClass().getEStructuralFeature(referenceName);
            if (eStructuralFeature instanceof EReference) {
                if (firstEType == eStructuralFeature.getEType()) continue;
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(firstStyleDescriptionElt)) + " and " + this.getPath(next) + "have each a EAttribute named " + referenceName + " but with differents types"});
                break;
            }
            if (eStructuralFeature == null) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(referenceName) + EREFERENCE_NAME_ON + this.getPath(next) + " doesn't exists"});
                continue;
            }
            status = ctx.createFailureStatus(new Object[]{String.valueOf(referenceName) + EREFERENCE_NAME_ON + this.getPath(next) + " concerns " + eStructuralFeature + " which is not a EAttribute"});
            break;
        }
        return status;
    }
}

