/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command.semantic;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RemoveDanglingReferences
extends RecordingCommand {
    private final EObject root;

    public RemoveDanglingReferences(TransactionalEditingDomain domain, EObject root) {
        super(domain);
        this.root = root;
    }

    protected void doExecute() {
        RemoveDanglingReferences.removeDanglingReferences(this.root);
    }

    public static void removeDanglingReferences(EObject element) {
        DslCommonPlugin.PROFILER.startWork("Remove dangling reference");
        ModelAccessor accessor = null;
        if (element.eResource() != null && element.eResource().getResourceSet() != null) {
            accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element);
            IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(element.eResource().getResourceSet());
            if (authority != null && !authority.canEditInstance(element)) {
                DslCommonPlugin.PROFILER.stopWork("Remove dangling reference");
                return;
            }
        }
        RemoveDanglingReferences.removeDanglingReferences(accessor, new DanglingReferencesDetector(element.eResource()));
        DslCommonPlugin.PROFILER.stopWork("Remove dangling reference");
    }

    public static void removeDanglingReferences(Resource resource) {
        DslCommonPlugin.PROFILER.startWork("Remove dangling reference");
        if (resource != null && resource.getResourceSet() != null) {
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(resource.getResourceSet());
            RemoveDanglingReferences.removeDanglingReferences(accessor, new DanglingReferencesDetector(resource));
        }
        DslCommonPlugin.PROFILER.stopWork("Remove dangling reference");
    }

    public static void removeDanglingReferences(ResourceSet resourceSet) {
        DslCommonPlugin.PROFILER.startWork("Remove dangling reference");
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(resourceSet);
        RemoveDanglingReferences.removeDanglingReferences(accessor, new DanglingReferencesDetector(resourceSet));
        DslCommonPlugin.PROFILER.stopWork("Remove dangling reference");
    }

    private static void removeDanglingReferences(ModelAccessor accessor, EcoreUtil.CrossReferencer referencer) {
        if (accessor != null) {
            for (Map.Entry entry : referencer.entrySet()) {
                for (EStructuralFeature.Setting value : (Collection)entry.getValue()) {
                    if (!value.getEStructuralFeature().isChangeable() || value.getEStructuralFeature().isTransient() || value.getEObject() == null || !PermissionAuthorityRegistry.getDefault().getPermissionAuthority(value.getEObject()).canEditInstance(value.getEObject())) continue;
                    EcoreUtil.remove((EStructuralFeature.Setting)value, entry.getKey());
                }
            }
        }
    }

    private static class DanglingReferencesDetector
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 616050158241084372L;

        public DanglingReferencesDetector(Resource eResource) {
            super(eResource);
            this.crossReference();
            this.done();
        }

        public DanglingReferencesDetector(ResourceSet resourceSet) {
            super(resourceSet);
            this.crossReference();
            this.done();
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eResource() == null;
        }
    }
}

