/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CommandContext {
    private Stack<EObject> targetStack = new Stack();
    private EObject nextPushEObject;
    private DRepresentation representation;

    public CommandContext(EObject target, DRepresentation representation) {
        this.nextPushEObject = target;
        this.representation = representation;
    }

    public DRepresentation getRepresentation() {
        return this.representation;
    }

    public EObject getCurrentTarget() {
        if (this.targetStack.isEmpty()) {
            return this.nextPushEObject;
        }
        return this.targetStack.peek();
    }

    public EObject getNextPush() {
        return this.nextPushEObject != null ? this.nextPushEObject : this.getCurrentTarget();
    }

    public void clearNextPush() {
        this.nextPushEObject = null;
    }

    public void setNextPushEObject(EObject nextPushEObject) {
        this.nextPushEObject = nextPushEObject;
    }

    public void pushTarget(EObject newTarget) {
        this.targetStack.push(newTarget);
    }

    public EObject popTarget() {
        EObject result = null;
        if (!this.targetStack.isEmpty()) {
            result = this.targetStack.pop();
        }
        return result;
    }

    public static void pushContext(CommandContext context) {
        context.pushTarget(context.getNextPush());
        context.clearNextPush();
    }

    public static void popContext(CommandContext context) {
        context.popTarget();
    }

    public static List<Object> getContextTargets(For forOp, CommandContext context) {
        ArrayList contextTargets = null;
        IInterpreter inter = InterpreterUtil.getInterpreter(context.getCurrentTarget());
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(inter);
        Object result = safeInterpreter.evaluate(context.getCurrentTarget(), forOp, (EStructuralFeature)ToolPackage.eINSTANCE.getFor_Expression());
        contextTargets = result == null ? Lists.newArrayList() : (result instanceof Collection ? Lists.newArrayList((Iterable)((Collection)result)) : Lists.newArrayList((Object[])new Object[]{result}));
        return contextTargets;
    }
}

