/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public class ReloadRepresentationsFileCmd
extends RecordingCommand {
    private Session session;
    private Resource resource;
    private DAnalysis oldAnalysis;

    public ReloadRepresentationsFileCmd(Session session, TransactionalEditingDomain domain, String name, Resource analysisResource) {
        super(domain, name);
        this.session = session;
        this.resource = analysisResource;
        this.oldAnalysis = (DAnalysis)analysisResource.getContents().get(0);
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected void doExecute() {
        DAnalysisSession analysisSession = this.getAnalysisSession();
        DAnalysisSessionEObject analysisSessionEObject = this.getAnalysisSessionEObject();
        this.removeOldAnalysis(analysisSession, analysisSessionEObject);
        this.addNewAnalysis(analysisSession, analysisSessionEObject);
        this.session = null;
        this.resource = null;
        this.oldAnalysis = null;
    }

    private void addNewAnalysis(DAnalysisSession analysisSession, DAnalysisSessionEObject analysisSessionEObject) {
        DAnalysis analysis;
        if (this.resource != null && (analysis = (DAnalysis)this.resource.getContents().get(0)) != null) {
            if (analysisSessionEObject != null) {
                analysisSessionEObject.getAnalyses().add((Object)analysis);
            }
            if (analysisSession != null) {
                analysisSession.addAdaptersOnAnalysis(analysis);
            }
        }
    }

    private void removeOldAnalysis(DAnalysisSession analysisSession, DAnalysisSessionEObject analysisSessionEObject) {
        if (this.oldAnalysis != null) {
            if (analysisSessionEObject != null) {
                analysisSessionEObject.getAnalyses().remove((Object)this.oldAnalysis);
            }
            if (analysisSession != null) {
                analysisSession.removeAdaptersOnAnalysis(this.oldAnalysis);
            }
        }
    }

    private DAnalysisSessionEObject getAnalysisSessionEObject() {
        DAnalysisSessionEObject analysisSessionEObject = null;
        if (this.session instanceof DAnalysisSessionEObject) {
            analysisSessionEObject = (DAnalysisSessionEObject)((Object)this.session);
        }
        return analysisSessionEObject;
    }

    private DAnalysisSession getAnalysisSession() {
        DAnalysisSession analysisSession = null;
        if (this.session instanceof DAnalysisSession) {
            analysisSession = (DAnalysisSession)this.session;
        }
        return analysisSession;
    }
}

