/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RepresentationNameListener
extends ResourceSetListenerImpl {
    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            Option<Session> session;
            if (!this.isRepresentationNameChange(notif) || !(session = this.getSessionFromRepresentation((DRepresentation)notif.getNotifier())).some()) continue;
            SessionManager.INSTANCE.notifyRepresentationRenamed((Session)session.get());
        }
    }

    private Option<Session> getSessionFromRepresentation(DRepresentation representation) {
        Session session;
        EObject semanticElement = null;
        if (representation instanceof DSemanticDecorator) {
            semanticElement = ((DSemanticDecorator)((Object)representation)).getTarget();
        }
        if (semanticElement != null && (session = SessionManager.INSTANCE.getSession(semanticElement)) != null) {
            return Options.newSome((Object)session);
        }
        return Options.newNone();
    }

    private boolean isRepresentationNameChange(Notification notif) {
        return notif.getNotifier() instanceof DRepresentation && notif.getFeatureID(DRepresentation.class) == 4;
    }
}

