/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.AbstractSavingPolicy;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;

public class IsModifiedSavingPolicy
extends AbstractSavingPolicy {
    private Predicate<Resource> isModified = new Predicate<Resource>(){

        public boolean apply(Resource resource) {
            return resource.isLoaded() && resource.isModified();
        }
    };
    private Predicate<Resource> underlyingFileIsDeletedOrConflicting = new Predicate<Resource>(){

        public boolean apply(Resource resource) {
            ResourceSetSync.ResourceStatus resourceStatus = ResourceSetSync.getStatus((Resource)resource);
            return resourceStatus == ResourceSetSync.ResourceStatus.DELETED || resourceStatus == ResourceSetSync.ResourceStatus.CONFLICTING_DELETED;
        }
    };

    public IsModifiedSavingPolicy(TransactionalEditingDomain domain) {
        super(domain);
    }

    @Override
    public Collection<Resource> computeResourcesToSave(Set<Resource> scope, Map<?, ?> options, IProgressMonitor monitor) {
        LinkedHashSet resourcesToSave = Sets.newLinkedHashSet();
        Iterables.addAll((Collection)resourcesToSave, (Iterable)Iterables.filter(scope, this.isModified));
        Iterables.addAll((Collection)resourcesToSave, (Iterable)Iterables.filter(scope, (Predicate)new ResourceHasReferenceTo((Predicate<Resource>)Predicates.and((Predicate)Predicates.in(scope), this.isModified))));
        Iterables.addAll((Collection)resourcesToSave, (Iterable)Iterables.filter(scope, this.underlyingFileIsDeletedOrConflicting));
        return ImmutableSet.copyOf((Collection)resourcesToSave);
    }

    private static class EObjectHasReferencesTo
    implements Predicate<EObject> {
        private final Predicate<Resource> modifiedResources;

        public EObjectHasReferencesTo(Predicate<Resource> logicallyModifieds) {
            this.modifiedResources = logicallyModifieds;
        }

        public boolean apply(EObject source) {
            for (EReference ref : source.eClass().getEAllReferences()) {
                if (ref.isTransient()) continue;
                for (EObject target : this.getReferencedEObjects(source, ref)) {
                    if (target.eIsProxy() || !this.modifiedResources.apply((Object)target.eResource())) continue;
                    return true;
                }
            }
            return false;
        }

        protected Collection<EObject> getReferencedEObjects(EObject source, EReference ref) {
            Object val = source.eGet((EStructuralFeature)ref, false);
            Collection<Object> values = Collections.emptySet();
            if (ref.isMany() && val instanceof Collection) {
                values = (Collection)val;
            } else if (val instanceof EObject) {
                values = Collections.singleton((EObject)val);
            }
            return values;
        }
    }

    private static class ResourceHasReferenceTo
    implements Predicate<Resource> {
        private final Predicate<Resource> modifiedResources;

        public ResourceHasReferenceTo(Predicate<Resource> logicallyModifieds) {
            this.modifiedResources = logicallyModifieds;
        }

        public boolean apply(Resource resource) {
            EObjectHasReferencesTo hasOuterRef = new EObjectHasReferencesTo(this.modifiedResources);
            return Iterators.any((Iterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)false), (Predicate)hasOuterRef);
        }
    }
}

