/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.parser;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.sirius.business.internal.resource.parser.XMIModelFileSaxParserNormalAbortException;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIModelFileHandler
extends DefaultHandler {
    private boolean firstElementRead;
    private boolean canLoad;

    public boolean isLoadable() {
        return this.canLoad;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.firstElementRead) {
            throw new XMIModelFileSaxParserNormalAbortException("All needed informations have been reached. Stop the parsing.");
        }
        this.firstElementRead = true;
        HashSet nsValues = Sets.newHashSet();
        boolean isXMI = this.lookForXMIAndCollectNamespaces(attributes, nsValues);
        this.canLoad = isXMI && this.allNamespacesAreKnownMetaModels(nsValues);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.firstElementRead) {
            throw new XMIModelFileSaxParserNormalAbortException("All needed informations have been reached. Stop the parsing.");
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        throw new XMIModelFileSaxParserNormalAbortException("We try to access external elements. Stop the parsing.");
    }

    private boolean lookForXMIAndCollectNamespaces(Attributes attributes, Set<String> nsValues) {
        boolean isXMI = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String value;
            String attributeName = attributes.getQName(i);
            if (attributeName.startsWith("xmlns") && !StringUtil.isEmpty((String)(value = attributes.getValue(i)))) {
                boolean xmiNamespace = XMLContentHandlerImpl.XMI.isXMINamespace((String)value);
                boolean bl = isXMI = isXMI || xmiNamespace;
                if (!value.startsWith("http://www.w3.org/2001/XMLSchema") && !xmiNamespace) {
                    nsValues.add(value);
                }
            }
            ++i;
        }
        return isXMI;
    }

    private boolean allNamespacesAreKnownMetaModels(Set<String> nsValues) {
        boolean allKnwonMM = true;
        if (!nsValues.isEmpty()) {
            EPackage.Registry workspaceEPackageRegistry = DslCommonPlugin.getDefault().getWorkspaceEPackageRegistry();
            for (String val : nsValues) {
                boolean bl = allKnwonMM = allKnwonMM && workspaceEPackageRegistry.get((Object)val) != null;
            }
        }
        return allKnwonMM;
    }
}

