/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.AbstractViewpointResourceMonitor;

public class WorkspaceMonitor
extends AbstractViewpointResourceMonitor {
    private final IWorkspace workspace;
    private final IResourceChangeListener workspaceChangeListener = new WorkspaceListener();
    private final ViewpointResourceHandler resourceHandler;

    public WorkspaceMonitor(IWorkspace workspace, ViewpointResourceHandler resourceHandler) {
        this.workspace = (IWorkspace)Preconditions.checkNotNull((Object)workspace);
        this.resourceHandler = (ViewpointResourceHandler)Preconditions.checkNotNull((Object)resourceHandler);
    }

    @Override
    public void start() {
        this.running = true;
        this.detectExistingVSMs();
        this.workspace.addResourceChangeListener(this.workspaceChangeListener, 1);
    }

    @Override
    public void stop() {
        this.workspace.removeResourceChangeListener(this.workspaceChangeListener);
        this.running = false;
    }

    private void detectExistingVSMs() {
        try {
            VSMProxyVisitor detector = new VSMProxyVisitor();
            this.workspace.getRoot().accept((IResourceProxyVisitor)detector, 0);
            this.notifyResourcesEvents(Collections.<URI>emptySet(), detector.detected, Collections.<URI>emptySet());
        }
        catch (CoreException e) {
            this.reportCoreException(e);
        }
    }

    private void reportCoreException(CoreException e) {
        throw new RuntimeException(e);
    }

    private boolean isVSM(IResource res) {
        if (res.getType() == 1) {
            URI uri = URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true);
            return this.resourceHandler.handles(uri);
        }
        return false;
    }

    private final class VSMDeltaVisitor
    implements IResourceDeltaVisitor {
        Set<URI> added = Sets.newLinkedHashSet();
        Set<URI> removed = Sets.newLinkedHashSet();
        Set<URI> changed = Sets.newLinkedHashSet();

        private VSMDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (WorkspaceMonitor.this.isVSM(res)) {
                IPath fullPath = delta.getFullPath();
                URI uri = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)true);
                switch (delta.getKind()) {
                    case 1: {
                        this.added.add(uri);
                        break;
                    }
                    case 2: {
                        this.removed.add(uri);
                        break;
                    }
                    case 4: {
                        if (delta.getMarkerDeltas().length != 0) break;
                        this.changed.add(uri);
                        break;
                    }
                }
                return false;
            }
            return true;
        }
    }

    private final class VSMProxyVisitor
    implements IResourceProxyVisitor {
        Set<URI> detected = Sets.newLinkedHashSet();

        private VSMProxyVisitor() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IResource res;
            if (proxy.isAccessible() && WorkspaceMonitor.this.isVSM(res = proxy.requestResource())) {
                this.detected.add(URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true));
                return false;
            }
            return true;
        }
    }

    private final class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    VSMDeltaVisitor visitor = new VSMDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                    WorkspaceMonitor.this.notifyResourcesEvents(visitor.removed, visitor.added, visitor.changed);
                }
                catch (CoreException e) {
                    WorkspaceMonitor.this.reportCoreException(e);
                }
            }
        }
    }
}

