/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceListener;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceMonitor;

public abstract class AbstractViewpointResourceMonitor
implements ViewpointResourceMonitor {
    protected ViewpointResourceListener listener;
    protected volatile boolean running;

    @Override
    public synchronized void setListener(ViewpointResourceListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected synchronized void notifyResourcesEvents(Set<URI> removed, Set<URI> added, Set<URI> changed) {
        Preconditions.checkNotNull(removed);
        Preconditions.checkNotNull(added);
        Preconditions.checkNotNull(changed);
        assert (Sets.intersection(removed, added).isEmpty() && Sets.intersection(added, changed).isEmpty() && Sets.intersection(changed, removed).isEmpty());
        if (!(this.listener == null || removed.isEmpty() && added.isEmpty() && changed.isEmpty())) {
            this.listener.resourceEvent(this, removed, added, changed);
        }
    }
}

