/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryFilter;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryListener2;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.query.ViewpointURIQuery;
import org.eclipse.sirius.business.internal.movida.ViewpointDependenciesTracker;
import org.eclipse.sirius.business.internal.movida.ViewpointResourceOperations;
import org.eclipse.sirius.business.internal.movida.registry.CompositeViewpointResourceHandler;
import org.eclipse.sirius.business.internal.movida.registry.DefaultViewpointResourceHandler;
import org.eclipse.sirius.business.internal.movida.registry.Entry;
import org.eclipse.sirius.business.internal.movida.registry.MaskingPolicy;
import org.eclipse.sirius.business.internal.movida.registry.StatusUpdater;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistryListener;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRelations;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.CompositeResourceMonitor;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.LegacyPluginMonitor;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.PluginMonitor;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceListener;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceMonitor;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.WorkspaceMonitor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.base.relations.Relation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Component;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointRegistry
extends org.eclipse.sirius.business.api.componentization.ViewpointRegistry
implements ViewpointResourceListener {
    private static final String UNABLE_TO_LOAD_THIS_FILE = "The viewpoint registry was not able to load this file ";
    private static final String VIEWPOINT_RESOURCE_TYPE_EXTENSION_POINT = "org.eclipse.sirius.viewpointResourceType";
    private final CompositeResourceMonitor monitors = new CompositeResourceMonitor();
    private final ResourceSetImpl resourceSet = new ResourceSetImpl();
    private final CompositeViewpointResourceHandler compositeResourceHandler = new CompositeViewpointResourceHandler();
    private final MaskingPolicy maskingPolicy = new MaskingPolicy(this.monitors, this.compositeResourceHandler);
    private final Map<URI, Entry> entries = Maps.newHashMap();
    private final CopyOnWriteArrayList<ViewpointRegistryListener> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ViewpointRegistryListener2> legacyListeners = new CopyOnWriteArrayList();
    private RegistryChange currentChange;
    private ECrossReferenceAdapter crossReferencer = new ECrossReferenceAdapter();
    private LegacyPluginMonitor legacyMonitor;
    private CopyOnWriteArrayList<ViewpointRegistryFilter> filters = new CopyOnWriteArrayList();

    public ViewpointRegistry() {
        this.resourceSet.setURIConverter((URIConverter)new ViewpointURIConverter(this));
        this.resourceSet.eAdapters().add((Object)this.crossReferencer);
        this.monitors.setListener(this);
        this.legacyMonitor = new LegacyPluginMonitor(this);
        this.configureResourceHandler();
        this.monitors.addMonitor("Legacy Plugins", this.legacyMonitor);
        this.monitors.addMonitor("Plugins", new PluginMonitor(Platform.getExtensionRegistry(), this.compositeResourceHandler));
        this.monitors.addMonitor("Workspace", new WorkspaceMonitor(ResourcesPlugin.getWorkspace(), this.compositeResourceHandler));
    }

    private void configureResourceHandler() {
        IConfigurationElement[] elements;
        this.compositeResourceHandler.addResourceType(new DefaultViewpointResourceHandler());
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(VIEWPOINT_RESOURCE_TYPE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("handler".equals(element.getName())) {
                try {
                    Object handler = element.createExecutableExtension("class");
                    if (handler instanceof ViewpointResourceHandler) {
                        this.compositeResourceHandler.addResourceType((ViewpointResourceHandler)handler);
                    }
                }
                catch (CoreException coreException) {
                    this.reportWarning("Could not instantiate contributed Sirius Resource Type handler " + element.getAttribute("class"));
                }
            }
            ++n2;
        }
    }

    private void reportWarning(String message) {
        SiriusPlugin.getDefault().warning(message, null);
    }

    public void start() {
        if (!this.isRunning()) {
            this.monitors.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.monitors.stop();
            this.entries.clear();
            this.resourceSet.getResources().clear();
            this.resourceSet.eAdapters().clear();
        }
    }

    public boolean isRunning() {
        return this.monitors.isRunning();
    }

    public void addListener(ViewpointRegistryListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(ViewpointRegistryListener listener) {
        this.listeners.remove(listener);
    }

    private void fireRegistryChange(RegistryChange change) {
        ImmutableSet removed = ImmutableSet.copyOf(change.removed);
        ImmutableSet added = ImmutableSet.copyOf(change.added);
        ImmutableSet changed = ImmutableSet.copyOf(change.changed);
        for (ViewpointRegistryListener listener : this.listeners) {
            listener.registryChanged(this, (Set<URI>)removed, (Set<URI>)added, (Set<URI>)changed);
        }
        for (ViewpointRegistryListener2 legacyListener : this.legacyListeners) {
            legacyListener.modelerDesciptionFilesLoaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceEvent(ViewpointResourceMonitor origin, Set<URI> removed, Set<URI> added, Set<URI> changed) {
        ViewpointRegistry viewpointRegistry = this;
        synchronized (viewpointRegistry) {
            this.currentChange = new RegistryChange();
            for (URI r : removed) {
                this.resourceRemoved(r);
            }
            for (URI a : added) {
                this.resourceAdded(a);
            }
            for (URI c : changed) {
                this.resourceChanged(c);
            }
            this.currentChange.normalize();
            new StatusUpdater(this.resourceSet, this.entries, this.currentChange).updateStatus();
            this.fireRegistryChange(this.currentChange);
            this.currentChange = null;
            DialectManager.INSTANCE.invalidateMappingCache();
        }
    }

    public ViewpointResourceHandler getSiriusResourceHandler() {
        return this.compositeResourceHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Option<Entry> getEntry(URI viewpointURI) {
        Preconditions.checkNotNull((Object)viewpointURI);
        Preconditions.checkArgument((boolean)ViewpointURIQuery.isValidViewpointURI(viewpointURI));
        ViewpointRegistry viewpointRegistry = this;
        synchronized (viewpointRegistry) {
            Entry entry = this.entries.get(viewpointURI);
            return Options.fromNullable((Object)entry);
        }
    }

    private void resourceAdded(URI uri) {
        Option<Resource> vsm = this.load(uri);
        if (vsm.some()) {
            MaskingPolicy.MaskingChange change = this.maskingPolicy.resourceLoaded((Resource)vsm.get());
            this.updateEntries(change);
            this.updateResourcesStatus(change);
        }
    }

    private void resourceRemoved(URI uri) {
        Option<Resource> res = this.findResource(uri);
        if (res.some()) {
            MaskingPolicy.MaskingChange change = this.maskingPolicy.aboutToUnload((Resource)res.get());
            this.updateEntries(change);
            this.updateResourcesStatus(change);
            this.resourceSet.getResources().remove(res.get());
        } else {
            this.warning(MessageFormat.format("Inconsistent notification: can not remove unknown resource at {0}", uri), null);
        }
    }

    private void resourceChanged(URI uri) {
        this.resourceRemoved(uri);
        this.resourceAdded(uri);
    }

    private void updateResourcesStatus(MaskingPolicy.MaskingChange change) {
        for (Resource masked : change.masked) {
            new ViewpointResourceOperations(masked).unloadAndResetProxyURIs();
        }
        for (Resource unmasked : change.unmasked) {
            this.ensureLoaded(unmasked);
        }
    }

    private void updateEntries(MaskingPolicy.MaskingChange change) {
        for (Resource masked : change.masked) {
            this.unregisterViewpointsFrom(masked);
        }
        for (Resource unmasked : change.unmasked) {
            this.registerViewpointsFrom(unmasked);
        }
    }

    private Option<Resource> findResource(final URI uri) {
        try {
            Resource match = (Resource)Iterables.find((Iterable)this.resourceSet.getResources(), (Predicate)new Predicate<Resource>(){

                public boolean apply(Resource input) {
                    return input.getURI().equals(uri);
                }
            });
            return match != null ? Options.newSome((Object)match) : Options.newNone();
        }
        catch (NoSuchElementException noSuchElementException) {
            return Options.newNone();
        }
    }

    private Option<Resource> load(URI uri) {
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkArgument((boolean)uri.isPlatform(), (Object)("Unsupported URI scheme: " + uri));
        try {
            Option result;
            Resource vsm = this.resourceSet.getResource(uri, true);
            if (vsm == null) {
                this.warning(MessageFormat.format("Unable to load the VSM at {0}", uri), null);
                result = Options.newNone();
            } else if (!vsm.getErrors().isEmpty()) {
                this.warning(MessageFormat.format("Errors occured while trying to load the VSM at {0}", uri), null);
                vsm.unload();
                this.resourceSet.getResources().remove((Object)vsm);
                result = Options.newNone();
            } else {
                result = Options.newSome((Object)vsm);
            }
            return result;
        }
        catch (WrappedException e) {
            SiriusPlugin.getDefault().warning(UNABLE_TO_LOAD_THIS_FILE + uri, e.exception());
        }
        catch (RuntimeException e) {
            SiriusPlugin.getDefault().warning(UNABLE_TO_LOAD_THIS_FILE + uri, e);
        }
        return Options.newNone();
    }

    private void ensureLoaded(Resource unmasked) {
        if (!unmasked.isLoaded()) {
            try {
                unmasked.load(Collections.emptyMap());
            }
            catch (IOException e) {
                this.warning(MessageFormat.format("Unable to load the VSM at {0}", unmasked.getURI()), e);
            }
        }
    }

    private Set<Entry> registerViewpointsFrom(Resource vsm) {
        Set<Entry> newEntries = this.createNewEntries(vsm);
        for (Entry entry : newEntries) {
            Preconditions.checkState((!this.entries.containsKey(entry.getLogicalURI()) ? 1 : 0) != 0);
            this.addEntry(entry);
        }
        return newEntries;
    }

    private Set<Entry> unregisterViewpointsFrom(Resource vsm) {
        HashSet unregistered = Sets.newHashSet();
        for (Entry entry : Lists.newArrayList(this.entries.values())) {
            if (!Objects.equal((Object)entry.getResource(), (Object)vsm)) continue;
            this.removeEntry(entry);
            unregistered.add(entry);
        }
        return unregistered;
    }

    private Entry addEntry(Entry entry) {
        Entry result = this.entries.put(entry.getLogicalURI(), entry);
        this.currentChange.added.add(entry.getLogicalURI());
        return result;
    }

    private void removeEntry(Entry entry) {
        this.entries.remove(entry.getLogicalURI());
        this.currentChange.removed.add(entry.getLogicalURI());
    }

    private Set<Entry> createNewEntries(Resource vsm) {
        this.ensureLoaded(vsm);
        HashSet newEntries = Sets.newHashSet();
        for (Viewpoint viewpoint : this.compositeResourceHandler.collectViewpointDefinitions(vsm)) {
            newEntries.add(new Entry(viewpoint));
        }
        return newEntries;
    }

    private void warning(String message, Throwable th) {
        if (th == null) {
            System.out.println("WARN: " + message);
        } else {
            System.out.println("WARN: " + message + "(" + th.toString() + ")");
        }
        System.out.flush();
    }

    public void dumpStatus(StringBuilder out) {
        out.append("Entries:\n");
        for (URI uri : Ordering.usingToString().sortedCopy(this.entries.keySet())) {
            Entry entry = this.entries.get(uri);
            out.append(" - ").append(uri).append(" => ").append(entry.getResource().getURI()).append("\n");
        }
        out.append("\n");
        out.append("ResourceSet:\n");
        for (Resource res : this.resourceSet.getResources()) {
            out.append(" - ").append(res.getURI()).append(" [loaded=").append(String.valueOf(res.isLoaded())).append("]").append("\n");
            out.append("\tResolved dependencies:\n\t\t").append(Joiner.on((String)"\n\t\t").join(new ResourceQuery(res).getResolvedDependencies())).append("\n");
            out.append("\tUnresolved dependencies:\n\t\t").append(Joiner.on((String)"\n\t\t").join(new ResourceQuery(res).getUnresolvedDependencies())).append("\n");
        }
        out.append("\n");
        out.append("Transitive dependencies:\n");
        ViewpointDependenciesTracker tracker = new ViewpointDependenciesTracker(this);
        for (URI uri : Sets.newHashSet(this.entries.keySet())) {
            if (!uri.toString().startsWith("viewpoint:/t/")) continue;
            tracker.add(uri);
        }
        for (URI uri : tracker.getTrackedElements()) {
            out.append(uri).append("\n");
            out.append(" - direct:  ").append(Joiner.on((String)", ").join((Iterable)tracker.getDependencies(uri))).append("\n");
            out.append(" - reverse: ").append(Joiner.on((String)", ").join((Iterable)tracker.getReverseDependencies(uri))).append("\n");
            out.append("\n");
        }
        tracker.dispose();
    }

    public ViewpointRelations getRelations() {
        return new ViewpointRelations(this);
    }

    public ViewpointDependenciesTracker createTrackerFor(Relation<URI> vpRelation) {
        ViewpointDependenciesTracker tracker = new ViewpointDependenciesTracker(this, vpRelation);
        for (URI uri : this.entries.keySet()) {
            tracker.add(uri);
        }
        return tracker;
    }

    public Option<URI> getProvider(URI logicalURI) {
        Option<Entry> entry = this.getEntry(logicalURI);
        if (entry.some()) {
            return Options.newSome((Object)((Entry)entry.get()).getResource().getURI());
        }
        return Options.newNone();
    }

    @Override
    public synchronized Set<Viewpoint> getViewpoints() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.entries.values(), (Function)new Function<Entry, Viewpoint>(){

            public Viewpoint apply(Entry from) {
                return from.getSirius();
            }
        }));
    }

    @Override
    public boolean isFromPlugin(Viewpoint viewpoint) {
        if (viewpoint != null && viewpoint.eResource() != null) {
            URI uri = viewpoint.eResource().getURI();
            return uri.isPlatformPlugin();
        }
        return false;
    }

    @Override
    public EObject find(EObject eObject) {
        EObject eObj = null;
        try {
            eObj = this.resourceSet.getEObject(EcoreUtil.getURI((EObject)eObject), true);
        }
        catch (WrappedException wrappedException) {}
        return eObj != null ? eObj : eObject;
    }

    @Override
    public ECrossReferenceAdapter getCrossReferencer() {
        return this.crossReferencer;
    }

    @Override
    public Viewpoint getViewpoint(RepresentationDescription description) {
        return new RepresentationDescriptionQuery(description).getParentViewpoint();
    }

    @Override
    public Viewpoint getViewpoint(URI viewpointUri) {
        if (this.entries.containsKey(viewpointUri)) {
            return this.entries.get(viewpointUri).getSirius();
        }
        return null;
    }

    @Override
    public boolean addListener(ViewpointRegistryListener2 listener) {
        return this.legacyListeners.addIfAbsent(listener);
    }

    @Override
    public boolean removeListener(ViewpointRegistryListener2 listener) {
        return this.legacyListeners.remove(listener);
    }

    @Override
    public Set<Viewpoint> registerFromPlugin(String modelerModelResourcePath) {
        try {
            return this.legacyMonitor.registerFromPlugin(modelerModelResourcePath);
        }
        catch (WrappedException e) {
            SiriusPlugin.getDefault().warning(UNABLE_TO_LOAD_THIS_FILE + modelerModelResourcePath, e.exception());
        }
        catch (RuntimeException e) {
            SiriusPlugin.getDefault().warning(UNABLE_TO_LOAD_THIS_FILE + modelerModelResourcePath, e);
        }
        return Collections.emptySet();
    }

    @Override
    public void disposeFromPlugin(Viewpoint viewpoint) {
        this.legacyMonitor.disposeFromPlugin(viewpoint);
    }

    @Override
    public boolean addFilter(ViewpointRegistryFilter filter) {
        return this.filters.add(filter);
    }

    @Override
    public boolean removeFilter(ViewpointRegistryFilter filter) {
        return this.filters.remove(filter);
    }

    @Override
    public void removeFilter(String id) {
        Iterator<ViewpointRegistryFilter> iter = this.filters.iterator();
        while (iter.hasNext()) {
            ViewpointRegistryFilter filter = iter.next();
            if (!Objects.equal((Object)id, (Object)filter.getId())) continue;
            iter.remove();
        }
    }

    @Override
    public <T extends Component> void registerFromWorkspace(Set<T> components) {
    }

    @Override
    public void init(int size) {
        this.start();
    }

    @Override
    public void dispose() {
        if (this.isRunning()) {
            this.stop();
        }
    }

    static class RegistryChange {
        Set<URI> removed = Sets.newHashSet();
        Set<URI> added = Sets.newHashSet();
        Set<URI> changed = Sets.newHashSet();

        RegistryChange() {
        }

        public RegistryChange normalize() {
            this.changed.addAll((Collection<URI>)Sets.intersection(this.added, this.removed));
            this.added.removeAll(this.changed);
            this.removed.removeAll(this.changed);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Removed:\n\t").append(Joiner.on((String)"\n\t").join(this.removed)).append("\n");
            sb.append("Added:\n\t").append(Joiner.on((String)"\n\t").join(this.added)).append("\n");
            sb.append("Changed:\n\t").append(Joiner.on((String)"\n\t").join(this.changed)).append("\n");
            return sb.toString();
        }
    }
}

