/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskExecutor;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.DeleteDDiagramElementTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.listener.ChangeListenerFactory;
import org.eclipse.sirius.tools.api.command.listener.IChangeListener;
import org.eclipse.sirius.tools.api.command.listener.TriggerOperation;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction2;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class ExternalJavaActionTask
extends AbstractOperationTask {
    private final ExternalJavaAction externalJavaAction;
    private final IExternalJavaAction javaAction;
    private final Collection<EObject> selections = new ArrayList<EObject>();
    private final ModelAccessor accessor;
    private final TaskHelper taskHelper;
    private final Session session;

    public ExternalJavaActionTask(CommandContext context, ModelAccessor extPackage, ExternalJavaAction op, Session session, UICallBack uiCallback) {
        super(context, extPackage, session.getInterpreter());
        this.externalJavaAction = op;
        this.accessor = extPackage;
        this.session = session;
        if (context.getCurrentTarget() != null) {
            this.selections.add(context.getCurrentTarget());
        }
        this.javaAction = ExternalJavaActionProvider.INSTANCE.getJavaActionById(this.externalJavaAction.getId());
        this.taskHelper = new TaskHelper(this.accessor, uiCallback);
    }

    @Override
    public void execute() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter);
        if (this.taskHelper.checkPrecondition(this.context.getCurrentTarget(), this.externalJavaAction)) {
            for (ExternalJavaActionParameter parameter : this.externalJavaAction.getParameters()) {
                Object value = safeInterpreter.evaluate(this.context.getCurrentTarget(), parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
                parameters.put(parameter.getName(), value);
            }
            IChangeListener listener = null;
            try {
                if (!(this.javaAction instanceof IExternalJavaAction2) || ((IExternalJavaAction2)this.javaAction).mayDeleteElements()) {
                    listener = ChangeListenerFactory.INSTANCE.getNewChangeListener();
                    this.startListenSemanticChange(listener);
                }
                this.javaAction.execute(this.selections, parameters);
            }
            finally {
                if (listener != null) {
                    this.stopListenSemanticChange(listener);
                }
            }
        }
    }

    private void startListenSemanticChange(IChangeListener listener) {
        listener.setTriggerOperation(new DeleteDiagramElementsTriggerOperation());
        for (Resource resource : this.session.getTransactionalEditingDomain().getResourceSet().getResources()) {
            ResourceQuery resourceQuery = new ResourceQuery(resource);
            if (resourceQuery.isRepresentationsResource() || resourceQuery.isModelerResource()) continue;
            resource.eAdapters().add((Object)listener);
        }
        listener.activate();
    }

    private void stopListenSemanticChange(IChangeListener listener) {
        listener.launchTriggerOperation();
        for (Resource resource : this.session.getTransactionalEditingDomain().getResourceSet().getResources()) {
            ResourceQuery resourceQuery = new ResourceQuery(resource);
            if (resourceQuery.isRepresentationsResource() || resourceQuery.isModelerResource()) continue;
            resource.eAdapters().remove((Object)listener);
        }
        listener.deactivate();
    }

    @Override
    public String getLabel() {
        return "Execute external java action \"" + this.externalJavaAction.getName() + "\"";
    }

    @Override
    public boolean canExecute() {
        return this.javaAction != null && this.javaAction.canExecute(this.selections);
    }

    private class DeleteDiagramElementsTriggerOperation
    implements TriggerOperation {
        private DeleteDiagramElementsTriggerOperation() {
        }

        @Override
        public void run(Collection<Object> createdElements, Collection<Object> modifiedElements, Collection<Object> deletedElements) {
            if (!deletedElements.isEmpty()) {
                Set<EObject> allDeletedElements = this.elementsAndChildren(deletedElements);
                Set<DSemanticDecorator> decoratorsToDelete = this.getDecoratorsInRepresentationToDelete(allDeletedElements);
                decoratorsToDelete.addAll(this.getRepresentationsToDelete(allDeletedElements));
                decoratorsToDelete.addAll(this.getOrphanedDecorators());
                this.getCommand(decoratorsToDelete);
            }
        }

        private Set<DSemanticDecorator> getDecoratorsInRepresentationToDelete(Set<EObject> deletedElements) {
            return ExternalJavaActionTask.this.taskHelper.getDElementToClearFromSemanticElements(ExternalJavaActionTask.this.context.getRepresentation(), deletedElements);
        }

        private Set<DSemanticDecorator> getRepresentationsToDelete(Set<EObject> deletedElements) {
            HashSet representationsToDelete = Sets.newHashSet();
            if (ExternalJavaActionTask.this.context.getRepresentation() instanceof DSemanticDecorator) {
                for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(ExternalJavaActionTask.this.session)) {
                    if (!(representation instanceof DSemanticDecorator) || !deletedElements.contains(((DSemanticDecorator)((Object)representation)).getTarget())) continue;
                    representationsToDelete.add((DSemanticDecorator)((Object)representation));
                }
            }
            return representationsToDelete;
        }

        private Set<DSemanticDecorator> getOrphanedDecorators() {
            HashSet orhanedElements = Sets.newHashSet();
            TreeIterator it = ExternalJavaActionTask.this.context.getRepresentation().eAllContents();
            while (it.hasNext()) {
                EObject eObj = (EObject)it.next();
                if (!this.isOrphaned(eObj)) continue;
                orhanedElements.add((DSemanticDecorator)eObj);
            }
            if (ExternalJavaActionTask.this.context.getRepresentation() instanceof DSemanticDecorator) {
                for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(ExternalJavaActionTask.this.session)) {
                    if (!this.isOrphaned(representation)) continue;
                    orhanedElements.add((DSemanticDecorator)((Object)representation));
                }
            }
            return orhanedElements;
        }

        private boolean isOrphaned(EObject eObject) {
            return eObject instanceof DSemanticDecorator && ((DSemanticDecorator)eObject).getTarget() == null && !"DFeatureColumn".equals(eObject.eClass().getName());
        }

        private void getCommand(Collection<DSemanticDecorator> dElements) {
            ArrayList<ICommandTask> tasks = new ArrayList<ICommandTask>();
            for (DSemanticDecorator dElement : dElements) {
                if (dElement instanceof DRepresentationElement) {
                    ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)dElement);
                    DeleteDDiagramElementTask task = new DeleteDDiagramElementTask(dElement, modelAccessor);
                    tasks.add(task);
                    continue;
                }
                if (!(dElement instanceof DRepresentation)) continue;
                DeleteDRepresentationTask task = new DeleteDRepresentationTask((DRepresentation)((Object)dElement));
                task.setDeleteIncomingReferences(true);
                tasks.add(task);
            }
            TaskExecutor.execute(tasks);
        }

        private Set<EObject> elementsAndChildren(Collection<Object> semantics) {
            LinkedHashSet<EObject> elementsAndChildren = new LinkedHashSet<EObject>();
            for (Object object : semantics) {
                if (!(object instanceof EObject)) continue;
                EObject eObject = (EObject)object;
                elementsAndChildren.add(eObject);
                Iterators.addAll(elementsAndChildren, (Iterator)eObject.eAllContents());
            }
            return elementsAndChildren;
        }
    }
}

