/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ChangeContextTask;
import org.eclipse.sirius.business.internal.helper.task.operations.CreateInstanceTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ExternalJavaActionTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ForTask;
import org.eclipse.sirius.business.internal.helper.task.operations.IfTask;
import org.eclipse.sirius.business.internal.helper.task.operations.MoveElementTask;
import org.eclipse.sirius.business.internal.helper.task.operations.RemoveElementTask;
import org.eclipse.sirius.business.internal.helper.task.operations.SetValueTask;
import org.eclipse.sirius.business.internal.helper.task.operations.SwitchTask;
import org.eclipse.sirius.business.internal.helper.task.operations.UnsetTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.ContainerModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.DeleteView;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.If;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.MoveElement;
import org.eclipse.sirius.viewpoint.description.tool.RemoveElement;
import org.eclipse.sirius.viewpoint.description.tool.SetObject;
import org.eclipse.sirius.viewpoint.description.tool.SetValue;
import org.eclipse.sirius.viewpoint.description.tool.Switch;
import org.eclipse.sirius.viewpoint.description.tool.Unset;

public class ModelOperationToTask
implements Function<ModelOperation, ICommandTask> {
    private final ModelAccessor extPackage;
    private final UICallBack uiCallback;
    private final Session session;
    private final IInterpreter interpreter;
    private final CommandContext context;

    public ModelOperationToTask(ModelAccessor extPackage, UICallBack uiCallback, Session session, CommandContext context) {
        this.extPackage = extPackage;
        this.uiCallback = uiCallback;
        this.session = session;
        this.interpreter = session.getInterpreter();
        this.context = context;
    }

    public AbstractOperationTask createTask(ModelOperation op) {
        AbstractOperationTask task = null;
        Option<? extends AbstractCommandTask> optionalDialectTask = DialectManager.INSTANCE.createTask(this.context, this.extPackage, op, this.session, this.uiCallback);
        if (optionalDialectTask.some() && optionalDialectTask.get() instanceof AbstractOperationTask) {
            task = (AbstractOperationTask)optionalDialectTask.get();
        } else if (op instanceof CreateInstance) {
            CreateInstance createOp = (CreateInstance)op;
            task = new CreateInstanceTask(this.context, this.extPackage, createOp, this.interpreter);
        } else if (op instanceof SetValue) {
            SetValue setOp = (SetValue)op;
            task = new SetValueTask(this.context, this.extPackage, setOp, this.interpreter);
        } else if (op instanceof SetObject) {
            SetObject setOp = (SetObject)op;
            task = new SetValueTask(this.context, this.extPackage, setOp, this.interpreter);
        } else if (op instanceof ChangeContext) {
            ChangeContext changeOp = (ChangeContext)op;
            task = new ChangeContextTask(this.context, this.extPackage, changeOp, this.interpreter);
        } else if (op instanceof MoveElement) {
            MoveElement moveOp = (MoveElement)op;
            task = new MoveElementTask(this.context, this.extPackage, moveOp, this.interpreter);
        } else if (op instanceof RemoveElement) {
            RemoveElement removeOp = (RemoveElement)op;
            task = new RemoveElementTask(this.context, this.extPackage, removeOp, this.interpreter);
        } else if (op instanceof For) {
            For forOp = (For)op;
            task = new ForTask(this.context, this.extPackage, forOp, this.interpreter, this.uiCallback);
        } else if (op instanceof Unset) {
            Unset unset = (Unset)op;
            task = new UnsetTask(this.context, this.extPackage, unset, this.interpreter);
        } else if (op instanceof If) {
            If ifOp = (If)op;
            task = new IfTask(this.context, this.extPackage, ifOp, this.interpreter);
        } else if (op instanceof DeleteView) {
            DeleteView deleteView = (DeleteView)op;
            task = new RemoveElementTask(this.extPackage, this.context, deleteView, this.interpreter);
        } else if (op instanceof ExternalJavaAction) {
            ExternalJavaAction externalJavaAction = (ExternalJavaAction)op;
            task = new ExternalJavaActionTask(this.context, this.extPackage, externalJavaAction, this.session, this.uiCallback);
        } else if (op instanceof ExternalJavaActionCall) {
            ExternalJavaActionCall call = (ExternalJavaActionCall)op;
            task = new ExternalJavaActionTask(this.context, this.extPackage, call.getAction(), this.session, this.uiCallback);
        } else if (op instanceof Switch) {
            Switch switchOp = (Switch)op;
            task = new SwitchTask(this.context, this.extPackage, switchOp, this.session, this.uiCallback);
        }
        return task;
    }

    public ICommandTask apply(ModelOperation from) {
        AbstractOperationTask result = this.createTask(from);
        if (from instanceof ContainerModelOperation) {
            result.getChildrenTasks().addAll(Collections2.transform(((ContainerModelOperation)from).getSubModelOperations(), (Function)this));
        }
        return result;
    }
}

