/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.internal.util.GMFUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DeleteDRepresentationTask
extends AbstractCommandTask {
    protected DRepresentation representation;
    protected boolean deleteReferences;

    public DeleteDRepresentationTask(DRepresentation representation) {
        this.representation = representation;
    }

    @Override
    public void execute() {
        if (this.representation != null && this.representation.eResource() != null) {
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.representation);
            if (this.deleteReferences) {
                Session session = this.representation instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)((Object)this.representation)).getTarget()) : SessionManager.INSTANCE.getSession(this.representation);
                accessor.eDelete((EObject)this.representation, session != null ? session.getSemanticCrossReferencer() : null);
            } else {
                GMFUtil.tearDownIncomingReferences(this.representation);
                GMFUtil.tearDownOutgoingReferences(this.representation);
                SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.representation).eRemove((EObject)this.representation);
                Resource res = this.representation.eResource();
                if (res != null) {
                    res.getContents().remove((Object)this.representation);
                }
            }
        }
    }

    public void setDeleteIncomingReferences(boolean value) {
        this.deleteReferences = value;
    }

    @Override
    public String getLabel() {
        return null;
    }
}

