/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.Dialect;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.RepresentationNotification;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.identifier.RepresentationElementIdentifier;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class DialectManagerImpl
implements DialectManager {
    Map<String, Dialect> dialects = new HashMap<String, Dialect>();

    public static DialectManager init() {
        DialectManagerImpl manager = new DialectManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedDialects = EclipseUtil.getExtensionPlugins(Dialect.class, (String)"org.eclipse.sirius.dialect", (String)"class");
            for (Dialect dialect : parsedDialects) {
                manager.enableDialect(dialect);
            }
        }
        return manager;
    }

    @Override
    public Collection<RepresentationDescription> getAvailableRepresentationDescriptions(Collection<Viewpoint> vp, EObject semantic) {
        ArrayList<RepresentationDescription> descs = new ArrayList<RepresentationDescription>();
        for (Dialect dialect : this.dialects.values()) {
            descs.addAll(dialect.getServices().getAvailableRepresentationDescriptions(vp, semantic));
        }
        return descs;
    }

    @Override
    public void refreshEffectiveRepresentationDescription(DRepresentation representation, IProgressMonitor monitor) {
        if (Movida.isEnabled()) {
            for (Dialect dialect : this.dialects.values()) {
                dialect.getServices().refreshEffectiveRepresentationDescription(representation, monitor);
            }
        }
    }

    @Override
    public void refresh(DRepresentation representation, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh representation", 1);
            for (Dialect dialect : this.dialects.values()) {
                if (!dialect.getServices().canRefresh(representation)) continue;
                dialect.getServices().refresh(representation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        return this.createRepresentation(name, semantic, description, null, monitor);
    }

    @Override
    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        DRepresentation created = null;
        try {
            monitor.beginTask("Create representation : " + name, 12);
            Dialect invokedDialect = null;
            for (Dialect dialect : this.dialects.values()) {
                if (!dialect.getServices().canCreate(semantic, description)) continue;
                invokedDialect = dialect;
                break;
            }
            monitor.worked(1);
            if (invokedDialect != null) {
                if (session != null) {
                    created = invokedDialect.getServices().createRepresentation(name, semantic, description, session, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                if (created != null) {
                    RepresentationNotification notif = new RepresentationNotification(created, 1);
                    for (Dialect dialect : this.dialects.values()) {
                        if (dialect == invokedDialect) continue;
                        dialect.getServices().notify(notif);
                    }
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
        return created;
    }

    @Override
    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        Dialect invokedDialect = null;
        DRepresentation copy = null;
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().canRefresh(representation)) continue;
            invokedDialect = dialect;
        }
        if (invokedDialect != null && (copy = invokedDialect.getServices().copyRepresentation(representation, name, session, monitor)) != null) {
            RepresentationNotification notif = new RepresentationNotification(copy, 1);
            for (Dialect dialect : this.dialects.values()) {
                if (dialect == invokedDialect) continue;
                dialect.getServices().notify(notif);
            }
        }
        return copy;
    }

    @Override
    public boolean canRefresh(DRepresentation representation) {
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().canRefresh(representation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreate(EObject semantic, RepresentationDescription desc) {
        boolean canCreate = false;
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().canCreate(semantic, desc)) continue;
            canCreate = true;
            break;
        }
        return canCreate;
    }

    @Override
    public void disableDialect(Dialect dialect) {
        this.dialects.remove(dialect.getName());
    }

    @Override
    public void enableDialect(Dialect dialect) {
        this.dialects.put(dialect.getName(), dialect);
    }

    @Override
    public void notify(RepresentationNotification representation) {
        for (Dialect dialect : this.dialects.values()) {
            dialect.getServices().notify(representation);
        }
    }

    @Override
    public synchronized Collection<DRepresentation> getRepresentations(EObject semantic, Session session) {
        ArrayList<DRepresentation> reps = new ArrayList<DRepresentation>();
        for (Dialect dialect : this.dialects.values()) {
            reps.addAll(dialect.getServices().getRepresentations(semantic, session));
        }
        return reps;
    }

    @Override
    public Collection<DRepresentation> getRepresentations(RepresentationDescription representationDescription, Session session) {
        ArrayList<DRepresentation> reps = new ArrayList<DRepresentation>();
        for (Dialect dialect : this.dialects.values()) {
            reps.addAll(dialect.getServices().getRepresentations(representationDescription, session));
        }
        return reps;
    }

    @Override
    public Collection<DRepresentation> getAllRepresentations(Session session) {
        ArrayList<DRepresentation> reps = new ArrayList<DRepresentation>();
        for (Dialect dialect : this.dialects.values()) {
            reps.addAll(dialect.getServices().getAllRepresentations(session));
        }
        return reps;
    }

    @Override
    public boolean deleteRepresentation(DRepresentation representation, Session session) {
        Dialect deleter = null;
        Iterator<Dialect> it = this.dialects.values().iterator();
        while (deleter == null && it.hasNext()) {
            Dialect dialect = it.next();
            if (!dialect.getServices().deleteRepresentation(representation, session)) continue;
            deleter = dialect;
        }
        if (deleter != null) {
            RepresentationNotification notif = new RepresentationNotification(representation, 2);
            for (Dialect dialect : this.dialects.values()) {
                if (dialect == deleter) continue;
                dialect.getServices().notify(notif);
            }
        }
        return deleter != null;
    }

    @Override
    public RepresentationDescription getDescription(DRepresentation representation) {
        RepresentationDescription result = null;
        Iterator<Dialect> it = this.dialects.values().iterator();
        while (result == null && it.hasNext()) {
            result = it.next().getServices().getDescription(representation);
        }
        return result;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic) {
        this.initRepresentations(vp, semantic, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        for (Dialect dialect : this.dialects.values()) {
            dialect.getServices().initRepresentations(vp, semantic, monitor);
        }
    }

    @Override
    public boolean canCreateIdentifier(EObject representationElement) {
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().canCreateIdentifier(representationElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RepresentationElementIdentifier createIdentifier(EObject representationElement, Map<EObject, RepresentationElementIdentifier> elementToIdentifier) {
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().canCreateIdentifier(representationElement)) continue;
            return dialect.getServices().createIdentifier(representationElement, elementToIdentifier);
        }
        return null;
    }

    @Override
    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
        for (Dialect dialect : this.dialects.values()) {
            dialect.getServices().updateRepresentationsExtendedBy(session, viewpoint, activated);
        }
    }

    @Override
    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        IInterpretedExpressionQuery returnedQuery = null;
        Dialect dialect = this.getDialectFromEObjectAccordingToRepresentationDescription(target);
        if (dialect != null) {
            returnedQuery = dialect.getServices().createInterpretedExpressionQuery(target, feature);
        }
        if (returnedQuery != null) {
            return returnedQuery;
        }
        return new DefaultInterpretedExpressionQuery(target, feature);
    }

    @Override
    public boolean handles(RepresentationDescription representationDescription) {
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().handles(representationDescription)) continue;
            return true;
        }
        return false;
    }

    private Dialect getDialectFromEObjectAccordingToRepresentationDescription(EObject target) {
        Dialect foundDialect;
        block3: {
            EObject container;
            block4: {
                foundDialect = null;
                container = target;
                while (container != null && !(container instanceof RepresentationDescription) && !(container instanceof RepresentationExtensionDescription)) {
                    container = container.eContainer();
                }
                if (container == null) break block3;
                if (!(container instanceof RepresentationDescription)) break block4;
                for (Dialect candidateDialect : this.dialects.values()) {
                    if (!candidateDialect.getServices().handles((RepresentationDescription)container)) continue;
                    foundDialect = candidateDialect;
                    break block3;
                }
                break block3;
            }
            if (!(container instanceof RepresentationExtensionDescription)) break block3;
            for (Dialect candidateDialect : this.dialects.values()) {
                if (!candidateDialect.getServices().handles((RepresentationExtensionDescription)container)) continue;
                foundDialect = candidateDialect;
                break;
            }
        }
        return foundDialect;
    }

    @Override
    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        for (Dialect dialect : this.dialects.values()) {
            if (!dialect.getServices().handles(representationExtensionDescription)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidateMappingCache() {
        for (Dialect dialect : this.dialects.values()) {
            dialect.getServices().invalidateMappingCache();
        }
    }

    @Override
    public Option<? extends AbstractCommandTask> createTask(CommandContext context, ModelAccessor extPackage, ModelOperation op, Session session, UICallBack uiCallback) {
        Option<? extends AbstractCommandTask> task = Options.newNone();
        Iterator<Dialect> iterDialect = this.dialects.values().iterator();
        while (iterDialect.hasNext() && !task.some()) {
            Dialect dialect = iterDialect.next();
            task = dialect.getServices().createTask(context, extPackage, op, session, uiCallback);
        }
        return task;
    }

    @Override
    public boolean allowsEStructuralFeatureCustomization(EObject element) {
        boolean customizationAllowed = false;
        Iterator<Dialect> dialectsValueIterator = this.dialects.values().iterator();
        while (dialectsValueIterator.hasNext() && !customizationAllowed) {
            customizationAllowed = dialectsValueIterator.next().getServices().allowsEStructuralFeatureCustomization(element);
        }
        return customizationAllowed;
    }
}

